/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.org.OrgApi;
import com.xforceplus.api.model.OrgExtensionModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.api.model.org.OrgCompanyModel;
import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.company.service.CompanyApplyService;
import com.xforceplus.business.enums.CmsAppEnum;
import com.xforceplus.business.excel.ExcelService;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.tenant.excel.OrgExportExcel;
import com.xforceplus.business.tenant.service.OrgExtensionService;
import com.xforceplus.business.tenant.service.OrgParentIdsService;
import com.xforceplus.business.tenant.service.WrapperOrgService;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgExtension;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.core.utils.tree.TreeUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7ec4\u7ec7\u76f8\u5173\u63a5\u53e3", description="\u7ec4\u7ec7\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class OrgController
extends AbstractController
implements OrgApi,
com.xforceplus.api.tenant.org.OrgApi,
com.xforceplus.api.current.org.OrgApi {
    private static final Logger logger = LoggerFactory.getLogger(OrgController.class);
    private final OrgParentIdsService orgParentIdsService;
    private final ExcelService excelService;
    private final ImportFileService importFileService;
    private final WrapperOrgService wrapperOrgService;
    private final ExportFileService exportFileService;
    private final OrgExtensionService orgExtensionService;
    private final CompanyApplyService companyApplyService;
    @Value(value="${params.max-size.orgIds:100}")
    private int maxSizeOrgIds;

    public OrgController(OrgParentIdsService orgParentIdsService, ExcelService excelService, ImportFileService importFileService, WrapperOrgService wrapperOrgService, ExportFileService exportFileService, OrgExtensionService orgExtensionService, CompanyApplyService companyApplyService) {
        this.orgParentIdsService = orgParentIdsService;
        this.excelService = excelService;
        this.importFileService = importFileService;
        this.wrapperOrgService = wrapperOrgService;
        this.exportFileService = exportFileService;
        this.orgExtensionService = orgExtensionService;
        this.companyApplyService = companyApplyService;
    }

    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61", dataType="Pageable")})
    @JsonView(value={View.List.class})
    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/query"}, method={RequestMethod.GET})
    public Page<OrgStruct> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<OrgStruct> page = this.orgService.page((Specification<OrgStruct>)specification, pageable);
        return page;
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61", dataType="Pageable")})
    @JsonView(value={View.List.class})
    public ResponseEntity<Page<OrgStruct>> page(@ApiParam(value="request") OrgModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"orgId"}));
        Page<OrgStruct> result = this.orgService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u65b0\u589e\u7ec4\u7ec7")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> create(@ApiParam(value="org") OrgModel.Request.Save model) {
        model.setOrgId(null);
        OrgStruct result = this.wrapperOrgService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u516c\u53f8\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237\u516c\u53f8\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/companies"}, method={RequestMethod.GET})
    public ResponseEntity<List<OrgModel.Response.CmsTenantCompany>> companies(OrgModel.Request.QueryForCms query) {
        if (StringUtils.isEmpty((CharSequence)query.getTenantId()) && StringUtils.isEmpty((CharSequence)query.getTaxNum())) {
            throw new IllegalArgumentException("tenantId or taxNum \u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        List<OrgModel.Response.CmsTenantCompany> companyList = this.orgService.listFromCms(query.getTenantId(), query.getTaxNum());
        Optional<CmsAppEnum> optional = Stream.of(CmsAppEnum.values()).filter(x -> x.getKey().equals(query.getSource())).findAny();
        if (optional.isPresent()) {
            CmsAppEnum app = optional.get();
            companyList.forEach(c -> {
                c.setSource(app.getDesc());
                c.setIndustry(app.getDesc());
                if (app.equals((Object)CmsAppEnum.P40) || app.equals((Object)CmsAppEnum.P40_CRC) || app.equals((Object)CmsAppEnum.P40_YANGO) || app.equals((Object)CmsAppEnum.UC_PORTAL)) {
                    c.setClientCategory("\u4e2d\u5fc3\u7528\u6237");
                }
            });
        } else {
            companyList.forEach(c -> {
                c.setSource("unknown");
                c.setIndustry("unknown");
            });
        }
        return ResponseEntity.ok(companyList);
    }

    public ResponseEntity<List<OrgStruct>> byTaxNum(@ApiParam(value="taxNum", required=true) String taxNum, @ApiParam(value="companyId") Long companyId, @ApiParam(value="tenantId") Long tenantId, @ApiParam(value="orgId") Long orgId, @ApiParam(value="tenantCode") String tenantCode, @ApiParam(value="withHost, default=true") boolean withHost, @ApiParam(value="hostTenantOnly, default=null") Boolean hostTenantOnly, @ApiParam(value="status, default=null") Integer status) {
        List<Object> orgs = this.orgService.findByTaxNumAndCompanyIdAndTenantId(taxNum, companyId, tenantId, orgId, tenantCode, withHost, hostTenantOnly, status);
        if (hostTenantOnly != null && hostTenantOnly.booleanValue()) {
            orgs = orgs.stream().filter(item -> item.getCompanyId() != null && OrgType.COMPANY.equals((Object)item.getOrgType()) && item.getThisIsHost() != null && item.getThisIsHost() != false).collect(Collectors.toList());
        }
        return ResponseEntity.ok(orgs);
    }

    @AuthorizedDefinition(resources={"xforce:operation:orgs:read"})
    public ResponseEntity<Page<OrgExtension>> extensionsPage(OrgExtensionModel.Request.Query query, Pageable pageable) {
        Page<OrgExtension> page = this.orgExtensionService.page(query, pageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:operation:orgs:save"})
    public ResponseEntity<OrgExtension> createExtension(long orgId, OrgExtensionModel.Request.Create mode) {
        mode.setOrgId(Long.valueOf(orgId));
        OrgExtension entity = this.orgExtensionService.create(mode);
        return ResponseEntity.ok((Object)entity);
    }

    @AuthorizedDefinition(resources={"xforce:operation:orgs:save"})
    public ResponseEntity<OrgExtensionDto> updateExtension(long extensionId, OrgExtensionModel.Request.Update model) {
        model.setExtensionId(extensionId);
        OrgExtension entity = this.orgExtensionService.update(model);
        return ResponseEntity.ok((Object)entity);
    }

    @AuthorizedDefinition(resources={"xforce:operation:orgs:save"})
    public ResponseEntity<String> deleteExtension(long extensionId) {
        this.orgExtensionService.deleteById(extensionId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:orgs:save"})
    public ResponseEntity<String> deleteOrgExtensions(long orgId) {
        this.orgExtensionService.deleteByOrgId(orgId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> update(@ApiParam(value="orgId", required=true) long orgId, @ApiParam(value="org") OrgModel.Request.Save model) {
        OrgStruct result = this.orgService.update(orgId, model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u72b6\u6001")
    public ResponseEntity<String> updateStatus(long orgId, int status) {
        this.orgService.updateStatus(orgId, status);
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u8be6\u60c5")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> info(@ApiParam(value="orgId", required=true) long orgId, @ApiParam(value="extraInfo", defaultValue="0") int extraInfo) {
        OrgStruct result = this.orgService.findById(orgId, extraInfo);
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={View.List.class})
    @ApiOperation(value="\u7ec4\u7ec7\u7528\u6237\u5217\u8868")
    public ResponseEntity<Page<User>> users(@ApiParam(value="orgId", required=true) long orgId, Pageable pageable) {
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setOrgId(Long.valueOf(orgId));
        Page<User> result = this.userService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5b50\u8282\u70b9")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> children(@ApiParam(value="orgId", required=true) long orgId, @ApiParam(value="userId", required=false) Long userId, @ApiParam(value="withUserBoundFlag", required=false) Boolean withUserBoundFlag) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setParentId(Long.valueOf(orgId));
        query.setWithExtendParams("childrenCount");
        query.setStatus(Integer.valueOf(1));
        query.setWithUserBoundFlag(withUserBoundFlag);
        query.setUserId(userId);
        List<OrgStruct> children = this.orgService.list(query, Sort.unsorted());
        return ResponseEntity.ok(children);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5b50\u5b59\u5217\u8868", notes="\u901a\u8fc7id\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5b50\u5b59\u5217\u8868")
    @JsonView(value={View.List.class})
    public ResponseEntity<List<OrgStruct>> descendants(@ApiParam(value="orgId", required=true) long orgId) {
        List<OrgStruct> result = this.orgService.findDescendantsById(orgId);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6811", notes="\u901a\u8fc7tenantid\uff0c\u83b7\u53d6\u7ec4\u7ec7\u6811")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<OrgStruct> globalTree(OrgModel.Request.TreeQuery query) {
        query.setAttributes(Stream.of("orgId", "orgName", "orgCode", "parentId", "orgType", "status", "parentIds").collect(Collectors.toSet()));
        List<OrgStruct> result = this.orgService.findTreeByTenantId(query);
        return ResponseEntity.ok(result.stream().findFirst().orElse(null));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5b50\u5b59\u5217\u8868", notes="\u901a\u8fc7id\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5b50\u5b59\u5217\u8868")
    @JsonView(value={View.List.class})
    public ResponseEntity<Page<OrgStruct>> page(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="request") OrgModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        query.setTenantId(Long.valueOf(tenantId));
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"orgCode"}));
        Set withExtendParams = Stream.of("company", "tenant").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        Page<OrgStruct> result = this.orgService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868", notes="\u901a\u8fc7id\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    @JsonView(value={View.List.class})
    public ResponseEntity<List<OrgStruct>> list(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="request") OrgModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        query.setTenantId(Long.valueOf(tenantId));
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"orgId"}));
        List<OrgStruct> result = this.orgService.list(query, currentSort);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u521b\u5efa\u7ec4\u7ec7", notes="\u521b\u5efa\u7ec4\u7ec7")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> create(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="model", required=true) OrgModel.Request.Save model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        model.setTenantId(Long.valueOf(tenantId));
        model.setWithApplication(true);
        OrgStruct result = this.wrapperOrgService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u5411\u6307\u5b9a\u7236\u7ec4\u7ec7\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", notes="\u5411\u6307\u5b9a\u7236\u7ec4\u7ec7\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7")
    public ResponseEntity<Boolean> batchImportChildrenIntoParent(@ApiParam(value="\u79df\u6237id", required=true) String tenantKey, @ApiParam(value="\u4e0a\u7ea7\u7ec4\u7ec7id", required=true) String parentKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode, @ApiParam(value="\u7ec4\u7ec7\u96c6\u5408", required=true) List<OrgModel.Request.Save> models) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long parentId = super.toOrgId(tenantId, parentKey, byOrgCode);
        this.wrapperOrgService.save(tenantId, parentId, models);
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", notes="\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7")
    public ResponseEntity<Boolean> batchImport(@ApiParam(value="\u79df\u6237id", required=true) String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="\u7ec4\u7ec7\u96c6\u5408", required=true) List<OrgModel.Request.Save> models) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        this.wrapperOrgService.save(tenantId, models);
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u516c\u53f8\u548c\u7ec4\u7ec72.0-3", notes="\u5e76\u4e14\u7ed1\u5b9a\u516c\u53f8\u79df\u6237\u548c\u7ec4\u7ec7\u79df\u6237\u5173\u7cfb2.0")
    public <O extends OrgDto<O>> ResponseBoolenEntity<Boolean, O> batchImportWithResult(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, List<OrgModel.Request.Save> models) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        List<OrgStruct> orgStructs = this.orgService.saveWithResult(tenantId, models);
        return ResponseBoolenEntity.ok((Object)true, orgStructs);
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7", notes="\u901a\u8fc7id\uff0c\u66f4\u65b0\u7ec4\u7ec7")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> update(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="orgId", required=true) String orgKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode, @ApiParam(value="model", required=true) OrgModel.Request.Save model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        OrgStruct result = this.orgService.updateByTenantId(tenantId, orgId, model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u79df\u6237\u66f4\u65b0\u7ec4\u7ec7\u72b6\u6001")
    public ResponseEntity<String> updateStatus(String tenantKey, String orgKey, int status, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        this.orgService.updateStatus(tenantId, orgId, status);
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\u79df\u6237\u7ec4\u7ec7")
    public ResponseEntity<String> delete(String tenantKey, String orgKey, Boolean byTenantCode, Boolean byOrgCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        this.orgService.deleteByTenantIdAndId(tenantId, orgId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u7ec4\u7ec7\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\u5206\u9875\u5217\u8868")
    @JsonView(value={View.List.class})
    public ResponseEntity<Page<User>> users(String tenantKey, String orgKey, UserModel.Request.Query query, Pageable pageable) {
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        long orgId = super.toOrgId(tenantId, orgKey, query.getByOrgCode());
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgId(Long.valueOf(orgId));
        Page<User> page = this.userService.page(query, pageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u79df\u6237\u6839\u7ec4\u7ec7\u5217\u8868")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> roots(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="userId", required=false) Long userId, @ApiParam(value="withUserBoundFlag", required=false) Boolean withUserBoundFlag) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setRootOrg(Boolean.valueOf(true));
        query.setWithExtendParams("childrenCount");
        query.setStatus(Integer.valueOf(1));
        query.setUserId(userId);
        if (withUserBoundFlag != null) {
            query.setWithUserBoundFlag(withUserBoundFlag);
        } else {
            query.setWithUserBoundFlag(Boolean.valueOf(true));
        }
        query.setTree(true);
        return this.list(tenantId, query, Sort.unsorted());
    }

    @ApiOperation(value="\u79df\u6237\u7ec4\u7ec7\u5b50\u8282\u70b9")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> children(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="orgId", required=true) String orgKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode, @ApiParam(value="userId", required=false) Long userId, @ApiParam(value="withUserBoundFlag", required=false) Boolean withUserBoundFlag) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        return this.children(orgId, userId, withUserBoundFlag);
    }

    @ApiOperation(value="\u79df\u6237\u901a\u8fc7id\u83b7\u53d6\u7ec4\u7ec7")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> info(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="orgId", required=true) String orgKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        OrgStruct result = this.orgService.info(tenantId, orgId);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<OrgStruct> tree(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="treeQuery") OrgModel.Request.TreeQuery treeQuery) {
        long tenantId = super.toTenantId(tenantKey, treeQuery.getByTenantCode());
        treeQuery.setTenantId(Long.valueOf(tenantId));
        treeQuery.setAttributes(Stream.of("orgId", "orgName", "parentId", "orgType", "parentIds").collect(Collectors.toSet()));
        List<OrgStruct> result = this.orgService.findTreeByTenantId(treeQuery);
        return ResponseEntity.ok(result.stream().findFirst().orElse(null));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875\u5217\u8868")
    @JsonView(value={View.List.class})
    public ResponseEntity<List<OrgStruct>> descendants(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="orgId", required=true) String orgKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        List<OrgStruct> result = this.orgService.findDescendantsById(orgId);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7ec4\u7ec7\u5206\u9875\u67e5\u8be2")
    @JsonView(value={View.List.class})
    public ResponseEntity<Page<OrgStruct>> currentPage(OrgModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        Set withExtendParams = Stream.of("userCount", "parentName", "companyNos").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        String modules = authorizedUser.getModules();
        query.setModules(modules);
        return this.page(tenantId, query, pageable);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u65b0\u5efa\u7ec4\u7ec7")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> currentCreate(OrgModel.Request.Save model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.create(tenantId, model);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7ec4\u7ec7\u8be6\u60c5")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> currentInfo(Long orgId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.info(tenantId, orgId);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u66f4\u65b0\u7ec4\u7ec7\u8be6\u60c5")
    @JsonView(value={OrgView.OrgInfo.class})
    public ResponseEntity<OrgStruct> currentUpdate(Long orgId, @Validated(value={ValidationGroup.OnUpdate.class}) OrgModel.Request.Save model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        model.setTenantId(tenantId);
        return this.update(tenantId, orgId, model);
    }

    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5217\u8868", notes="\u901a\u8fc7id\uff0c\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    @JsonView(value={View.List.class})
    public ResponseEntity<List<OrgStruct>> currentList(OrgModel.Request.Query query, Sort sort) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.list(tenantId, query, sort);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u5220\u9664\u7ec4\u7ec7")
    public ResponseEntity<String> currentDelete(Long orgId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.delete(tenantId, orgId);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7ec4\u7ec7\u542f\u7528")
    public ResponseEntity<String> currentEnable(Long orgId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.updateStatus(tenantId, orgId, 1);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7ec4\u7ec7\u7981\u7528")
    public ResponseEntity<String> currentDisable(Long orgId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.updateStatus(tenantId, orgId, 0);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u68c0\u67e5\u7ec4\u7ec7\u540d\u79f0")
    public ResponseEntity<Boolean> currentCheckName(String orgName) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        boolean result = this.orgService.checkName(tenantId, orgName);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u6307\u5b9a\u7ec4\u7ec7\u7684\u7528\u6237\u5206\u9875\u5217\u8868")
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<Page<User>> currentOrgUsers(String orgKey, UserModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        query.setTenantId(tenantId);
        long orgId = super.toOrgId(tenantId, orgKey, query.getByOrgCode());
        query.setOrgId(Long.valueOf(orgId));
        query.setDetail(true);
        query.setIncludeIndependents(Boolean.valueOf(false));
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u521b\u5efa\u7528\u6237")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> currentCreateOrgUser(String orgKey, Boolean byOrgCode, UserModel.Request.SimpleCreate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        OrgStruct org = super.toOrg(tenantId, orgKey, byOrgCode);
        UserModel.Request.Create save = new UserModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)save);
        save.setIsRoleOverwrite(Boolean.valueOf(false));
        save.setIsOrgOverwrite(Boolean.valueOf(false));
        save.setIsTagOverwrite(Boolean.valueOf(false));
        save.setIsAppOverwrite(Boolean.valueOf(false));
        save.setIsMergeAccount(Boolean.valueOf(true));
        save.setIsStrict(Boolean.valueOf(true));
        save.setTenantId(tenantId);
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save((long)tenantId, org, save, save.isRoleOverwrite(), save.isOrgOverwrite(), save.isTagOverwrite(), save.isAppOverwrite(), save.isMergeAccount(), save.isStrict());
        if (saveUserOutput.getUserResultMap().isEmpty()) {
            throw new UnknownException("\u672a\u77e5\u9519\u8bef");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)saveUserOutput.getUserResultMap().values().stream().findFirst().orElseThrow(() -> new UnknownException("\u672a\u77e5\u9519\u8bef"));
        UserDto user = saveUserContext.getUser();
        return ResponseEntity.ok((Object)user);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u66f4\u65b0\u7528\u6237")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> currentUpdateOrgUser(String orgKey, long userId, Boolean byOrgCode, UserModel.Request.SimpleUpdate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        OrgStruct org = super.toOrg(tenantId, orgKey, byOrgCode);
        UserModel.Request.Update save = new UserModel.Request.Update();
        BeanUtils.copyProperties((Object)model, (Object)save);
        save.setUserId(Long.valueOf(userId));
        save.setIsRoleOverwrite(Boolean.valueOf(false));
        save.setIsOrgOverwrite(Boolean.valueOf(false));
        save.setIsTagOverwrite(Boolean.valueOf(false));
        save.setIsAppOverwrite(Boolean.valueOf(false));
        save.setIsMergeAccount(Boolean.valueOf(true));
        save.setIsStrict(Boolean.valueOf(true));
        save.setTenantId(tenantId);
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save((long)tenantId, org, save, save.isRoleOverwrite(), save.isOrgOverwrite(), save.isTagOverwrite(), save.isAppOverwrite(), save.isMergeAccount(), save.isStrict());
        Map userContextMap = saveUserOutput.getUserResultMap();
        if (userContextMap.values().isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c");
        }
        UserDto result = ((UserModel.Request.SaveUserContext)userContextMap.values().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c"))).getUser();
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u6307\u5b9a\u7528\u6237")
    public ResponseEntity<String> currentDeleteOrgUser(String orgKey, long userId, Boolean byOrgCode) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        this.userService.deleteByOrgIdAndId(orgId, userId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u548c\u7528\u6237\u5217\u8868")
    public ResponseEntity<String> currentOrgBindUsers(String orgKey, Boolean byOrgCode, OrgModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        this.orgService.bindUsers(tenantId, orgId, bindUsers);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u53cd\u7ed1\u5b9a\u6307\u5b9a\u7ec4\u7ec7\u548c\u7528\u6237\u5217\u8868")
    public ResponseEntity<String> currentOrgUnbindUsers(String orgKey, Boolean byOrgCode, OrgModel.Request.UnbindUsers unbindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        this.orgService.unbindUsers(tenantId, orgId, unbindUsers);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6307\u5b9a\u7ec4\u7ec7\u7684\u7ec4\u7ec7\u89d2\u8272\u5206\u9875\u5217\u8868")
    public ResponseEntity<Page<Role>> currentOrgRoles(String orgKey, RoleModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, query.getByOrgCode());
        query.setTenantId(tenantId);
        if (query.getStatus() == null) {
            query.setStatus(Integer.valueOf(1));
        }
        query.setType(Integer.valueOf(2));
        query.setOrgId(Long.valueOf(orgId));
        Page<Role> result = this.roleService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7ec4\u7ec7\u89d2\u8272\u5217\u8868")
    public ResponseEntity<Page<Role>> currentBindedOrgRoles(String orgKey, long userId, RoleModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, query.getByOrgCode());
        query.setTenantId(tenantId);
        query.setUserId(Long.valueOf(userId));
        if (query.getStatus() == null) {
            query.setStatus(Integer.valueOf(1));
        }
        query.setType(Integer.valueOf(2));
        query.setOrgId(Long.valueOf(orgId));
        Page<Role> result = this.roleService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7ed1\u5b9a\u6307\u5b9a\u7528\u6237\u548c\u7ec4\u7ec7\u89d2\u8272\u5217\u8868")
    public ResponseEntity<String> currentBindRoles(String orgKey, long userId, Boolean byOrgCode, UserModel.Request.BindRoles bindRoles) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        this.userService.bindRoles(tenantId, orgId, userId, null, null, null, bindRoles.getOrgRoleIds(), bindRoles.isOverwrite(), false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u4e0b\u7ec4\u7ec7\u6811")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<OrgStruct> currentUserOrgTree(OrgModel.Request.TreeQuery treeQuery) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        treeQuery.setTenantId(tenantId);
        Long userId = authorizedUser.getId();
        treeQuery.setUserId(userId);
        treeQuery.setStatus(Integer.valueOf(1));
        treeQuery.setAttributes(Stream.of("parentIds").collect(Collectors.toSet()));
        List<OrgStruct> list = this.orgService.findTreeByTenantId(treeQuery);
        List result = TreeUtils.buildTree(list);
        return ResponseEntity.ok(result.stream().findFirst().orElse(null));
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u4e0b\u7684\u6839\u7ec4\u7ec7\u96c6\u5408")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> currentUserOrgRoots() {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(tenantId);
        List<OrgStruct> roots = this.orgService.lazyLoadCurrentUserOrgRoots(query);
        return ResponseEntity.ok(roots);
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u4e0b\u7684\u7ec4\u7ec7\u5b50\u8282\u70b9")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> currentUserOrgChildren(String orgKey, Boolean byOrgCode) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(tenantId);
        query.setParentId(Long.valueOf(orgId));
        List<OrgStruct> children = this.orgService.lazyLoadCurrentUserOrgChildren(query);
        return ResponseEntity.ok(children);
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u4e0b\u7684\u7ec4\u7ec7\u5b50\u6811\u8282\u70b9")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<OrgStruct> currentUserOrgChildrenTree(String orgKey, Boolean byOrgCode, OrgModel.Request.TreeQuery treeQuery) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        treeQuery.setTenantId(tenantId);
        treeQuery.setRootId(Long.valueOf(orgId));
        int status = treeQuery.getStatus() == null ? 1 : treeQuery.getStatus();
        treeQuery.setStatus(Integer.valueOf(status));
        List roots = this.orgService.lazyLoadCurrentUserOrgDescendants(treeQuery);
        roots = TreeUtils.buildTree(roots);
        OrgStruct root = roots.stream().filter(o -> o.getOrgId().equals(orgId)).findFirst().orElse(null);
        return ResponseEntity.ok((Object)root);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6839\u7ec4\u7ec7\u96c6\u5408")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> currentRoots(@ApiParam(value="userId", required=false) Long userId, @ApiParam(value="withUserBoundFlag", required=false) Boolean withUserBoundFlag) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        return this.roots(tenantId, userId, withUserBoundFlag);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5b50\u8282\u70b9")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<List<OrgStruct>> currentChildren(@ApiParam(value="orgId", required=true) String orgKey, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode, @ApiParam(value="userId", required=false) Long userId, @ApiParam(value="withUserBoundFlag", required=false) Boolean withUserBoundFlag) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        return this.children(tenantId, orgId, userId, withUserBoundFlag);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6307\u5b9a\u7ec4\u7ec7\u7684\u5b50\u5b59\u7ec4\u7ec7")
    public ResponseEntity<List<OrgStruct>> currentDescendants(@ApiParam(value="orgId", required=true) String orgKey, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        return this.descendants(tenantId, orgId);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u7684\u7ec4\u7ec7\u6811")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<OrgStruct> currentTree(OrgModel.Request.TreeQuery treeQuery) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        int status = treeQuery.getStatus() == null ? 1 : treeQuery.getStatus();
        String modules = authorizedUser.getModules();
        treeQuery.setStatus(Integer.valueOf(status));
        treeQuery.setModules(modules);
        treeQuery.setWithUserBound(Boolean.valueOf(true));
        return this.tree(tenantId, treeQuery);
    }

    @ResponseBody
    @ApiOperation(value="\u91cd\u5efa\u7ec4\u7ec7paths", notes="\u91cd\u5efa\u7ec4\u7ec7paths")
    @RequestMapping(name="\u91cd\u5efa\u7ec4\u7ec7paths", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/paths/rebuild"}, method={RequestMethod.POST})
    public ResponseEntity<String> rebuildAllPaths() {
        this.orgParentIdsService.rebuildAllParentIds();
        return ResponseEntity.ok((Object)"\u91cd\u5efa\u6210\u529f");
    }

    @ResponseBody
    @ApiOperation(value="\u91cd\u5efa\u7ec4\u7ec7paths", notes="\u91cd\u5efa\u7ec4\u7ec7paths")
    @RequestMapping(name="\u91cd\u5efa\u7ec4\u7ec7paths", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/paths/rebuild"}, method={RequestMethod.POST})
    public ResponseEntity<String> rebuildAllPaths(@PathVariable(value="tenantKey") String tenantKey, @RequestParam(value="byTenantCode", required=false) Boolean byTenantCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        this.orgParentIdsService.rebuildParentIds(tenantId);
        return ResponseEntity.ok((Object)"\u91cd\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u7ec4\u7ec7\u5bfc\u5165excel")
    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7excel", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/excel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity batchImport(@PathVariable(value="tenantKey") String tenantKey, @RequestParam(value="byTenantCode", required=false) Boolean byTenantCode, @RequestParam(value="file") MultipartFile file) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        return this.excelService.processExcel(tenantId, file);
    }

    @AuthorizedDefinition(resources={"xforce:operation:orgs:read"})
    @ResponseBody
    @ApiOperation(value="\u6279\u91cf\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5bfc\u51faexcel", notes="\u6279\u91cf\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5bfc\u51faexcel")
    @RequestMapping(name="\u6279\u91cf\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5bfc\u51faexcel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/orgs/export"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> currentExportExcel(@ApiParam(value="request") @RequestBody OrgModel.Request.Query query) {
        if (CollectionUtils.isEmpty((Collection)query.getSheets())) {
            query.setSheets(OrgExportExcel.getSheets().stream().map(ExcelSheet::getSheetName).collect(Collectors.toList()));
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        query.setTenantId(authorizedUser.getTenantId());
        query.setStatus(Integer.valueOf(query.getStatus() == null ? 1 : query.getStatus()));
        this.orgService.buildCurrentQuery(query, authorizedUser);
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelConfigBusinessType businessType = ExcelConfigBusinessType.ORG_IMPORT;
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), businessType);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(businessType.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @ResponseBody
    @ApiOperation(value="\u6279\u91cf\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5bfc\u5165excel", notes="\u6279\u91cf\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5bfc\u5165excel")
    @RequestMapping(name="\u6279\u91cf\u5f53\u524d\u79df\u6237\u7ec4\u7ec7\u5bfc\u5165excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/orgs/import"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> currentImportExcel(@RequestParam(value="file") MultipartFile file) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser == null) {
            throw new IllegalArgumentException("\u6ca1\u6709\u5408\u6cd5\u4e0a\u4e0b\u6587");
        }
        Long tenantId = authorizedUser.getTenantId();
        Long userId = authorizedUser.getId();
        String businessType = ExcelConfigBusinessType.ORG_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5 excel \u6279\u91cf\u5bfc\u5165")
    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5 excel \u6279\u91cf\u5bfc\u5165", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/orgs/extensions/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportOrgExtensions(@RequestParam(value="file") MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null != authorizedUser) {
            tenantId = authorizedUser.getTenantId();
            userId = authorizedUser.getId();
        }
        String businessType = ExcelConfigBusinessType.ORG_EXTENSION_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    public ResponseEntity<List<OrgCompanyModel.Response>> orgCompaniesByTaxNum(OrgCompanyModel.Request req) {
        OrgCompanyQueryBo queryBo = new OrgCompanyQueryBo();
        BeanUtils.copyProperties((Object)req, (Object)queryBo);
        List<OrgCompanyDTO> companyDTOList = this.orgService.findOrgCompanyByTaxNum(queryBo);
        List resps = companyDTOList.stream().map(e -> {
            OrgCompanyModel.Response resp = new OrgCompanyModel.Response();
            BeanUtils.copyProperties((Object)e, (Object)resp);
            resp.setCompanyNos(e.getCompanyNos());
            return resp;
        }).collect(Collectors.toList());
        return ResponseEntity.ok(resps);
    }

    public ResponseEntity<String> delete(long orgId) {
        this.orgService.deleteById(orgId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u7ec4\u7ec7\u6210\u529f");
    }

    @JsonView(value={View.List.class})
    public ResponseEntity<List<OrgStruct>> listByOrgKeys(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, TreeModel.OrgScope scope, boolean byId, String orgKeys) {
        String[] keyArr = orgKeys.split(",");
        if (keyArr.length > this.maxSizeOrgIds) {
            throw new IllegalArgumentException("orgIds\u6761\u6570\u9650\u5236\u4e3a" + this.maxSizeOrgIds);
        }
        Set<String> keySet = Arrays.stream(keyArr).collect(Collectors.toSet());
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        List<OrgStruct> list = this.orgService.listByOrgKeys(tenantId, scope, byId, keySet);
        return ResponseEntity.ok(list);
    }

    @AuthorizedDefinition(resources={"xforce:business:user:read"})
    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u5bfc\u51fa\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u7528\u6237\u5217\u8868Excel")
    @ResponseBody
    @RequestMapping(name="\u5f53\u524d\u79df\u6237\u4e0b\u5bfc\u51fa\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u7528\u6237\u5217\u8868Excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/orgs/{orgKey}/users/excel/export"}, method={RequestMethod.GET})
    public ResponseEntity currentUsersExport(@PathVariable(value="orgKey") String orgKey, UserModel.Request.Query query) {
        if (CollectionUtils.isEmpty((Collection)query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        Long tenantId = authorizedUser.getTenantId();
        long orgId = super.toOrgId(tenantId, orgKey, query.getByOrgCode());
        query.setTenantId(tenantId);
        query.setOrgId(Long.valueOf(orgId));
        this.userService.buildCurrentQuery(query, authorizedUser);
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelConfigBusinessType businessType = ExcelConfigBusinessType.USER_IMPORT;
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), businessType);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(businessType.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }
}

