/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.user.PreRoleApi;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.tenant.service.PreRoleService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.constants.RoleTypeEnum;
import com.xforceplus.domain.tenant.PreRoleDTO;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.utils.ObjectCheckAndExcuteUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Api(value="\u9884\u7f6e\u89d2\u8272\u76f8\u5173\u63a5\u53e3", description="\u9884\u7f6e\u89d2\u8272\u76f8\u5173\u63a5\u53e3", tags={"role"})
@Validated
@Controller
public class PreRoleController
extends AbstractController
implements PreRoleApi,
com.xforceplus.api.current.user.PreRoleApi {
    private final PreRoleService preRoleService;
    private final RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PreRoleController.class);

    public PreRoleController(PreRoleService preRoleService, RoleService roleService) {
        this.preRoleService = preRoleService;
        this.roleService = roleService;
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u89d2\u8272\u4fe1\u606f", tags={"role"})
    public ResponseEntity<Role> detailInfo(long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        int res = this.preRoleService.isVisiable(tenantId, roleId);
        if (res <= 0) {
            throw new IllegalArgumentException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee\u6b64\u89d2\u8272\u4fe1\u606f");
        }
        return ResponseEntity.ok((Object)this.roleService.findById(roleId));
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u89d2\u8272\u5206\u9875\u5217\u8868", tags={"role"})
    public ResponseEntity<Page<PreRoleDTO>> currentPage(RoleModel.Request.PreRoleQuery query, Pageable pageable) {
        String code;
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        String string = Objects.isNull(query) ? null : (code = StringUtils.isEmpty((CharSequence)query.getRoleCode()) ? null : query.getRoleCode());
        String name = Objects.isNull(query) ? null : (StringUtils.isEmpty((CharSequence)query.getRoleName()) ? null : query.getRoleName());
        Page<PreRoleDTO> roles = this.preRoleService.queryPreRoleListByTenantId(tenantId, query.getId(), code, name, pageable);
        return ResponseEntity.ok(roles);
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237", tags={"role"})
    public ResponseEntity<String> bindUsers(long roleId, RoleModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        if (bindUsers == null || CollectionUtils.isEmpty((Collection)bindUsers.getUserIds())) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff01");
        }
        if (bindUsers.getUserIds().size() > 500) {
            throw new IllegalArgumentException("\u7528\u6237\u6570\u91cf\u8d85\u8fc7 500\u9650\u5236\uff01");
        }
        List<Long> userIds = this.preRoleService.checkUser(bindUsers.getUserIds(), tenantId);
        List wrongUserIds = bindUsers.getUserIds().stream().filter(item -> userIds.stream().noneMatch(userId -> userId.equals(item))).collect(Collectors.toList());
        int roleRes = this.preRoleService.isVisiable(tenantId, roleId);
        if (roleRes <= 0) {
            throw new IllegalArgumentException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee\u6b64\u89d2\u8272\u4fe1\u606f");
        }
        Role role = this.roleService.findById(roleId);
        ObjectCheckAndExcuteUtils.docheckAndExcute(role, x -> Objects.nonNull(x) && x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, x -> x, new IllegalArgumentException("\u53ea\u652f\u6301\u9884\u7f6e\u89d2\u8272\u7684\u7ed1\u5b9a"));
        this.roleService.bindUsers(roleId, userIds, bindUsers.isOverwrite());
        if (wrongUserIds.isEmpty()) {
            return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
        }
        return ResponseEntity.fail((String)"0", (String)("\u5305\u542b\u9519\u8bef\u7684userId:" + wrongUserIds.toString()));
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u89d2\u8272\u6279\u91cf\u89e3\u7ed1\u7528\u6237", tags={"role"})
    public ResponseEntity<String> unBindUsers(long roleId, RoleModel.Request.UnbindUsers bindUsers) {
        Role role = this.roleService.findById(roleId);
        Long tenant_id = UserInfoHolder.currentUser().getTenantId();
        ObjectCheckAndExcuteUtils.docheckAndExcute(role, x -> Objects.nonNull(x) && x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, x -> x, new IllegalArgumentException("\u53ea\u652f\u6301\u9884\u7f6e\u89d2\u8272\u7684\u89e3\u7ed1"));
        this.roleService.unbindUsers(tenant_id, roleId, bindUsers);
        return ResponseEntity.ok((Object)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u83b7\u53d6\u89d2\u8272\u7ed1\u5b9a\u7528\u6237\u5217\u8868", tags={"role"})
    public ResponseEntity<Page<User>> currentBindedRoles(Long roleId, UserModel.Request.Query query, Pageable pageable) {
        Role role = this.roleService.findById(roleId);
        ObjectCheckAndExcuteUtils.docheckAndExcute(role, x -> Objects.nonNull(x) && x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, x -> x, new IllegalArgumentException("\u53ea\u652f\u6301\u9884\u7f6e\u89d2\u8272\u7684\u89e3\u7ed1"));
        long tenantId = PreRoleService.PER_TENANT_ID;
        query.setTenantId(Long.valueOf(tenantId));
        query.setRoleId(roleId);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u9884\u7f6e\u89d2\u8272\u5206\u9875\u5217\u8868", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:view"})
    public ResponseEntity<Page<PreRoleDTO>> page(RoleModel.Request.PreRoleQuery query, Pageable pageable) {
        Page<PreRoleDTO> page = this.preRoleService.queryPreRoleListByAdmin(query, pageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u65b0\u589e\u9884\u7f6e\u89d2\u8272", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:save"})
    public ResponseEntity<Role> create(RoleModel.Request.PreCreate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Role role = this.preRoleService.bindServicePackageRole(model, authorizedUser.getId());
        return ResponseEntity.ok((Object)role);
    }

    @ApiOperation(value="\u4fee\u6539\u9884\u7f6e\u89d2\u8272", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:save"})
    public ResponseEntity<Role> update(long roleId, RoleModel.Request.BaseCreate model) {
        Role tmp = this.roleService.findById(roleId);
        ObjectCheckAndExcuteUtils.docheckAndExcute(tmp, x -> Objects.nonNull(x) && x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, x -> x, new IllegalArgumentException("\u4fee\u6539\u7684\u89d2\u8272\u7c7b\u578b\u975e\u6cd5"));
        model.setType(RoleTypeEnum.PRE.getType());
        model.setRoleCode(null);
        RoleModel.Request.Create create = new RoleModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)create);
        Role role = this.roleService.update(roleId, (RoleModel.Request.Save)create);
        return ResponseEntity.ok((Object)role);
    }

    @ApiOperation(value="\u9884\u7f6e\u89d2\u8272\u542f\u7528", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:save"})
    public ResponseEntity<String> enable(Long roleId) throws Throwable {
        this.preRoleService.updatePreRoleStatus(roleId, 1, x -> x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, new IllegalArgumentException("\u53ea\u80fd\u542f\u7528\u9884\u7f6e\u89d2\u8272"));
        return ResponseEntity.ok((Object)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u9884\u7f6e\u89d2\u8272\u7981\u7528", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:save"})
    public ResponseEntity<String> disable(Long roleId) throws Throwable {
        this.preRoleService.updatePreRoleStatus(roleId, 0, x -> x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, new IllegalArgumentException("\u53ea\u80fd\u7981\u7528\u9884\u7f6e\u89d2\u8272"));
        return ResponseEntity.ok((Object)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\u9884\u7f6e\u89d2\u8272", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:save"})
    public ResponseEntity<String> delete(long roleId) {
        this.preRoleService.delete(roleId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u9884\u7f6e\u89d2\u8272\u8be6\u60c5", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:operation:PreDefineRole:view"})
    public ResponseEntity<Role> info(long roleId) {
        Role role = this.roleService.findById(roleId);
        return ResponseEntity.ok((Object)role);
    }
}

