/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.tenant.TenantApi;
import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.resource.service.ServicePackageService;
import com.xforceplus.business.tenant.service.TenantExtensionService;
import com.xforceplus.business.tenant.service.TenantPolicyService;
import com.xforceplus.business.tenant.service.TenantRelationService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.domain.tenant.TenantManagerDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantExtension;
import com.xforceplus.entity.TenantPolicy;
import com.xforceplus.entity.TenantRelation;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u79df\u6237\u76f8\u5173\u63a5\u53e3", description="\u79df\u6237\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class TenantController
implements TenantApi,
com.xforceplus.api.current.tenant.TenantApi {
    private static final Logger logger = LoggerFactory.getLogger(TenantController.class);
    private final TenantService tenantService;
    private final ServicePackageService packageService;
    private final TenantExtensionService tenantExtensionService;
    private final TenantPolicyService tenantPolicyService;
    private final TenantRelationService tenantRelationService;
    private final UserService userService;
    private final ExportFileService exportFileService;

    public TenantController(TenantService tenantService, ServicePackageService packageService, TenantExtensionService tenantExtensionService, TenantPolicyService tenantPolicyService, ExportFileService exportFileService, TenantRelationService tenantRelationService, UserService userService) {
        this.tenantService = tenantService;
        this.packageService = packageService;
        this.tenantExtensionService = tenantExtensionService;
        this.tenantPolicyService = tenantPolicyService;
        this.exportFileService = exportFileService;
        this.tenantRelationService = tenantRelationService;
        this.userService = userService;
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u5206\u9875\u5217\u8868", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u79df\u6237\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"/api/global/tenants/query"}, method={RequestMethod.GET})
    public Page<Tenant> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<Tenant> page = this.tenantService.page((Specification<Tenant>)specification, pageable);
        return page;
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u5206\u9875\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u79df\u6237\u5206\u9875")
    public ResponseEntity<Page<Tenant>> page(@ApiParam(value="request", required=true) TenantModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<Tenant> result = this.tenantService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiIgnore
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u79df\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Tenant>> list(TenantModel.Request.Query query, Sort sort) {
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        List<Tenant> result = this.tenantService.list(query, currentSort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:save"})
    @ApiOperation(value="\u65b0\u589e\u79df\u6237")
    public <T extends TenantDto, O extends OrgDto<O>, C extends CompanyDto<O>, U extends UserDto<O, R, A>, R extends RoleDto, A extends AccountDto> ResponseEntity<TenantModel.Response.CreateResult<T, O, C, U, R, A>> create(@ApiParam(value="tenant", required=true) TenantModel.Request.Create model) {
        TenantModel.Response.CreateResult result = this.tenantService.create(model);
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:save"})
    @ApiOperation(value="\u66f4\u65b0\u79df\u6237\u4fe1\u606f")
    public ResponseEntity<Tenant> update(@ApiParam(value="tenantId", required=true) long tenantId, @ApiParam(value="tenant", required=true) TenantModel.Request.Save model) {
        Tenant result = this.tenantService.update(tenantId, model);
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u4fe1\u606f")
    public ResponseEntity<Tenant> info(@ApiParam(value="\u79df\u6237id", required=true) long tenantId, @ApiParam(value="\u6269\u5c55\u4fe1\u606f", required=false) String withExtendParams, @ApiParam(value="\u662f\u5426\u67e5\u8be2\u79df\u6237\u7ba1\u7406\u5458", required=false) boolean withManager) {
        List<TenantExtension> extensions;
        String[] withExtendParamsArray;
        boolean enableExtensions;
        Tenant result = this.tenantService.findById(tenantId);
        if (StringUtils.isNotBlank((CharSequence)withExtendParams) && (enableExtensions = Arrays.stream(withExtendParamsArray = StringUtils.split((String)withExtendParams, (String)",")).map(String::trim).anyMatch("extensions"::equalsIgnoreCase)) && !CollectionUtils.isEmpty(extensions = this.tenantExtensionService.getListByTenantId(tenantId))) {
            ArrayList<TenantExtension> extensionDtos = new ArrayList<TenantExtension>(extensions.size());
            for (TenantExtension extension : extensions) {
                extensionDtos.add(extension);
            }
            result.setExtensions(extensionDtos);
        }
        if (withManager) {
            ArrayList<Long> tenantIds = new ArrayList<Long>();
            tenantIds.add(tenantId);
            List<TenantManagerDto> managerDtos = this.userService.findTenantManager(tenantIds);
            if (!CollectionUtils.isEmpty(managerDtos)) {
                result.setTenantManager(managerDtos.get(0));
            }
        }
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5df2\u5b58\u5728\u79df\u6237\u4fe1\u606f")
    public ResponseEntity<Tenant> exists(String tenantCode, String tenantName) {
        if (StringUtils.isBlank((CharSequence)tenantCode) && StringUtils.isBlank((CharSequence)tenantName)) {
            throw new IllegalArgumentException("\u79df\u6237code\u548c\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        Tenant tenant = this.tenantService.findByTenantCodeOrTenantName(tenantCode, tenantName);
        return ResponseEntity.ok((Object)tenant);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u79c1\u94a5")
    public ResponseEntity<String> secret(@ApiParam(value="tenantId", required=true) long tenantId) {
        String result = this.tenantService.findSecretByTenantId(tenantId);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u79df\u6237\u79c1\u94a5")
    public ResponseEntity<Map<Long, String>> secrets() {
        Map<Long, String> result = this.tenantService.allTenantSecrets();
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiOperation(value="\u79df\u6237\u7684\u516c\u53f8\u670d\u52a1\u5305\u5173\u8054\u7684\u529f\u80fd\u96c6\u5206\u9875")
    public ResponseEntity<Page<ServicePackage>> servicePackages(long tenantId, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        ServicePackageModel.Request.Query query = new ServicePackageModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        Page<ServicePackage> result = this.packageService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:save"})
    @ApiOperation(value="\u79df\u6237\u7ed1\u5b9a\u591a\u4e2a\u516c\u53f8")
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ed1\u5b9a\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/bind"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindCompanies(@ApiParam(value="tenantId", required=true) long tenantId, List<Long> companyIds) {
        this.tenantService.bindCompanies(tenantId, companyIds);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:save"})
    @ApiOperation(value="\u79df\u6237\u7ed1\u5b9a\u5355\u4e2a\u516c\u53f8")
    @ResponseBody
    public ResponseEntity<String> bindCompany(long tenantId, long companyId) {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        companyIds.add(companyId);
        this.tenantService.bindCompanies(tenantId, companyIds);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u7b56\u7565")
    public ResponseEntity<Map<String, TenantPolicy>> policies(@ApiParam(value="tenantId", required=true) long tenantId) {
        Map<String, TenantPolicy> result = this.tenantPolicyService.policies(tenantId);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:read"})
    @ApiOperation(value="\u5bfc\u51fa\u79df\u6237")
    public ResponseEntity export(TenantModel.Request.Query query, Pageable pageable) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u5148\u9009\u62e9\u5bfc\u51fa\u6a21\u677f");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).param("P_PAGEABLE", pageable).build();
        ExcelConfigBusinessType businessType = ExcelConfigBusinessType.TENANT_EXCEL_FILE;
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), businessType);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(businessType.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:save"})
    @ApiOperation(value="\u4fdd\u5b58\u79df\u6237\u7b56\u7565")
    @ResponseBody
    @RequestMapping(name="\u4fdd\u5b58\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/policy"}, method={RequestMethod.POST})
    public ResponseEntity<String> policies(@ApiParam(value="tenantId", required=true) @PathVariable(value="id") long tenantId, @RequestBody TenantModel.Request.Policies policies) {
        this.tenantPolicyService.policies(tenantId, policies);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:tenant:save"})
    @Deprecated
    @ApiIgnore
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u4fee\u590d\u7ed1\u5b9a\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/fix"}, method={RequestMethod.GET})
    public ResponseEntity<String> fixCompanies(@ApiParam(value="tenantId", required=true) @PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) long tenantId) {
        this.tenantService.fxCompanies(tenantId);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u5f53\u524d\u8d26\u6237\u79df\u6237\u5217\u8868")
    public ResponseEntity<List<Tenant>> currentTenants() {
        List<Tenant> tenants = this.tenantService.currentTenants();
        return ResponseEntity.ok(tenants);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4fe1\u606f")
    public ResponseEntity<Tenant> currentTenantInfo() {
        return ResponseEntity.ok((Object)this.tenantService.currentTenantInfo());
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u7b56\u7565")
    public ResponseEntity<Map<String, TenantPolicy>> tenantPolicies() {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        Map<String, TenantPolicy> result = this.tenantPolicyService.policies(tenantId);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u8ddf\u8fd9\u4e2a\u79df\u6237\u6709\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u7684\u79df\u6237")
    @JsonView(value={View.class})
    public ResponseEntity<List<TenantRelation>> getTenantReleationByTenantId(Long tenantId) {
        List<TenantRelation> tenantRelationDtos = this.tenantRelationService.findTenantRelationByTenantId(tenantId);
        return ResponseEntity.ok(tenantRelationDtos);
    }

    @ApiOperation(value="\u65b0\u589e\u79df\u6237\u95f4\u5173\u7cfb")
    public ResponseEntity<String> addTenantReleation(Long parentTenantId, Long childTenantId) {
        this.tenantRelationService.addTenantReletion(parentTenantId, childTenantId);
        return ResponseEntity.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\u79df\u6237\u95f4\u5173\u7cfb")
    public ResponseEntity<String> deleteTenantReleation(Long parentTenantId, Long childTenantId) {
        this.tenantRelationService.deleteTenantReletion(parentTenantId, childTenantId);
        return ResponseEntity.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseEntity<Page<ComparedRevision<Tenant, String>>> histories(Long tenantId, Pageable pageable) {
        Tenant tenant = this.tenantService.findById(tenantId);
        Page<ComparedRevision<Tenant, String>> page = this.tenantService.findTenantHistories(tenantId, pageable);
        return ResponseEntity.ok(page);
    }
}

