/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.user.TenantUserApi;
import com.xforceplus.api.model.user.TenantUserModel;
import com.xforceplus.bo.user.TenantUserBo;
import com.xforceplus.business.tenant.service.TenantUserService;
import com.xforceplus.dto.user.TenantUserDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u79df\u6237\u7528\u6237\u67e5\u8be2")
@RestController
public class TenantUserController
implements TenantUserApi {
    private static final Logger log = LoggerFactory.getLogger(TenantUserController.class);
    private final TenantUserService tenantUserService;

    public TenantUserController(TenantUserService tenantUserService) {
        this.tenantUserService = tenantUserService;
    }

    @ApiOperation(value="\u6839\u636e\u79df\u6237ID\u67e5\u8be2\u7528\u6237\u5217\u8868\u4e3b\u8981\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    public ResponseEntity<Page<TenantUserModel.TenantUserResponse>> page(TenantUserModel.TenantUserRequest request, Pageable pageable) {
        Assert.isTrue((pageable.getPageSize() <= 100 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5927\u4e8e100\u6761");
        TenantUserBo tenantUserBo = new TenantUserBo();
        BeanUtils.copyProperties((Object)request, (Object)tenantUserBo);
        Page<TenantUserDTO> page = this.tenantUserService.findTenantUsersByTenantId(pageable, tenantUserBo);
        Page responsePage = page.map(e -> {
            TenantUserModel.TenantUserResponse response = new TenantUserModel.TenantUserResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            return response;
        });
        return ResponseEntity.ok((Object)responsePage);
    }

    @ApiOperation(value="\u6839\u636e\u79df\u6237(ID\u3001Code\u3001\u540d\u79f0)\u590d\u6742\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u7528\u6237\u5217\u8868")
    public ResponseEntity<Page<TenantUserModel.TenantUserResponse>> pageComplex(TenantUserModel.TenantUserComplexRequest request, Pageable pageable) {
        Assert.isTrue((pageable.getPageSize() <= 100 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5927\u4e8e100\u6761");
        this.checkQueryType(request);
        this.checkCreatedTimeBeginEnd(request);
        TenantUserBo tenantUserBo = new TenantUserBo();
        BeanUtils.copyProperties((Object)request, (Object)tenantUserBo);
        Page<TenantUserDTO> page = this.tenantUserService.findTenantUsersByCondition(pageable, tenantUserBo);
        Page responsePage = page.map(e -> {
            TenantUserModel.TenantUserResponse response = new TenantUserModel.TenantUserResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            return response;
        });
        return ResponseEntity.ok((Object)responsePage);
    }

    private void checkQueryType(TenantUserModel.TenantUserComplexRequest request) {
        if (1 == request.getQueryType()) {
            request.setTenantName(null);
            request.setTenantCode(null);
            Assert.isTrue((request.getTenantId() != null && request.getTenantId() >= 0L ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u79df\u6237ID\u67e5\u8be2\uff0c\u79df\u6237ID\u4e3a\u5fc5\u586b\u4e14ID\u5927\u4e8e\u7b49\u4e8e0");
            return;
        }
        if (2 == request.getQueryType()) {
            request.setTenantId(null);
            request.setTenantName(null);
            Assert.hasText((String)request.getTenantCode(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u79df\u6237Code\u67e5\u8be2\u65f6\uff0c\u79df\u6237Code\u4e3a\u5fc5\u586b");
            return;
        }
        if (3 == request.getQueryType()) {
            request.setTenantCode(null);
            request.setTenantId(null);
            Assert.hasText((String)request.getTenantName(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u79df\u6237\u540d\u79f0\u65f6\uff0c\u79df\u6237\u540d\u79f0\u4e3a\u5fc5\u586b");
        }
    }

    private void checkCreatedTimeBeginEnd(TenantUserModel.TenantUserComplexRequest request) {
        if (request.getCreatedDateBegin() != null) {
            Assert.notNull((Object)request.getCreatedDateEnd(), (String)"\u6309\u65f6\u95f4\u8303\u56f4\uff0c\u7528\u6237\u521b\u5efa\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTime tempDate = new DateTime((Object)request.getCreatedDateBegin());
        DateTime beginDate = new DateTime(tempDate.getYear(), tempDate.getMonthOfYear(), tempDate.getDayOfMonth(), 0, 0, 0);
        log.info("beginDate:{}", (Object)beginDate.toDateTime());
        tempDate = new DateTime((Object)request.getCreatedDateEnd());
        tempDate = tempDate.plusDays(1);
        request.setCreatedDateBegin(beginDate.toDate());
        request.setCreatedDateEnd(tempDate.toDate());
        Assert.isTrue((boolean)tempDate.isAfter((ReadableInstant)beginDate), (String)"\u7528\u6237\u521b\u5efa\u65f6\u95f4\u7684\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4");
    }
}

