/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.xforceplus.business.tenant.service.OrgUserService;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AsyncOrgUserService
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AsyncOrgUserService.class);
    @Value(value="${xforce.tenant.auto-bind-org-user-sleep-mills:3000}")
    private Long autoBindOrgUserSleepMills;
    private AsyncEventBus asyncEventBus;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    private OrgUserService orgUserService;

    public void afterPropertiesSet() {
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (exception, context) -> logger.error(exception.getMessage(), exception));
        this.asyncEventBus.register((Object)new AsyncProcessListener());
    }

    public void autoBindParentUsers(Long tenantId, Long orgId) {
        logger.info("tenantId:{}, orgId: {}", (Object)tenantId, (Object)orgId);
        if (tenantId == null || tenantId == 0L || orgId == null || orgId == 0L) {
            logger.info("tenantId == 0 || orgId == 0, return");
            return;
        }
        Context context = Context.builder().tenantId(tenantId).orgId(orgId).startTime(System.currentTimeMillis()).build();
        try {
            this.asyncEventBus.post((Object)context);
        }
        catch (Exception e) {
            logger.error("asyncExcelProcess:" + e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    public void destroy() {
    }

    protected class AsyncProcessListener {
        protected AsyncProcessListener() {
        }

        @Subscribe
        public void doProcess(Context context) {
            logger.info("AsyncOrgUserService:current active thread={}, max thread count={},current queue size={},task count={},completed task count={}", new Object[]{AsyncOrgUserService.this.threadPoolExecutor.getActiveCount(), AsyncOrgUserService.this.threadPoolExecutor.getLargestPoolSize(), AsyncOrgUserService.this.threadPoolExecutor.getQueue().size(), AsyncOrgUserService.this.threadPoolExecutor.getTaskCount(), AsyncOrgUserService.this.threadPoolExecutor.getCompletedTaskCount()});
            logger.info("AsyncProcessListener.doProcess, context.tenantId = {}, context.orgId = {}, waitTime={}", new Object[]{context.tenantId, context.orgId, System.currentTimeMillis() - context.startTime});
            if (context.orgId > 0L) {
                try {
                    Thread.sleep(AsyncOrgUserService.this.autoBindOrgUserSleepMills);
                }
                catch (InterruptedException e) {
                    logger.warn(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                finally {
                    try {
                        AsyncOrgUserService.this.orgUserService.autoBindUsers(context.tenantId, context.orgId, context.startTime);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage());
                    }
                }
            }
        }
    }

    static class Context {
        long tenantId;
        long orgId;
        long startTime;

        Context(long tenantId, long orgId, long startTime) {
            this.tenantId = tenantId;
            this.orgId = orgId;
            this.startTime = startTime;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public static class ContextBuilder {
            private long tenantId;
            private long orgId;
            private long startTime;

            ContextBuilder() {
            }

            public ContextBuilder tenantId(long tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            public ContextBuilder orgId(long orgId) {
                this.orgId = orgId;
                return this;
            }

            public ContextBuilder startTime(long startTime) {
                this.startTime = startTime;
                return this;
            }

            public Context build() {
                return new Context(this.tenantId, this.orgId, this.startTime);
            }

            public String toString() {
                return "AsyncOrgUserService.Context.ContextBuilder(tenantId=" + this.tenantId + ", orgId=" + this.orgId + ", startTime=" + this.startTime + ")";
            }
        }
    }
}

