/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.UserDao;
import com.xforceplus.entity.User;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class FixService {
    private final UserDao userDao;
    private final UserService userService;

    public FixService(UserDao userDao, UserService userService) {
        this.userDao = userDao;
        this.userService = userService;
    }

    @Async(value="threadPoolExecutor")
    public void fixAllUserOrgs() {
        Page users;
        Pageable userPageable = PageableFactory.create((Integer)0, (Integer)1000);
        do {
            users = this.userDao.findAll(userPageable);
            for (User user : users) {
                this.userService.fixUserOrg(user);
            }
            userPageable = users.nextPageable();
        } while (users.hasNext());
    }
}

