/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.OrgExtensionModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.constants.ExtensionStatus;
import com.xforceplus.dao.OrgExtensionDao;
import com.xforceplus.entity.OrgExtension;
import com.xforceplus.query.OrgExtensionQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@Service
public class OrgExtensionService {
    private static final Logger logger = LoggerFactory.getLogger(OrgExtensionService.class);
    private final OrgExtensionDao orgExtensionDao;

    public OrgExtensionService(OrgExtensionDao orgExtensionDao) {
        this.orgExtensionDao = orgExtensionDao;
    }

    public Page<OrgExtension> page(OrgExtensionModel.Request.Query query, Pageable pageable) {
        Specification specification = OrgExtensionQueryHelper.querySpecification((OrgExtensionModel.Request.Query)query);
        return this.orgExtensionDao.findAll(specification, pageable, EntityGraphs.named((String)"OrgExtension.graph"));
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgExtension create(OrgExtensionModel.Request.Create model) {
        List list = this.orgExtensionDao.findByOrgIdAndKey(model.getOrgId().longValue(), model.getExtensionKey());
        if (CollectionUtils.isEmpty((Collection)list)) {
            OrgExtension entity = new OrgExtension();
            entity.setOrgStructId(model.getOrgId());
            BeanUtils.copyProperties((Object)model, (Object)entity);
            entity.setStatus(ExtensionStatus.ENABLE);
            return (OrgExtension)this.orgExtensionDao.saveAndFlush((Object)entity);
        }
        String message = "\u5df2\u5b58\u5728orgId(" + model.getOrgId() + ", key(" + model.getExtensionKey() + ")\u7684\u7ec4\u7ec7\u6269\u5c55\u4fe1\u606f";
        logger.warn(message);
        throw new IllegalArgumentException(message);
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgExtension update(OrgExtensionModel.Request.Update model) {
        Optional existOrgExtensionOptional = this.orgExtensionDao.findById((Object)model.getExtensionId());
        if (!existOrgExtensionOptional.isPresent()) {
            String message = "\u4e0d\u5b58\u5728Id(" + model.getExtensionId() + ")\u7684\u7ec4\u7ec7\u6269\u5c55\u4fe1\u606f";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        OrgExtension entity = (OrgExtension)existOrgExtensionOptional.get();
        entity.setExtensionValue(model.getExtensionValue());
        entity.setStatus(ExtensionStatus.ENABLE);
        return (OrgExtension)this.orgExtensionDao.saveAndFlush((Object)entity);
    }

    public Set<OrgExtension> batchSave(Long orgStructId, List<OrgModel.Request.Extension> extensions, boolean isOverwrite) {
        if (orgStructId == null || CollectionUtils.isEmpty(extensions)) {
            return null;
        }
        List<OrgExtension> existExtensions = this.findByOrgId(orgStructId);
        Set savingExtensions = extensions.stream().filter(Objects::nonNull).map(extension -> {
            OrgExtension savingExtension;
            List exists = this.orgExtensionDao.findByOrgIdAndKey(orgStructId.longValue(), extension.getExtensionKey());
            if (CollectionUtils.isEmpty((Collection)exists)) {
                savingExtension = new OrgExtension();
                savingExtension.setOrgStructId(orgStructId);
                savingExtension.setExtensionKey(extension.getExtensionKey());
            } else {
                savingExtension = (OrgExtension)exists.get(0);
            }
            savingExtension.setExtensionValue(extension.getExtensionValue());
            return savingExtension;
        }).collect(Collectors.toSet());
        if (!savingExtensions.isEmpty()) {
            this.orgExtensionDao.saveAllAndFlush(savingExtensions);
        }
        HashSet<OrgExtension> result = new HashSet<OrgExtension>(savingExtensions);
        result.addAll(existExtensions);
        if (isOverwrite) {
            existExtensions.stream().filter(existExtension -> extensions.stream().noneMatch(extension -> extension.getExtensionKey().equals(existExtension.getExtensionKey()))).forEach(extension -> {
                logger.info("deleting OrgExtension record, {}", extension);
                try {
                    this.orgExtensionDao.deleteById(extension.getOrgExtensionId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        } else {
            result.addAll(existExtensions);
        }
        return result;
    }

    public List<OrgExtension> findByOrgId(Long orgStructId) {
        OrgExtensionModel.Request.Query query = new OrgExtensionModel.Request.Query();
        query.setOrgStructId(orgStructId);
        Specification specification = OrgExtensionQueryHelper.querySpecification((OrgExtensionModel.Request.Query)query);
        return this.orgExtensionDao.findAll(specification, Sort.unsorted());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOrgIdAndKey(long orgId, String extensionKey) {
        int result = this.orgExtensionDao.deleteByOrgIdAndKey(orgId, extensionKey);
        if (result <= 0) {
            String message = "\u4e0d\u5b58\u5728orgId(" + orgId + "), key(" + extensionKey + ")\u7684\u7ec4\u7ec7\u6269\u5c55\u4fe1\u606f";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOrgId(long orgId) {
        this.orgExtensionDao.deleteByOrgId(orgId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long extensionId) {
        this.orgExtensionDao.deleteById(Long.valueOf(extensionId));
    }

    public List<OrgExtension> findByOrgIdAndKey(long orgId, String extensionKey) {
        return this.orgExtensionDao.findByOrgIdAndKey(orgId, extensionKey);
    }
}

