/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.entity.OrgStruct;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OrgParentIdsService {
    private static final Logger logger = LoggerFactory.getLogger(OrgParentIdsService.class);
    private final OrgService orgService;
    private final OrgStructDao orgStructDao;

    public OrgParentIdsService(OrgService orgService, OrgStructDao orgStructDao) {
        this.orgService = orgService;
        this.orgStructDao = orgStructDao;
    }

    @Async(value="threadPoolExecutor")
    public void rebuildAllParentIds() {
        Page<OrgStruct> roots;
        PageRequest pageable = PageRequest.of((int)0, (int)100);
        do {
            if ((roots = this.orgService.findRoots((Pageable)pageable)).isEmpty()) {
                return;
            }
            roots.forEach(this::rebuildOneOrg);
            if (roots.isLast()) continue;
            pageable = pageable.next();
        } while (!roots.isLast());
    }

    @Async(value="threadPoolExecutor")
    public void rebuildParentIds(long tenantId) {
        Page<OrgStruct> page;
        PageRequest pageable = PageRequest.of((int)0, (int)100);
        do {
            if ((page = this.orgService.findRoots(tenantId, (Pageable)pageable)).isEmpty()) {
                return;
            }
            page.forEach(this::rebuildOneOrg);
            if (page.isLast()) continue;
            pageable = pageable.next();
        } while (!page.isLast());
    }

    public void rebuildOneOrg(OrgStruct org) {
        if (org == null) {
            return;
        }
        String parentIds = this.buildParentIds(org);
        this.orgService.updateParentIds(org.getOrgId(), parentIds);
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setParentId(org.getOrgId());
        List<OrgStruct> children = this.orgService.list(query, Sort.unsorted());
        children.forEach(this::rebuildOneOrg);
    }

    private String buildParentIds(OrgStruct entity) {
        StringBuilder builder = new StringBuilder();
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            try {
                String parentIds = this.orgStructDao.findCommittedParentIdsByOrgId(entity.getParentId().longValue());
                if (StringUtils.isNotBlank((CharSequence)parentIds)) {
                    builder.append(parentIds);
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (entity.getOrgId() != null) {
            builder.append(entity.getOrgId());
        }
        if (entity.getOrgType() != null) {
            builder.append(entity.getOrgType().separator());
        }
        return builder.toString();
    }
}

