/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.RoleResourcesetRelDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.OrgRoleDTO;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleResourcesetRel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgRoleService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrgStructDao orgStructDao;
    @Autowired
    private RoleUserRelDao roleUserRelDao;
    @Autowired
    private RoleResourcesetRelDao roleResourcesetRelDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private ResourcesetDao resourcesetDao;

    @Transactional(rollbackFor={Exception.class})
    public Role create(RoleModel.Request.OrgRoleCreate model) {
        RoleModel.Request.Create role = new RoleModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)role);
        role.setType(Integer.valueOf(2));
        if (CollectionUtils.isEmpty((Collection)model.getResourcesetIds())) {
            role.setStatus(Integer.valueOf(0));
        }
        Role base = this.roleService.create(role);
        if (!CollectionUtils.isEmpty((Collection)model.getResourcesetIds())) {
            HashSet<RoleResourcesetRel> roleResourcesetRels = new HashSet<RoleResourcesetRel>();
            for (Long resourcesetId : model.getResourcesetIds()) {
                RoleResourcesetRel rel = new RoleResourcesetRel();
                rel.setRoleId(base.getId());
                rel.setTenantId(base.getTenantId());
                rel.setResousesetId(resourcesetId);
                roleResourcesetRels.add(rel);
            }
            this.roleResourcesetRelDao.saveAllAndFlush(roleResourcesetRels);
        }
        return base;
    }

    public Page<OrgRoleDTO> page(RoleModel.Request.Query query, Pageable currentPageable) {
        query.setType(Integer.valueOf(2));
        Page<Role> rolePage = this.roleService.page(query, currentPageable);
        Page page = rolePage.map(orgRole -> {
            OrgRoleDTO dto = new OrgRoleDTO();
            BeanUtils.copyProperties((Object)orgRole, (Object)dto);
            return dto;
        });
        return page;
    }

    public OrgRoleDTO findByRoleId(Long roleId) {
        Role role = this.roleService.findById(roleId);
        OrgRoleDTO dto = new OrgRoleDTO();
        BeanUtils.copyProperties((Object)role, (Object)dto);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgRoleDTO updateByTenantId(long tenantId, Long roleId, RoleModel.Request.OrgRoleUpdate model) {
        RoleModel.Request.Update update = new RoleModel.Request.Update();
        model.setType(Integer.valueOf(2));
        BeanUtils.copyProperties((Object)model, (Object)update);
        Role role = this.roleService.updateByTenantId(tenantId, roleId, (RoleModel.Request.Save)update);
        OrgRoleDTO dto = new OrgRoleDTO();
        BeanUtils.copyProperties((Object)role, (Object)dto);
        this.saveOrgRoleResourcesets(role, model);
        return dto;
    }

    private void saveOrgRoleResourcesets(Role role, RoleModel.Request.OrgRoleUpdate model) {
        List resourcesets = Collections.emptyList();
        List rels = role.getRoleResourcesetRels();
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List resourcesetIds = rels.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toList());
            resourcesets = this.resourcesetDao.findByResourcesetIds(resourcesetIds);
        }
        if (CollectionUtils.isEmpty(resourcesets)) {
            if (model != null && !CollectionUtils.isEmpty((Collection)model.getResourcesetIds())) {
                this.batchRelOrgRoleResourcesets(role, model.getResourcesetIds());
            } else {
                this.roleService.disable(role.getId());
            }
        } else {
            Set<Long> bindedResourcesetIds = resourcesets.stream().filter(Objects::nonNull).map(ResourcesetDto::getResourcesetId).collect(Collectors.toSet());
            if (model == null || CollectionUtils.isEmpty((Collection)model.getResourcesetIds())) {
                this.unbindOrgRoleResourcesets(role.getId(), bindedResourcesetIds);
                this.roleService.disable(role.getId());
            } else {
                HashSet<Long> toBindResourcesetIds = new HashSet<Long>(model.getResourcesetIds());
                toBindResourcesetIds.removeAll(bindedResourcesetIds);
                if (!CollectionUtils.isEmpty(toBindResourcesetIds)) {
                    this.batchRelOrgRoleResourcesets(role, toBindResourcesetIds);
                }
                toBindResourcesetIds.clear();
                toBindResourcesetIds = new HashSet(model.getResourcesetIds());
                bindedResourcesetIds.removeAll(toBindResourcesetIds);
                if (!CollectionUtils.isEmpty(bindedResourcesetIds)) {
                    this.unbindOrgRoleResourcesets(role.getId(), bindedResourcesetIds);
                }
            }
        }
    }

    private void unbindOrgRoleResourcesets(Long roleId, Set<Long> bindedResourcesetIds) {
        this.roleResourcesetRelDao.unbindGradingRoleResourcesets(roleId, bindedResourcesetIds);
    }

    private void batchRelOrgRoleResourcesets(Role role, Set<Long> resourcesetIds) {
        HashSet<RoleResourcesetRel> roleResourcesetRels = new HashSet<RoleResourcesetRel>();
        for (Long resourcesetId : resourcesetIds) {
            Resourceset r = (Resourceset)this.resourcesetDao.findById((Object)resourcesetId).orElseThrow(() -> new IllegalArgumentException("\u529f\u80fd\u96c6id\u975e\u6cd5!"));
            RoleResourcesetRel rel = new RoleResourcesetRel();
            rel.setRoleId(role.getId());
            rel.setTenantId(role.getTenantId());
            rel.setResousesetId(resourcesetId);
            roleResourcesetRels.add(rel);
        }
        this.roleResourcesetRelDao.saveAllAndFlush(roleResourcesetRels);
    }

    public List<Resourceset> findBindedResourcesetsByRoleId(Long roleId) {
        Role role = this.roleService.findById(roleId);
        List resourcesets = Collections.EMPTY_LIST;
        List rels = role.getRoleResourcesetRels();
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List resourcesetIds = rels.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toList());
            return this.resourcesetDao.findByResourcesetIds(resourcesetIds);
        }
        return Collections.EMPTY_LIST;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByTenantIdAndId(long tenantId, Long roleId) {
        Role role = this.roleService.findById(roleId);
        if (role.getStatus() != 0) {
            throw new IllegalArgumentException("\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u7ec4\u7ec7\u89d2\u8272!");
        }
        this.roleService.deleteByTenantIdAndId(tenantId, roleId);
        this.orgStructDao.unSetOrgStructDefaultOrgRole(tenantId, roleId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(Long roleId) {
        Role role = this.roleService.findById(roleId);
        List resourcesets = Collections.EMPTY_LIST;
        List rels = role.getRoleResourcesetRels();
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List resourcesetIds = rels.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toList());
            resourcesets = this.resourcesetDao.findByResourcesetIds(resourcesetIds);
        }
        if (CollectionUtils.isEmpty((Collection)resourcesets)) {
            throw new IllegalArgumentException("\u8be5\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u96c6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u542f\u7528!");
        }
        boolean anyEnabled = resourcesets.stream().anyMatch(r -> r.getStatus() == 1);
        if (!anyEnabled) {
            throw new IllegalArgumentException("\u8be5\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u96c6\u90fd\u662f\u505c\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u542f\u7528!");
        }
        this.roleService.enable(roleId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(Long roleId) {
        this.roleService.disable(roleId);
    }
}

