/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.bo.user.OrgUserBO;
import com.xforceplus.bo.user.OrgUserComplexBO;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.user.OrgUserExtendDao;
import com.xforceplus.dto.user.OrgUserDTO;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.utils.OrgUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgUserService {
    private static final Logger logger = LoggerFactory.getLogger(OrgUserService.class);
    private final OrgUserRelDao orgUserRelDao;
    private final OrgStructDao orgStructDao;
    private final OrgUserExtendDao orgUserExtendDao;

    public OrgUserService(OrgUserRelDao orgUserRelDao, OrgStructDao orgStructDao, OrgUserExtendDao orgUserExtendDao) {
        this.orgUserRelDao = orgUserRelDao;
        this.orgStructDao = orgStructDao;
        this.orgUserExtendDao = orgUserExtendDao;
    }

    public void autoBindUsers(Long tenantId, Long orgId, Long startTime) {
        String parentIds = this.orgStructDao.findCommittedParentIdsByOrgId(orgId.longValue());
        if (StringUtils.isBlank((CharSequence)parentIds)) {
            logger.warn("\u4f20\u7684orgId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a, parentIds={}", (Object)orgId, (Object)parentIds);
            return;
        }
        Set parentOrgIds = OrgUtils.findOrgIdInParentIds((String)parentIds);
        if (CollectionUtils.isEmpty((Collection)parentOrgIds)) {
            logger.warn("\u4f20\u7684orgId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a", (Object)orgId);
            return;
        }
        parentOrgIds.remove(orgId);
        if (CollectionUtils.isEmpty((Collection)parentOrgIds)) {
            logger.warn("\u4f20\u7684orgId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a", (Object)orgId);
            return;
        }
        Set boundUserOrgRels = this.orgUserRelDao.findRelsByTenantIdAndOrgIds(tenantId.longValue(), (Collection)parentOrgIds);
        if (CollectionUtils.isEmpty((Collection)boundUserOrgRels)) {
            logger.warn("\u5728\u7236\u7ec4\u7ec7\u4e2d\u6ca1\u6709\u627e\u5230\u5df2\u7ed1\u5b9a\u7684\u7528\u6237,orgId={},parentOrgIds={}", (Object)orgId, (Object)parentIds);
            return;
        }
        logger.info("boundUserOrgRels.size = {}, orgId = {}", (Object)boundUserOrgRels.size(), (Object)orgId);
        Set shouldBoundUserIds = boundUserOrgRels.stream().map(OrgUserRel::getUserId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(shouldBoundUserIds)) {
            logger.warn("\u5728\u7236\u7ec4\u7ec7\u4e2d\u6ca1\u6709\u627e\u5230\u5df2\u7ed1\u5b9a\u7684\u7528\u6237");
            return;
        }
        logger.info("shouldBoundUserIds.size = {}, orgId = {}", (Object)shouldBoundUserIds.size(), (Object)orgId);
        Set boundUserIds = this.orgUserRelDao.findUserIdByTenantIdAndOrgId(tenantId.longValue(), orgId.longValue());
        HashSet shouldBoundRels = new HashSet();
        shouldBoundUserIds.removeAll(boundUserIds);
        shouldBoundUserIds.stream().filter(Objects::nonNull).forEach(shouldBoundUserId -> {
            OrgUserRel rel = new OrgUserRel();
            rel.setOrgStructId(orgId);
            rel.setTenantId(tenantId);
            rel.setUserId(shouldBoundUserId);
            rel.setFullSelectedFlag(Boolean.valueOf(true));
            shouldBoundRels.add(rel);
        });
        if (!shouldBoundRels.isEmpty()) {
            this.orgUserRelDao.saveAllAndFlush(shouldBoundRels);
        }
        logger.info("auto_bind_user_end, orgId={},count:{}, caused:{}", new Object[]{orgId, shouldBoundRels.size(), System.currentTimeMillis() - startTime});
    }

    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public Page<OrgUserDTO> pageByCurrentOrg(Pageable pageable, OrgUserBO orgUserBO) {
        return this.orgUserExtendDao.pageByCurrentOrg(pageable, orgUserBO);
    }

    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public Page<OrgUserDTO> pageByBelongOrg(Pageable pageable, OrgUserBO orgUserBO) {
        String parentIds = this.orgStructDao.findCommittedParentIdsByOrgId(orgUserBO.getOrgId().longValue());
        if (StringUtils.isEmpty((CharSequence)parentIds)) {
            throw new IllegalArgumentException("\u6ca1\u6709\u67e5\u8be2\u5230\u7ec4\u7ec7\u8282\u70b9");
        }
        orgUserBO.setParentIds(parentIds);
        return this.orgUserExtendDao.pageByBelongOrg(pageable, orgUserBO);
    }

    public Page<OrgUserDTO> pageByCurrentOrgQueryType(Pageable pageable, OrgUserComplexBO orgUserBO) {
        return this.orgUserExtendDao.pageByCurrentOrgQueryType(pageable, orgUserBO);
    }

    public Page<OrgUserDTO> pageByBelongOrgQueryType(Pageable pageable, OrgUserComplexBO orgUserBO) {
        String parentIds = null;
        if (orgUserBO.getQueryType() == 2) {
            Set parentIdsSet = this.orgStructDao.findParentIdsByOrgCode(orgUserBO.getOrgCode());
            if (!CollectionUtils.isEmpty((Collection)parentIdsSet)) {
                parentIds = parentIdsSet.stream().findFirst().orElse(null);
            }
        } else {
            parentIds = this.orgStructDao.findCommittedParentIdsByOrgId(orgUserBO.getOrgId().longValue());
        }
        if (StringUtils.isEmpty((CharSequence)parentIds)) {
            throw new IllegalArgumentException("\u6ca1\u6709\u67e5\u8be2\u5230\u7ec4\u7ec7\u8282\u70b9");
        }
        orgUserBO.setParentIds(parentIds);
        return this.orgUserExtendDao.pageByBelongOrgQueryType(pageable, orgUserBO);
    }
}

