/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.business.file.service.FileService;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.constants.RoleTypeEnum;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.RoleDao;
import com.xforceplus.dao.RoleResourcesetRelDao;
import com.xforceplus.dao.RoleServicePackageRelDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.tenant.PreRoleDTO;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleServicePackage;
import com.xforceplus.utils.ObjectCheckAndExcuteUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PreRoleService {
    private static final Logger logger = LoggerFactory.getLogger(PreRoleService.class);
    private final RoleDao roleDao;
    private final UserDao userDao;
    private final RoleUserRelDao roleUserRelDao;
    private final RoleResourcesetRelDao roleResourcesetRelDao;
    private final ResourcesetDao resourcesetDao;
    private final TenantDao tenantDao;
    private final FileService fileService;
    private final ResourcesetService resourcesetService;
    private final ResourceService resourceService;
    private final RoleServicePackageRelDao roleServicePackageRelDao;
    private final ServiceResourcesetRelDao serviceResourcesetRelDao;
    private final RoleService roleService;
    public static final Long PER_TENANT_ID = -1L;

    public PreRoleService(RoleDao roleDao, UserDao userDao, RoleUserRelDao roleUserRelDao, RoleResourcesetRelDao roleResourcesetRelDao, ResourcesetDao resourcesetDao, TenantDao tenantDao, FileService fileService, ResourcesetService resourcesetService, ResourceService resourceService, RoleServicePackageRelDao roleServicePackageRelDao, ServiceResourcesetRelDao serviceResourcesetRelDao, RoleService roleService) {
        this.roleDao = roleDao;
        this.userDao = userDao;
        this.roleUserRelDao = roleUserRelDao;
        this.roleResourcesetRelDao = roleResourcesetRelDao;
        this.resourcesetDao = resourcesetDao;
        this.tenantDao = tenantDao;
        this.fileService = fileService;
        this.resourcesetService = resourcesetService;
        this.resourceService = resourceService;
        this.roleServicePackageRelDao = roleServicePackageRelDao;
        this.serviceResourcesetRelDao = serviceResourcesetRelDao;
        this.roleService = roleService;
    }

    public int isVisiable(Long tanantId, Long roleId) {
        return this.roleDao.queryCountPreRoleByTenantIdAndRoleIdOrRoleCode(tanantId, roleId, null, RoleTypeEnum.PRE.getType().intValue());
    }

    public Integer queryCountPreRoleByTenantIdAndRoleIdOrRoleCode(Long tenantId, Long roleId, String roleCode, Integer roleTye) {
        return this.roleDao.queryCountPreRoleByTenantIdAndRoleIdOrRoleCode(tenantId, roleId, roleCode, roleTye.intValue());
    }

    public Page<PreRoleDTO> queryPreRoleListByTenantId(Long tanantId, Long roleId, String roleCode, String roleName, Pageable pageable) {
        return this.roleDao.queryPreRoleByTenantId(tanantId, roleId, roleName, roleCode, RoleTypeEnum.PRE.getType().intValue(), pageable);
    }

    public Page<PreRoleDTO> queryPreRoleListByAdmin(RoleModel.Request.PreRoleQuery query, Pageable pageable) {
        if (Objects.isNull(query)) {
            throw new IllegalArgumentException("\u65e0\u6548\u67e5\u8be2\u53c2\u6570");
        }
        return this.roleDao.queryPreRoleByAdmin(RoleTypeEnum.PRE.getType(), query.getAppId(), query.getServicePackageId(), query.getRoleName(), query.getRoleCode(), query.getId(), pageable);
    }

    @Transactional(rollbackFor={Exception.class})
    public Role bindServicePackageRole(RoleModel.Request.PreCreate model, Long userId) {
        if (Objects.isNull(model.getBindResourceSets()) || CollectionUtils.isEmpty((Collection)model.getBindResourceSets().getResourcesetIds())) {
            throw new IllegalArgumentException("\u6240\u9009\u62e9\u7684\u529f\u80fd\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkServicePackageAndSetId(model.getServicePackageId(), model.getBindResourceSets().getResourcesetIds());
        model.setType(RoleTypeEnum.PRE.getType());
        RoleModel.Request.Create create = new RoleModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)create);
        create.setTenantId(PER_TENANT_ID);
        Role role = this.roleService.create(create);
        RoleServicePackage roleServicePackage = new RoleServicePackage();
        roleServicePackage.setServicePackageId(model.getServicePackageId());
        roleServicePackage.setRoleId(role.getId());
        roleServicePackage.setCreateTime(new Date());
        roleServicePackage.setStatus(1);
        roleServicePackage.setUserId(userId);
        this.roleServicePackageRelDao.save((Object)roleServicePackage);
        return role;
    }

    private boolean checkServicePackageAndSetId(Long serviceId, List<Long> setId) {
        List res = this.serviceResourcesetRelDao.findResourcesetIdByServicePackageId(serviceId.longValue());
        if (CollectionUtils.isEmpty((Collection)res)) {
            throw new IllegalArgumentException("\u8be5\u8d44\u6e90\u5305\u4e0b\u529f\u80fd\u96c6\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(setId)) {
            throw new IllegalArgumentException("\u529f\u80fd\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return CollectionUtils.isEqualCollection((Collection)res, setId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Long roleId) {
        Role role = this.roleService.findById(roleId);
        ObjectCheckAndExcuteUtils.docheckAndExcute(role, x -> Objects.nonNull(x) && x.getType().compareTo(RoleTypeEnum.PRE.getType()) == 0, x -> x, new IllegalArgumentException("\u53ea\u80fd\u5220\u9664\u9884\u7f6e\u89d2\u8272"));
        long userCount = this.roleUserRelDao.countByRoleId(roleId.longValue());
        if (userCount > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5173\u8054\u7528\u6237\u7684\u89d2\u8272(" + roleId + ")\u4e0d\u80fd\u5220\u9664");
        }
        this.roleService.commonDeleteRole(roleId);
        this.roleServicePackageRelDao.deleteByRoleId(roleId);
    }

    public List<Long> checkUser(List<Long> userId, Long tenantId) {
        return this.userDao.checkUser(userId, tenantId);
    }

    public void updatePreRoleStatus(Long roleId, Integer status, Function<Role, Boolean> function, Throwable throwable) throws Throwable {
        Role role = this.roleService.findById(roleId);
        Boolean res = function.apply(role);
        if (!res.booleanValue()) {
            throw throwable;
        }
        this.roleService.updateStatus(roleId, status);
    }

    public List<Long> queryUserPreRole(Long tenantId, Long userId, Boolean binded) {
        Boolean bl = binded = Objects.isNull(binded) ? Boolean.FALSE : binded;
        if (Objects.isNull(userId) || Objects.isNull(tenantId)) {
            return Collections.EMPTY_LIST;
        }
        List roleUserRels = this.roleUserRelDao.findByUserId(userId.longValue());
        List<Object> roleIds = Lists.newArrayList((Object[])new Long[]{0L});
        if (CollectionUtils.isNotEmpty((Collection)roleUserRels)) {
            roleIds = roleUserRels.stream().map(roleUserRel -> roleUserRel.getRoleId()).collect(Collectors.toList());
        }
        return this.roleDao.queryUserPreRole(tenantId, binded, (List)roleIds);
    }
}

