/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.dto.RoleAccountImportDto;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.utils.BatchUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RoleAccountImportServiceImpl
implements ExcelReaderService {
    public static final String ACTION_BIND = "\u7ed1\u5b9a";
    public static final String ACTION_UNBIND = "\u89e3\u7ed1";
    public static final List<String> ACTION_LISTS = Arrays.asList("\u7ed1\u5b9a", "\u89e3\u7ed1");
    private static final Logger logger = LoggerFactory.getLogger(RoleAccountImportServiceImpl.class);
    @Resource
    private UserService userService;
    private static final HashMap<String, Integer> HEADER_ROW_NUMBER = new HashMap(1);

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ROLE_BIND_ACCOUNT_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            Integer headerRow = this.getSheetHeaderNumber().get(sheet.getSheetName());
            if (headerRow == null) {
                headerRow = 2;
            }
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<RoleAccountImportDto>)rows));
            context.getSimpleExcelReader().read(RoleAccountImportDto.class, excelDataListener, headerRow);
        }
        return context;
    }

    public void saveData(MessageRow messageRows, Context context, List<RoleAccountImportDto> list) {
        logger.info("list:{}", (Object)JSON.toJSONString(list));
        try {
            BatchUtils.doBatchAsync(list, sublist -> this.batchAsyncSaveData(messageRows, context, (List<RoleAccountImportDto>)sublist)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("error async batch save data {} ", (Object)exception.getMessage());
            throw new IllegalArgumentException(exception.getMessage());
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void batchAsyncSaveData(MessageRow messageRows, Context context, List<RoleAccountImportDto> list) {
        for (RoleAccountImportDto e : list) {
            logger.info("e:{}", (Object)JSON.toJSONString((Object)e));
            if (!e.getValidatedStatus().booleanValue()) {
                messageRows.fail(e.getRowIndex(), e.getValidatedMessage());
                continue;
            }
            String msg = this.userService.bindRoleAccountRel(e, context.getFileDTO().getTenantId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
                messageRows.fail(e.getRowIndex(), msg);
                continue;
            }
            messageRows.success(e.getRowIndex());
        }
    }

    @Override
    public HashMap<String, Integer> getSheetHeaderNumber() {
        return HEADER_ROW_NUMBER;
    }

    static {
        HEADER_ROW_NUMBER.put("\u6279\u91cf\u89d2\u8272\u6388\u6743\u8d26\u53f7", 2);
    }
}

