/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.business.file.service.FileService;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.RoleDao;
import com.xforceplus.dao.RoleResourcesetRelDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.tenant.OrgRoleCntDTO;
import com.xforceplus.domain.tenant.RoleBindDTO;
import com.xforceplus.domain.tenant.RoleExportDto;
import com.xforceplus.domain.tenant.RoleRelAccountExportDto;
import com.xforceplus.domain.tenant.RoleResourcesetRelDto;
import com.xforceplus.domain.tenant.RoleUserCntDTO;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleResourcesetRel;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.User;
import com.xforceplus.query.ResourcesetQueryHelper;
import com.xforceplus.query.RoleQueryHelper;
import com.xforceplus.utils.excel.ExcelUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import io.geewit.utils.uuid.UUID;
import io.geewit.web.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RoleService {
    private static final Logger logger = LoggerFactory.getLogger(RoleService.class);
    private final RoleDao roleDao;
    private final UserDao userDao;
    private final RoleUserRelDao roleUserRelDao;
    private final RoleResourcesetRelDao roleResourcesetRelDao;
    private final ResourcesetDao resourcesetDao;
    private final TenantDao tenantDao;
    private final FileService fileService;
    private final ResourcesetService resourcesetService;
    private final ResourceService resourceService;

    public RoleService(RoleDao roleDao, UserDao userDao, RoleUserRelDao roleUserRelDao, RoleResourcesetRelDao roleResourcesetRelDao, ResourcesetDao resourcesetDao, TenantDao tenantDao, FileService fileService, ResourcesetService resourcesetService, ResourceService resourceService) {
        this.roleDao = roleDao;
        this.userDao = userDao;
        this.roleUserRelDao = roleUserRelDao;
        this.roleResourcesetRelDao = roleResourcesetRelDao;
        this.resourcesetDao = resourcesetDao;
        this.tenantDao = tenantDao;
        this.fileService = fileService;
        this.resourcesetService = resourcesetService;
        this.resourceService = resourceService;
    }

    public Page<Role> page(RoleModel.Request.Query query, Pageable pageable) {
        Page<Role> page = this.rawPage(query, pageable);
        if (!page.isEmpty()) {
            Set roleIds = page.stream().map(Role::getId).collect(Collectors.toSet());
            List roleUserCntDTOS = this.roleDao.getRoleUserCntByRoleIds(query.getTenantId(), roleIds);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            if (!CollectionUtils.isEmpty((Collection)roleUserCntDTOS)) {
                for (RoleUserCntDTO roleUserCntDTO : roleUserCntDTOS) {
                    map.put(roleUserCntDTO.getRoleId(), roleUserCntDTO.getRoleUserCnt());
                }
                for (Role role : page) {
                    role.setUserCnt(map.getOrDefault(role.getId(), 0L));
                }
            }
        }
        return page;
    }

    public Page<Role> preRolePage(RoleModel.Request.Query query, Pageable pageable) {
        query.setType(Integer.valueOf(3));
        query.setAttributes(Stream.of("role", "appName", "servicePackageName").collect(Collectors.toSet()));
        return this.rawPage(query, pageable);
    }

    private Page<Role> rawPage(RoleModel.Request.Query query, Pageable pageable) {
        Page page;
        if (query.isTupleSelection()) {
            Page tuples = this.roleDao.findTuples(query, pageable);
            List contents = tuples.getContent().stream().map(RoleQueryHelper.tupleMapper((RoleModel.Request.Query)query)).collect(Collectors.toList());
            page = new PageImpl(contents, pageable, tuples.getTotalElements());
        } else {
            Specification specification = RoleQueryHelper.querySpecification((RoleModel.Request.Query)query);
            page = this.roleDao.findAll(specification, pageable, EntityGraphs.named((String)"Org.graph"));
        }
        if (page == null) {
            return Page.empty((Pageable)pageable);
        }
        return page;
    }

    public Page<Role> page(Specification<Role> specification, Pageable pageable) {
        return this.roleDao.findAll(specification, pageable);
    }

    public List<Role> list(RoleModel.Request.Query query, Sort sort) {
        Specification specification = RoleQueryHelper.querySpecification((RoleModel.Request.Query)query);
        List list = this.roleDao.findAll(specification, sort);
        return list;
    }

    public List<Role> listByUserId(long userId) {
        RoleModel.Request.Query roleQuery = new RoleModel.Request.Query();
        roleQuery.setUserId(Long.valueOf(userId));
        roleQuery.setStatus(Integer.valueOf(1));
        roleQuery.setFilterExpired(true);
        return this.list(roleQuery, Sort.unsorted());
    }

    public List<Role> list(Specification<Role> specification, Sort sort) {
        return this.roleDao.findAll(specification, sort);
    }

    public Role findOne(Specification<Role> specification) {
        return (Role)this.roleDao.findOne(specification).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={Exception.class})
    public Role create(RoleModel.Request.Create model) {
        if (StringUtils.isBlank((CharSequence)model.getRoleCode()) || StringUtils.isBlank((CharSequence)model.getRoleName())) {
            throw new IllegalArgumentException("\u89d2\u8272\u4ee3\u7801\u6216\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Role entity = null;
        if (Objects.isNull(model.getTenantId())) {
            throw new IllegalArgumentException("\u89d2\u8272\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List list = this.roleDao.findByListTenantIdAndCode(model.getTenantId().longValue(), model.getRoleCode());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new IllegalArgumentException("\u89d2\u8272\u4ee3\u7801\u5df2\u5b58\u5728!");
        }
        List ll = this.roleDao.findByListTenantIdAndName(model.getTenantId(), model.getRoleName());
        if (!CollectionUtils.isEmpty((Collection)ll)) {
            throw new IllegalArgumentException("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728!");
        }
        if (entity == null) {
            entity = new Role();
            entity.setCode(model.getRoleCode());
        }
        BeanUtils.copyProperties((Object)model, entity);
        entity.setName(model.getRoleName());
        entity = (Role)this.roleDao.saveAndFlush((Object)entity);
        if (model.getBindResourceSets() != null) {
            this.bindResourceSets(model.getTenantId(), entity, model.getBindResourceSets());
        }
        if (null != model.getBindResources()) {
            this.bindResources(entity.getTenantId(), entity, model.getBindResources());
        }
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public Role save(RoleModel.Request.Save model) {
        Role entity = null;
        if (model.getTenantId() != null && model.getTenantId() > 0L) {
            entity = this.roleDao.findByTenantIdAndCode(model.getTenantId().longValue(), model.getRoleCode());
        }
        if (entity == null) {
            entity = new Role();
            entity.setCode(model.getRoleCode());
        }
        BeanUtils.copyProperties((Object)model, entity);
        if (StringUtils.isNotBlank((CharSequence)model.getRoleCode())) {
            entity.setCode(model.getRoleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getRoleName())) {
            entity.setName(model.getRoleName());
        }
        entity = (Role)this.roleDao.saveAndFlush((Object)entity);
        this.bindResourceSets(entity, model.getBindResourceSets());
        return entity;
    }

    public void updateByCheck(long roleId, RoleModel.Request.Save model, Function<Role, Boolean> function) {
        Role existEntity = this.findById(roleId);
        function.apply(existEntity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Role update(long roleId, RoleModel.Request.Save model) {
        Role existEntity = this.findById(roleId);
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        existEntity = (Role)this.roleDao.saveAndFlush((Object)existEntity);
        if (model.getBindResourceSets() != null) {
            this.bindResourceSets(existEntity, model.getBindResourceSets());
        }
        return existEntity;
    }

    public Role findById(long roleId) {
        Role role = (Role)this.roleDao.findById((Object)roleId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272\u5b9e\u4f53(" + roleId + ")"));
        List<Resourceset> resourcesets = this.resourcesetService.listByRoleId(roleId);
        Set resourcesetSet = resourcesets.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        role.setResourcesets(resourcesetSet);
        return role;
    }

    public Role findByTenantId(long tenantId, long roleId) {
        RoleModel.Request.Query query = new RoleModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setId(Long.valueOf(roleId));
        Specification specification = RoleQueryHelper.querySpecification((RoleModel.Request.Query)query);
        Role role = this.findOne((Specification<Role>)specification);
        List<Resourceset> resourcesets = this.resourcesetService.listByRoleId(role.getId());
        Set resourcesetSet = resourcesets.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        ResourcesetModel.Request.Query resourcesetQuery = new ResourcesetModel.Request.Query();
        resourcesetQuery.setRoleId(Long.valueOf(roleId));
        Optional<Resourceset> customResourceset = this.resourcesetService.findOne(resourcesetQuery);
        if (customResourceset.isPresent()) {
            Resourceset resourceset = customResourceset.get();
            List<Resource> resources = this.resourceService.listByResourcesetId(resourceset.getResourcesetId(), 1);
            Set resourceSet = resources.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            role.setResources(resourceSet);
        }
        role.setResourcesets(resourcesetSet);
        return role;
    }

    public Role findByRoleId(Long tenantId, Long roleId) {
        RoleModel.Request.Query query = new RoleModel.Request.Query();
        query.setTenantId(tenantId);
        query.setId(roleId);
        Specification specification = RoleQueryHelper.querySpecification((RoleModel.Request.Query)query);
        return this.findOne((Specification<Role>)specification);
    }

    public RoleBindDTO findBindedById(Long tenantId, Long roleId) {
        Role role = this.findByRoleId(tenantId, roleId);
        RoleBindDTO roleBindDTO = new RoleBindDTO();
        BeanUtils.copyProperties((Object)role, (Object)roleBindDTO);
        return roleBindDTO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long roleId) {
        Role role = this.findById(roleId);
        if (role.getTenantId() == null || role.getTenantId() <= 0L) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u89d2\u8272\u4e0d\u80fd\u5220\u9664");
        }
        this.commonDeleteRole(roleId);
    }

    public void commonDeleteRole(Long roleId) {
        long userCount = this.roleUserRelDao.countByRoleId(roleId.longValue());
        if (userCount > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5173\u8054\u7528\u6237\u7684\u89d2\u8272(" + roleId + ")\u4e0d\u80fd\u5220\u9664");
        }
        this.roleDao.deleteById(roleId);
        this.roleResourcesetRelDao.deleteByRoleId(roleId.longValue());
        this.roleUserRelDao.deleteByRoleId(roleId.longValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public Role updateByTenantId(long tenantId, long roleId, RoleModel.Request.Save model) {
        Role existEntity = this.findByTenantId(tenantId, roleId);
        BeanUtils.copyProperties((Object)model, (Object)existEntity, (String[])((String[])Stream.of("roleResourcesetRels", "roleUserRels", "tags").toArray(String[]::new)));
        if (StringUtils.isNotBlank((CharSequence)model.getRoleName())) {
            existEntity.setName(model.getRoleName());
        }
        existEntity = (Role)this.roleDao.saveAndFlush((Object)existEntity);
        if (model.getBindResourceSets() != null) {
            this.bindResourceSets(tenantId, existEntity, model.getBindResourceSets());
        }
        if (null != model.getBindResources()) {
            this.bindResources(tenantId, existEntity, model.getBindResources());
        }
        return existEntity;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByTenantIdAndId(long tenantId, long roleId) {
        Role existEntity = this.findByTenantId(tenantId, roleId);
        long userCount = this.roleUserRelDao.countByRoleId(roleId);
        if (userCount > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5173\u8054\u7528\u6237\u7684\u89d2\u8272(" + roleId + ")\u4e0d\u80fd\u5220\u9664");
        }
        this.roleDao.deleteById(Long.valueOf(roleId));
        this.roleResourcesetRelDao.deleteByRoleId(roleId);
        this.roleUserRelDao.deleteByRoleId(roleId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindUsers(long roleId, RoleModel.Request.BindUsers bindUsers) {
        if (bindUsers == null) {
            return;
        }
        this.bindUsers(roleId, bindUsers.getUserIds(), bindUsers.isOverwrite());
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindUsers(long roleId, Collection<Long> userIds, boolean isOverwrite) {
        Set relIds;
        Role role = (Role)this.roleDao.findById((Object)roleId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272\u5b9e\u4f53(" + roleId + ")"));
        List existRels = this.roleUserRelDao.findByRoleId(roleId);
        Set insertingRels = userIds.stream().filter(Objects::nonNull).filter(userId -> existRels.stream().map(RoleUserRel::getUserId).noneMatch(relUserId -> relUserId.equals(userId))).map(userId -> {
            Optional userOptional = this.userDao.findById(userId);
            if (userOptional.isPresent()) {
                RoleUserRel roleUserRel = new RoleUserRel();
                roleUserRel.setTenantId(((User)userOptional.get()).getTenantId());
                roleUserRel.setRelType(role.getType().intValue());
                roleUserRel.setRoleId(Long.valueOf(roleId));
                roleUserRel.setUserId(userId);
                return roleUserRel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!insertingRels.isEmpty()) {
            this.roleUserRelDao.saveAllAndFlush(insertingRels);
        }
        if (isOverwrite && (relIds = existRels.stream().filter(rel -> userIds.stream().noneMatch(userId -> userId.equals(rel.getUserId()))).map(RoleUserRel::getId).collect(Collectors.toSet())) != null && !relIds.isEmpty()) {
            this.roleUserRelDao.deleteAllByIdInBatch(relIds);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long roleId, int status) {
        this.updateStatus(0L, roleId, status);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(long roleId) {
        this.updateStatus(roleId, 1);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(long roleId) {
        this.updateStatus(roleId, 0);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long tenantId, long roleId, int status) {
        RoleModel.Request.Query query = new RoleModel.Request.Query();
        if (tenantId > 0L) {
            query.setTenantId(Long.valueOf(tenantId));
        }
        query.setId(Long.valueOf(roleId));
        Specification specification = RoleQueryHelper.queryOneSpecification((RoleModel.Request.Query)query);
        this.roleDao.findOne(specification).orElseThrow(() -> new IllegalArgumentException("\u627e\u4e0d\u5230\u89d2\u8272\u5b9e\u4f53(" + roleId + ")"));
        this.roleDao.updateStatus(roleId, status);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResourceSets(long roleId, RoleModel.Request.BindResourceSets bindResourceSets) {
        Role role = this.findById(roleId);
        this.bindResourceSets(role, bindResourceSets);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResourceSets(Long tenantId, Role role, RoleModel.Request.BindResourceSets bindResourceSets) {
        if (bindResourceSets == null || bindResourceSets.getResourcesetIds() == null) {
            return;
        }
        List resourceSetList = this.resourcesetDao.findByResourcesetIds(bindResourceSets.getResourcesetIds());
        List existRels = this.roleResourcesetRelDao.findByRoleId(role.getId().longValue());
        if (CollectionUtils.isEmpty((Collection)resourceSetList)) {
            this.bindResourceSetsOverwrite(existRels, bindResourceSets);
            return;
        }
        Set bindedResourceSetIds = existRels.stream().map(e -> e.getResousesetId()).collect(Collectors.toSet());
        Set insertingRels = resourceSetList.stream().filter(e -> !bindedResourceSetIds.contains(e.getResourcesetId())).map(e -> {
            RoleResourcesetRel insertingRel = new RoleResourcesetRel();
            insertingRel.setTenantId(tenantId);
            insertingRel.setRoleId(role.getId());
            insertingRel.setResousesetId(e.getResourcesetId());
            return insertingRel;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(insertingRels)) {
            this.roleResourcesetRelDao.saveAllAndFlush(insertingRels);
        }
        this.bindResourceSetsOverwrite(existRels, bindResourceSets);
    }

    private void bindResourceSetsOverwrite(List<RoleResourcesetRel> existRels, RoleModel.Request.BindResourceSets bindResourceSets) {
        if (bindResourceSets.isOverwrite()) {
            existRels.stream().filter(rel -> bindResourceSets.getResourcesetIds().stream().noneMatch(resourcesetId -> resourcesetId.equals(rel.getResousesetId()))).forEach(rel -> {
                logger.info("deleting Role-Resourceset-Rel record, {}", rel);
                try {
                    this.roleResourcesetRelDao.deleteById(rel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResourceSets(Role role, RoleModel.Request.BindResourceSets bindResourceSets) {
        this.bindResourceSets(role.getTenantId(), role, bindResourceSets);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseBoolenEntity<Boolean, RoleModel.Request.BindResourceSet> bindResourceSets(List<RoleModel.Request.BindResourceSet> bindResourceSets) {
        if (CollectionUtils.isEmpty(bindResourceSets)) {
            return ResponseBoolenEntity.fail((String)"0", (String)"\u5165\u53c2\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<RoleModel.Request.BindResourceSet> resultBindResourceSet = new ArrayList<RoleModel.Request.BindResourceSet>(bindResourceSets.size());
        ArrayList<RoleModel.Request.BindResourceSet> successResult = new ArrayList<RoleModel.Request.BindResourceSet>();
        HashSet roleResourcesetRels = new HashSet();
        for (RoleModel.Request.BindResourceSet bindResourceSet : bindResourceSets) {
            List rolses = this.roleDao.findByTenantIdAndRoleCodes(bindResourceSet.getTenantId().longValue(), (Collection)Stream.of(bindResourceSet.getRoleCode()).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty((Collection)rolses)) {
                bindResourceSet.setMsg("\u6ca1\u6709\u8fd4\u73b0\u89d2\u8272");
                bindResourceSet.setResult(false);
                resultBindResourceSet.add(bindResourceSet);
                continue;
            }
            if (rolses.size() > 1) {
                bindResourceSet.setMsg("\u53d1\u73b0\u591a\u4e2a\u89d2\u8272");
                bindResourceSet.setResult(false);
                resultBindResourceSet.add(bindResourceSet);
                continue;
            }
            successResult.add(bindResourceSet);
            List rels = rolses.stream().map(role -> {
                RoleResourcesetRel roleResourcesetRel = new RoleResourcesetRel();
                roleResourcesetRel.setResousesetId(bindResourceSet.getResourceSetId());
                roleResourcesetRel.setRoleId(role.getId());
                roleResourcesetRel.setTenantId(bindResourceSet.getTenantId());
                return roleResourcesetRel;
            }).collect(Collectors.toList());
            roleResourcesetRels.addAll(rels);
        }
        try {
            this.roleResourcesetRelDao.saveAllAndFlush(roleResourcesetRels);
            successResult.forEach(se -> se.setResult(true));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            for (RoleModel.Request.BindResourceSet se2 : successResult) {
                se2.setResult(false);
                se2.setMsg(e.getMessage());
            }
        }
        successResult.addAll(resultBindResourceSet);
        return ResponseBoolenEntity.ok((Object)true, successResult);
    }

    public void bindUsers(long tenantId, long roleId, List<Long> userIds, boolean isOverwrite, Integer relType) {
        RoleModel.Request.Query query = new RoleModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setId(Long.valueOf(roleId));
        Specification specification = RoleQueryHelper.queryOneSpecification((RoleModel.Request.Query)query);
        Role existsRole = (Role)this.roleDao.findOne(specification).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272\u5b9e\u4f53(" + roleId + ")"));
        List existRels = this.roleUserRelDao.findByRoleId(existsRole.getId().longValue());
        if (userIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u7f3a\u5c11\u7528\u6237id\u96c6\u5408");
        }
        Set insertingRels = userIds.stream().filter(Objects::nonNull).filter(userId -> existRels.stream().map(RoleUserRel::getUserId).noneMatch(relUserId -> relUserId.equals(userId))).map(userId -> {
            Optional userOptional = this.userDao.findById(userId);
            if (userOptional.isPresent()) {
                RoleUserRel roleUserRel = new RoleUserRel();
                roleUserRel.setTenantId(((User)userOptional.get()).getTenantId());
                roleUserRel.setRoleId(Long.valueOf(roleId));
                roleUserRel.setUserId(userId);
                roleUserRel.setRelType(relType.intValue());
                return roleUserRel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!insertingRels.isEmpty()) {
            this.roleUserRelDao.saveAllAndFlush(insertingRels);
        }
        if (isOverwrite) {
            existRels.stream().filter(rel -> userIds.stream().noneMatch(userId -> userId.equals(rel.getUserId()))).forEach(rel -> {
                logger.info("deleting Role-User-Rel record, {}", rel);
                try {
                    this.roleUserRelDao.deleteById(rel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindUsers(long tenantId, long roleId, RoleModel.Request.BindUsers bindUsers, Integer relType) {
        if (bindUsers == null) {
            return;
        }
        this.bindUsers(tenantId, roleId, bindUsers.getUserIds(), bindUsers.isOverwrite(), relType);
    }

    @Transactional(rollbackFor={Exception.class})
    public void sysSave(RoleModel.Request.SysCreate model) {
        this.checkResourceSetIdsAndTenantIds(model.getResourcesetIds(), model.getTenantIds());
        model.setResourcesetIds(model.getResourcesetIds().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        model.setTenantIds(model.getTenantIds().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        String roleCode = UUID.randomUUID().toString();
        RoleModel.Request.Save save = new RoleModel.Request.Save();
        BeanUtils.copyProperties((Object)model, (Object)save);
        save.setRoleCode(roleCode);
        save.setTenantId(Long.valueOf(0L));
        Role role = this.save(save);
        this.doSysRole(role, model, true);
    }

    private void checkResourceSetIdsAndTenantIds(Set<Long> resourceSetIds, Set<Long> tenantIds) {
        if (CollectionUtils.isEmpty(resourceSetIds)) {
            throw new IllegalArgumentException("\u7ed1\u5b9a\u8d44\u6e90\u96c6\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(tenantIds)) {
            throw new IllegalArgumentException("\u7ed1\u5b9a\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void sysUpdate(Long roleId, RoleModel.Request.SysCreate model) {
        this.checkResourceSetIdsAndTenantIds(model.getResourcesetIds(), model.getTenantIds());
        model.setResourcesetIds(model.getResourcesetIds().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        model.setTenantIds(model.getTenantIds().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        Role role = this.findById(roleId);
        if (null == role) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272(" + roleId + ")");
        }
        role.setName(model.getRoleName());
        role.setStatus(model.getStatus());
        role.setRoleDesc(model.getRoleDesc());
        this.doSysRole(role, model, true);
    }

    private void doSysRole(Role role, RoleModel.Request.SysCreate model, boolean isOverride) {
        if (role.getId() == null) {
            logger.error("\u65b0\u5efa\u7cfb\u7edf\u89d2\u8272\u83b7\u53d6roleId\u5931\u8d25,{}", (Object)JsonUtils.toJson((Object)role));
            throw new IllegalArgumentException("\u65b0\u5efa\u7cfb\u7edf\u89d2\u8272\u5931\u8d25");
        }
        if (isOverride) {
            RoleModel.Request.Query query = new RoleModel.Request.Query();
            query.setFromRoleId(role.getId());
            List<Role> delRoles = this.list(query, Sort.unsorted());
            if (null != delRoles) {
                this.roleDao.deleteAll(delRoles);
                delRoles.add(role);
                delRoles.forEach(r -> {
                    List existRels = this.roleResourcesetRelDao.findByRoleId(r.getId().longValue());
                    existRels.forEach(rel -> this.roleResourcesetRelDao.deleteById(rel.getId()));
                });
            }
        }
        List<Role> saveRoles = Stream.of(role).collect(Collectors.toList());
        model.getTenantIds().forEach(tenantId -> {
            Optional optionalTenant = this.tenantDao.findById(tenantId);
            if (optionalTenant.isPresent()) {
                List existRoles = this.roleDao.findByTenantIdAndFromRoleId(tenantId.longValue(), role.getId().longValue());
                if (CollectionUtils.isEmpty((Collection)existRoles)) {
                    Role r = new Role();
                    r.setCode(role.getCode());
                    r.setName(model.getRoleName());
                    r.setRoleDesc(model.getRoleDesc());
                    r.setStatus(model.getStatus());
                    r.setTenantId(tenantId);
                    r.setFromRoleId(role.getId());
                    Role saveRole = (Role)this.roleDao.saveAndFlush((Object)r);
                    saveRoles.add(saveRole);
                } else {
                    saveRoles.addAll(existRoles);
                }
            }
        });
        ArrayList insertingRels = new ArrayList();
        saveRoles.forEach(r -> model.getResourcesetIds().forEach(setId -> {
            RoleResourcesetRel existRel;
            Optional optionalResourceset = this.resourcesetDao.findById(setId);
            if (optionalResourceset.isPresent() && null == (existRel = this.roleResourcesetRelDao.findByRoleIdAndResourcesetIdAndTenantId(r.getId().longValue(), setId.longValue(), r.getTenantId().longValue()))) {
                RoleResourcesetRel rel = new RoleResourcesetRel();
                rel.setResousesetId(setId);
                rel.setRoleId(r.getId());
                rel.setTenantId(r.getTenantId());
                insertingRels.add(rel);
            }
        }));
        if (!CollectionUtils.isEmpty(insertingRels)) {
            insertingRels.forEach(arg_0 -> ((RoleResourcesetRelDao)this.roleResourcesetRelDao).saveAndFlush(arg_0));
        }
    }

    public Role sysInfo(long roleId) {
        Role role = this.findById(roleId);
        if (null == role) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272(" + roleId + ")");
        }
        RoleModel.Request.Query query = new RoleModel.Request.Query();
        query.setFromRoleId(Long.valueOf(roleId));
        query.setTenantId(Long.valueOf(0L));
        List roles = this.roleDao.findAll(RoleQueryHelper.querySpecification((RoleModel.Request.Query)query));
        Set tenantIds = roles.stream().map(Role::getTenantId).collect(Collectors.toSet());
        role.setTenantIds(tenantIds);
        ResourcesetModel.Request.Query resourcesetQuery = new ResourcesetModel.Request.Query();
        resourcesetQuery.setRoleId(Long.valueOf(roleId));
        resourcesetQuery.setStatus(Integer.valueOf(1));
        List resourcesets = this.resourcesetDao.findAll(ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)resourcesetQuery));
        role.setResourcesets(new HashSet(resourcesets));
        Set resourcesetIds = resourcesets.stream().map(Resourceset::getResourcesetId).collect(Collectors.toSet());
        role.setResourcesetIds(resourcesetIds);
        return role;
    }

    public Long findIdByTenantIdAndCode(long tenantId, String roleCode) {
        return this.roleDao.findIdByTenantIdAndCode(tenantId, roleCode);
    }

    public ResponseEntity<Long> importSysData(long roleId, MultipartFile file) {
        String separator = ",";
        Role role = this.findById(roleId);
        if (null == role) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u89d2\u8272(" + roleId + ")");
        }
        ArrayList<String> errorMsg = new ArrayList<String>();
        String template = "sys_role_rel.json";
        List<RoleResourcesetRelDto> list = ExcelUtils.list(file, template, RoleResourcesetRelDto.class);
        HashSet<Long> tenantIds = new HashSet<Long>();
        HashSet<Long> resourcesetIds = new HashSet<Long>();
        for (int i = 0; i < list.size(); ++i) {
            Long tenantId;
            String msg;
            RoleResourcesetRelDto r = list.get(i);
            if (StringUtils.isBlank((CharSequence)r.getTenantCode()) && StringUtils.isNotBlank((CharSequence)r.getResourcesetCodes())) {
                msg = "\u5bfc\u5165\u7b2c " + (i + 1) + " \u884c\u5931\u8d25\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                errorMsg.add(msg);
            }
            if (StringUtils.isNotBlank((CharSequence)r.getTenantCode()) && StringUtils.isBlank((CharSequence)r.getResourcesetCodes())) {
                msg = "\u5bfc\u5165\u7b2c " + (i + 1) + " \u884c\u5931\u8d25\uff0c\u529f\u80fd\u96c6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                errorMsg.add(msg);
            }
            if ((tenantId = this.tenantDao.findTenantIdByTenantCode(r.getTenantCode())) == null) {
                msg = "\u5bfc\u5165\u7b2c " + (i + 1) + " \u884c\u5931\u8d25\uff0c\u79df\u6237\u7f16\u53f7\u3010" + r.getTenantCode() + "\u3011\u4e0d\u5b58\u5728\uff01";
                errorMsg.add(msg);
                continue;
            }
            tenantIds.add(tenantId);
            if (!StringUtils.isNotBlank((CharSequence)r.getResourcesetCodes())) continue;
            for (String setCode : r.getResourcesetCodes().split(",")) {
                Long resourcesetId = this.resourcesetDao.findByResourcesetCode(setCode);
                if (null == resourcesetId) {
                    msg = "\u5bfc\u5165\u7b2c " + (i + 1) + " \u884c\u5931\u8d25\uff0c\u529f\u80fd\u96c6\u7f16\u53f7\u3010" + setCode + "\u3011\u4e0d\u5b58\u5728\uff01";
                    errorMsg.add(msg);
                    continue;
                }
                resourcesetIds.add(resourcesetId);
            }
        }
        RoleModel.Request.SysCreate sysCreate = new RoleModel.Request.SysCreate();
        sysCreate.setResourcesetIds(resourcesetIds);
        sysCreate.setTenantIds(tenantIds);
        sysCreate.setRoleDesc(role.getRoleDesc());
        sysCreate.setRoleName(role.getName());
        sysCreate.setStatus(role.getStatus());
        this.doSysRole(role, sysCreate, false);
        Long fileId = this.fileService.uploadMsgExcel(errorMsg);
        ResponseEntity restResponse = new ResponseEntity();
        restResponse.setCode(null == fileId ? "1" : "0");
        restResponse.setResult((Object)fileId);
        restResponse.setMessage("\u5bfc\u5165\u5b8c\u6210\uff0c\u5408\u8ba1" + errorMsg.size() + "\u4e2a\u9519\u8bef," + errorMsg);
        return restResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public void unbindUsers(long tenantId, long roleId, RoleModel.Request.UnbindUsers unbindUsers) {
        Set userIds = unbindUsers.getUserIds();
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            this.roleUserRelDao.deleteByTenantIdAndRoleIdAndUserIds(tenantId, roleId, (Collection)userIds);
            userIds.stream().filter(Objects::nonNull).forEach(userId -> this.roleUserRelDao.deleteByTenantIdAndUserIdAndRoleId(tenantId, userId.longValue(), Long.valueOf(roleId)));
        }
    }

    public Set<Role> copyRoleTempates(long tenantId, Collection<Role> roleTemplates) {
        HashSet<Role> copiedRoles = new HashSet<Role>(roleTemplates.size());
        HashSet<RoleResourcesetRel> allCopiedRoleResourcesetRels = new HashSet<RoleResourcesetRel>();
        if (!CollectionUtils.isEmpty(roleTemplates)) {
            for (Role roleTemplate : roleTemplates) {
                Role copiedRole = new Role();
                BeanUtils.copyProperties((Object)roleTemplate, (Object)copiedRole, (String[])((String[])Stream.of("id", "roleResourcesetRels", "roleUserRels").toArray(String[]::new)));
                copiedRole.setTenantId(Long.valueOf(tenantId));
                copiedRole = (Role)this.roleDao.saveAndFlush((Object)copiedRole);
                List roleResourcesetRels = roleTemplate.getRoleResourcesetRels();
                if (!CollectionUtils.isEmpty((Collection)roleResourcesetRels)) {
                    for (RoleResourcesetRel roleResourcesetRel : roleResourcesetRels) {
                        RoleResourcesetRel copiedRoleResourcesetRel = new RoleResourcesetRel();
                        BeanUtils.copyProperties((Object)roleResourcesetRel, (Object)copiedRoleResourcesetRel, (String[])((String[])Stream.of("id").toArray(String[]::new)));
                        copiedRoleResourcesetRel.setTenantId(Long.valueOf(tenantId));
                        copiedRoleResourcesetRel.setRoleId(copiedRole.getId());
                        allCopiedRoleResourcesetRels.add(copiedRoleResourcesetRel);
                    }
                }
                copiedRoles.add(copiedRole);
            }
        }
        if (!CollectionUtils.isEmpty(allCopiedRoleResourcesetRels)) {
            this.roleResourcesetRelDao.saveAllAndFlush(allCopiedRoleResourcesetRels);
        }
        return copiedRoles;
    }

    public List<RoleExportDto> findRolesResourcesetRel(Long tenantId, RoleModel.Request.Export query) {
        return this.roleDao.findRolesResourcesetRel(tenantId, query, null);
    }

    public List<RoleRelAccountExportDto> findRolesRelAccount(Long tenantId, RoleModel.Request.Export query) {
        return this.roleDao.findRolesRelAccount(tenantId, query, null);
    }

    public List<RoleUserRel> listRoleUserRel(Long tenantId, Long roleId, Long userId) {
        Objects.requireNonNull(tenantId, "tenantId is not allow null");
        Specification specification = RoleQueryHelper.queryRoleUserRelSpecification((Long)tenantId, (Long)roleId, (Long)userId);
        List list = this.roleUserRelDao.findAll(specification);
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(Long tenantId, Role role, ResourcesetModel.Request.BindResources bindResources) {
        ResourcesetModel.Request.Query query = new ResourcesetModel.Request.Query();
        query.setRoleId(role.getId());
        Optional<Resourceset> optionalResourceset = this.resourcesetService.findOne(query);
        Resourceset resourceset = null;
        ArrayList resourcesetIds = null;
        if (optionalResourceset.isPresent()) {
            resourceset = optionalResourceset.get();
            this.resourcesetService.bindResources(resourceset, bindResources);
            resourcesetIds = Lists.newArrayList((Object[])new Long[]{resourceset.getResourcesetId()});
        } else {
            ResourcesetModel.Request.Create create = new ResourcesetModel.Request.Create();
            create.setResourcesetName(role.getName() + "_\u81ea\u5b9a\u4e49\u529f\u80fd\u96c6");
            create.setResourcesetCode(UUID.randomUUID().toString());
            create.setResourcesetDesc("\u81ea\u5b9a\u4e49\u529f\u80fd\u96c6");
            create.setStatus(Integer.valueOf(1));
            create.setAppId(Long.valueOf(1L));
            create.setValidatedAppId(Boolean.valueOf(false));
            create.setBindResources(bindResources);
            create.setRoleId(role.getId());
            resourceset = this.resourcesetService.create(create);
            resourcesetIds = Lists.newArrayList((Object[])new Long[]{resourceset.getResourcesetId()});
        }
        RoleModel.Request.BindResourceSets bindResourceSets = new RoleModel.Request.BindResourceSets();
        bindResourceSets.setOverwrite(false);
        bindResourceSets.setResourcesetIds((List)resourcesetIds);
        this.bindResourceSets(role, bindResourceSets);
    }

    public List<OrgRoleCntDTO> getOrgRoleCntByGradingRoleIds(Long tenantId, Set<Long> roleIds) {
        return this.roleDao.getOrgRoleCntByGradingRoleIds(tenantId, roleIds);
    }

    public void disableOrgRolesByGradingRoleId(Long roleId) {
        this.roleDao.disableOrgRolesByGradingRoleId(roleId);
    }

    public List<Role> findByTenantIdAndFromRoleId(long tenantId, Long roleId) {
        return this.roleDao.findByTenantIdAndFromRoleId(tenantId, roleId.longValue());
    }

    public void deleteByTenantIdAndIds(long tenantId, List<Long> ids) {
        this.roleDao.deleteByTenantIdAndIds(tenantId, ids);
    }
}

