/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.TenantExtensionModel;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.constants.ExtensionStatus;
import com.xforceplus.dao.TenantExtensionDao;
import com.xforceplus.domain.tenant.TenantExtensionDto;
import com.xforceplus.entity.TenantExtension;
import io.geewit.core.utils.reflection.BeanUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@Service
public class TenantExtensionService {
    private static final Logger log = LoggerFactory.getLogger(TenantExtensionService.class);
    private static final Logger logger = LoggerFactory.getLogger(TenantExtensionService.class);
    @Resource
    private TenantExtensionDao tenantExtensionDao;

    private Specification<TenantExtension> querySpecification(TenantExtensionModel.Request.Query query, Integer status) {
        return (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getExtensionKey())) {
                predicates.add(builder.equal((Expression)root.get("extensionKey"), (Object)query.getExtensionKey()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getExtensionValue())) {
                predicates.add(builder.equal((Expression)root.get("extensionValue"), (Object)query.getExtensionValue()));
            }
            if (status != null && status > 0) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)status));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
    }

    public Page<TenantExtension> page(TenantExtensionModel.Request.Query query, Pageable pageable) {
        Specification<TenantExtension> specification = this.querySpecification(query, ExtensionStatus.ENABLE);
        return this.tenantExtensionDao.findAll(specification, pageable);
    }

    public List<TenantExtension> list(TenantExtensionModel.Request.Query query, Sort sort) {
        Specification<TenantExtension> specification = this.querySpecification(query, ExtensionStatus.ENABLE);
        return this.tenantExtensionDao.findAll(specification, sort);
    }

    @Transactional(rollbackFor={Exception.class})
    public TenantExtension save(TenantExtensionDto tenantExtensionDto) {
        List<TenantExtension> list = this.getList(tenantExtensionDto);
        if (CollectionUtils.isEmpty(list)) {
            TenantExtension entity = new TenantExtension();
            BeanUtils.copyProperties((Object)tenantExtensionDto, (Object)entity);
            entity.setStatus(ExtensionStatus.ENABLE);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            return (TenantExtension)this.tenantExtensionDao.saveAndFlush((Object)entity);
        }
        TenantExtension entity = list.get(0);
        entity.setExtensionValue(tenantExtensionDto.getExtensionValue());
        entity.setStatus(ExtensionStatus.ENABLE);
        entity.setUpdateTime(new Date());
        return (TenantExtension)this.tenantExtensionDao.saveAndFlush((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Set<TenantExtension> batchSave(long tenantId, List<TenantModel.Request.Extension> extensions, boolean isOverwrite) {
        if (tenantId <= 0L || CollectionUtils.isEmpty(extensions)) {
            return null;
        }
        List<TenantExtension> existExtensions = this.findByTenantId(tenantId);
        Set savingExtensions = extensions.stream().filter(Objects::nonNull).map(extension -> {
            TenantExtension savingExtension;
            List exists = this.tenantExtensionDao.findByTenantIdAndKey(tenantId, extension.getExtensionKey());
            if (CollectionUtils.isEmpty((Collection)exists)) {
                savingExtension = new TenantExtension();
                savingExtension.setTenantId(Long.valueOf(tenantId));
                savingExtension.setExtensionKey(extension.getExtensionKey());
            } else {
                savingExtension = (TenantExtension)exists.get(0);
            }
            savingExtension.setExtensionValue(extension.getExtensionValue());
            return savingExtension;
        }).collect(Collectors.toSet());
        if (!savingExtensions.isEmpty()) {
            this.tenantExtensionDao.saveAllAndFlush(savingExtensions);
        }
        HashSet<TenantExtension> result = new HashSet<TenantExtension>(savingExtensions);
        result.addAll(existExtensions);
        if (isOverwrite) {
            existExtensions.stream().filter(existExtension -> extensions.stream().noneMatch(extension -> extension.getExtensionKey().equals(existExtension.getExtensionKey()))).forEach(extension -> {
                logger.info("deleting CompanyExtension record, {}", extension);
                try {
                    this.tenantExtensionDao.deleteById(extension.getTenantExtensionId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        } else {
            result.addAll(existExtensions);
        }
        return result;
    }

    public List<TenantExtension> findByTenantId(long tenantId) {
        TenantExtensionModel.Request.Query query = new TenantExtensionModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        Specification<TenantExtension> specification = this.querySpecification(query, null);
        return this.tenantExtensionDao.findAll(specification, Sort.unsorted());
    }

    private List<TenantExtension> getList(TenantExtensionDto tenantExtensionWithIdDto) {
        TenantExtensionModel.Request.Query query = new TenantExtensionModel.Request.Query();
        query.setTenantId(tenantExtensionWithIdDto.getTenantId());
        query.setExtensionKey(tenantExtensionWithIdDto.getExtensionKey());
        Specification<TenantExtension> specification = this.querySpecification(query, null);
        return this.tenantExtensionDao.findAll(specification, Sort.unsorted());
    }

    public List<TenantExtension> getListByTenantId(Long tenantId) {
        TenantExtensionModel.Request.Query query = new TenantExtensionModel.Request.Query();
        query.setTenantId(tenantId);
        Specification<TenantExtension> specification = this.querySpecification(query, null);
        return this.tenantExtensionDao.findAll(specification, Sort.unsorted());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByTenantId(long tenantId) {
        this.tenantExtensionDao.deleteByTenantId(tenantId);
    }
}

