/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.TenantModel;
import com.xforceplus.api.model.TenantPolicyModel;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.TenantPolicyDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantPolicy;
import com.xforceplus.query.TenantPolicyQueryHelper;
import com.xforceplus.security.strategy.event.RefreshingStrategyCacheEvent;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import io.geewit.utils.uuid.UUID;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TenantPolicyService
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantPolicyService.class);
    public static final String TENANT_GRADING_MANAGEMENT_ENABLED = "tenantGradingMgrEnabled";
    private final TenantPolicyDao tenantPolicyDao;
    private final TenantDao tenantDao;
    private ApplicationEventPublisher publisher;

    public TenantPolicyService(TenantPolicyDao tenantPolicyDao, TenantDao tenantDao) {
        this.tenantPolicyDao = tenantPolicyDao;
        this.tenantDao = tenantDao;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public Page<TenantPolicy> page(TenantPolicyModel.Request.Query query, Pageable page) {
        Specification specification = TenantPolicyQueryHelper.querySpecification((TenantPolicyModel.Request.Query)query);
        Page policies = this.tenantPolicyDao.findAll(specification, page, EntityGraphs.named((String)"TenantPolicy.graph"));
        return policies;
    }

    public Map<String, TenantPolicy> policies(long tenantId) {
        List policies = this.tenantPolicyDao.findByTenantId(tenantId);
        if (policies.isEmpty()) {
            return Stream.of(TenantPolicy.ofDefault((String)"passwordLength", (String)"8")).collect(Collectors.toMap(TenantPolicy::getName, policy -> policy));
        }
        return policies.stream().collect(Collectors.toMap(TenantPolicy::getName, policy -> policy));
    }

    public boolean tenantGradingManagementEnabled(long tenantId) {
        String policy;
        String defaultPolicy = "1";
        Map<String, TenantPolicy> map = this.policies(tenantId);
        return null != map && null != map.get(TENANT_GRADING_MANAGEMENT_ENABLED) && "1".equals(policy = map.get(TENANT_GRADING_MANAGEMENT_ENABLED).getPolicy());
    }

    @Transactional(rollbackFor={Exception.class})
    public void policies(long tenantId, TenantModel.Request.Policies policies) {
        if (policies == null || policies.getPolicies() == null) {
            logger.info("policies == null, return null");
            return;
        }
        logger.info("isOverwrite = {}", (Object)policies.isOverwrite());
        logger.info("policies = " + policies.getPolicies().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existPolicies = this.tenantPolicyDao.findByTenantId(tenantId);
        logger.info("exist tenant.policies.size = " + existPolicies.size());
        Set savingPolicies = policies.getPolicies().stream().filter(Objects::nonNull).map(policy -> {
            TenantPolicy tenantPolicy = existPolicies.stream().filter(p -> p.getName().equals(policy.getName())).findAny().orElseGet(TenantPolicy::new);
            tenantPolicy.setTenantId(Long.valueOf(tenantId));
            tenantPolicy.setName(policy.getName());
            tenantPolicy.setPolicy(policy.getPolicy());
            return tenantPolicy;
        }).collect(Collectors.toSet());
        this.tenantPolicyDao.saveAllAndFlush(savingPolicies);
        if (policies.isOverwrite()) {
            existPolicies.stream().filter(Objects::nonNull).filter(existPolicy -> policies.getPolicies().stream().filter(Objects::nonNull).noneMatch(policy -> policy.getName().equals(existPolicy.getName()))).forEach(existPolicy -> {
                try {
                    this.tenantPolicyDao.deleteById(existPolicy.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TenantPolicy save(TenantPolicyModel.Request.Save model) {
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)model.getTenantId()).orElseThrow(() -> new InvalidParameterException("\u79df\u6237(id: " + model.getTenantId() + ")\u4e0d\u5b58\u5728\uff01"));
        List policies = this.tenantPolicyDao.findByTenantIdAndName(model.getTenantId().longValue(), model.getName());
        if (!CollectionUtils.isEmpty((Collection)policies)) {
            throw new InvalidParameterException("\u79df\u6237(id: " + model.getTenantId() + ")\u7b56\u7565(name:" + model.getName() + ")\u5df2\u5b58\u5728\uff01");
        }
        TenantPolicy policy = new TenantPolicy();
        policy.setName(model.getName());
        policy.setPolicy(model.getPolicy());
        policy.setTenantId(model.getTenantId());
        String refreshId = UUID.randomUUID().toString();
        logger.info("onMessage with redis expire: " + refreshId);
        this.publisher.publishEvent((ApplicationEvent)new RefreshingStrategyCacheEvent(refreshId));
        return (TenantPolicy)this.tenantPolicyDao.saveAndFlush((Object)policy);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.tenantPolicyDao.deleteById(id);
        String refreshId = UUID.randomUUID().toString();
        logger.info("onMessage with redis expire: " + refreshId);
        this.publisher.publishEvent((ApplicationEvent)new RefreshingStrategyCacheEvent(refreshId));
    }

    public TenantPolicy findById(long id) {
        return this.tenantPolicyDao.findById((Serializable)Long.valueOf(id), EntityGraphs.named((String)"TenantPolicy.graph")).orElse(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public TenantPolicy update(TenantPolicyModel.Request.Update update) {
        String refreshId = UUID.randomUUID().toString();
        logger.info("onMessage with redis expire: " + refreshId);
        this.publisher.publishEvent((ApplicationEvent)new RefreshingStrategyCacheEvent(refreshId));
        TenantPolicy policy = (TenantPolicy)this.tenantPolicyDao.findById((Object)update.getId()).orElseThrow(() -> new InvalidParameterException("\u7b56\u7565ID\u4e0d\u5b58\u5728\uff01"));
        policy.setId(update.getId());
        policy.setName(update.getName());
        policy.setPolicy(update.getPolicy());
        return (TenantPolicy)this.tenantPolicyDao.saveAndFlush((Object)policy);
    }
}

