/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.TenantExtensionModel;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.tenant.dto.TenantExportDTO;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.business.tenant.service.TenantExtensionService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.business.tenant.service.WrapperOrgService;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.RoleDao;
import com.xforceplus.dao.ServicePackageDao;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.TenantSecretDao;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.domain.tenant.TenantManagerDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantExtension;
import com.xforceplus.entity.TenantSecret;
import com.xforceplus.entity.User;
import com.xforceplus.query.TenantQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import io.geewit.utils.uuid.UUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.history.RevisionSort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TenantService {
    private static final Logger logger = LoggerFactory.getLogger(TenantService.class);
    private static final int MAX_EXTNESION_COUNT = 10;
    private static final int MAX_EXTNESION_LENGTH = 64;
    private final TenantDao tenantDao;
    private final TenantSecretDao tenantSecretDao;
    private final UserService userService;
    private final OrgService orgService;
    private final WrapperOrgService wrapperOrgService;
    private final CompanyService companyService;
    private final CompanyServiceRelDao companyServiceRelDao;
    private final ServicePackageDao servicePackageDao;
    private final RoleDao roleDao;
    private final RoleService roleService;
    private final ServiceResourcesetRelDao serviceResourcesetRelDao;
    private final CompanyDao companyDao;
    private final OrgStructDao orgStructDao;
    private final TenantExtensionService tenantExtensionService;
    private final AccountDao accountDao;

    public TenantService(TenantDao tenantDao, TenantSecretDao tenantSecretDao, UserService userService, OrgService orgService, WrapperOrgService wrapperOrgService, CompanyService companyService, CompanyServiceRelDao companyServiceRelDao, ServicePackageDao servicePackageDao, RoleDao roleDao, RoleService roleService, ServiceResourcesetRelDao serviceResourcesetRelDao, CompanyDao companyDao, OrgStructDao orgStructDao, TenantExtensionService tenantExtensionService, AccountDao accountDao) {
        this.tenantDao = tenantDao;
        this.tenantSecretDao = tenantSecretDao;
        this.userService = userService;
        this.orgService = orgService;
        this.wrapperOrgService = wrapperOrgService;
        this.companyService = companyService;
        this.companyServiceRelDao = companyServiceRelDao;
        this.servicePackageDao = servicePackageDao;
        this.roleDao = roleDao;
        this.roleService = roleService;
        this.serviceResourcesetRelDao = serviceResourcesetRelDao;
        this.companyDao = companyDao;
        this.orgStructDao = orgStructDao;
        this.tenantExtensionService = tenantExtensionService;
        this.accountDao = accountDao;
    }

    public Page<Tenant> page(TenantModel.Request.Query query, Pageable pageable) {
        Specification specification = TenantQueryHelper.querySpecification((TenantModel.Request.Query)query);
        Page page = this.tenantDao.findAll(specification, pageable);
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            String[] withExtendParams = StringUtils.split((String)query.getWithExtendParams(), (String)",");
            boolean enableCompanyCount = false;
            boolean enableExtensions = false;
            for (String withExtendParam : withExtendParams) {
                if ("companyCount".equalsIgnoreCase(withExtendParam)) {
                    enableCompanyCount = true;
                    continue;
                }
                if (!"extensions".equalsIgnoreCase(withExtendParam)) continue;
                enableExtensions = true;
            }
            List<TenantManagerDto> managerDtos = this.userService.findTenantManager(page.stream().map(tenant -> tenant.getTenantId()).collect(Collectors.toList()));
            Map<Long, List<TenantManagerDto>> managerMap = managerDtos.stream().collect(Collectors.groupingBy(TenantManagerDto::getTenantId));
            if (enableCompanyCount || enableExtensions) {
                for (Tenant tenant2 : page) {
                    List<TenantExtension> extensions;
                    List<TenantManagerDto> managerDtoList;
                    if (!CollectionUtils.isEmpty(managerMap) && !CollectionUtils.isEmpty(managerDtoList = managerMap.get(tenant2.getTenantId()))) {
                        tenant2.setTenantManager((TenantManagerDto)managerDtoList.stream().findFirst().orElse(null));
                    }
                    if (enableCompanyCount) {
                        int companyCount = this.orgStructDao.countCompaniesByTenantId(tenant2.getTenantId().longValue());
                        tenant2.setCompanyCount(Integer.valueOf(companyCount));
                    }
                    if (!enableExtensions || CollectionUtils.isEmpty(extensions = this.tenantExtensionService.getListByTenantId(tenant2.getTenantId()))) continue;
                    List extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toList());
                    tenant2.setExtensions(extensionDtos);
                }
            }
        }
        return page;
    }

    public List<TenantExportDTO> convert2ExportDto(List<Tenant> tenantList) {
        List<TenantExportDTO> exportVOList = tenantList.stream().map(t -> {
            int companyCount = this.orgStructDao.countCompaniesByTenantId(t.getTenantId().longValue());
            TenantExportDTO dto = new TenantExportDTO();
            BeanUtils.copyProperties((Object)t, (Object)dto);
            dto.setCompanyCount((long)companyCount * 1L);
            dto.setTenantId(t.getTenantId().toString());
            return dto;
        }).map(t -> {
            UserModel.Request.Query userQuery = new UserModel.Request.Query();
            userQuery.setTenantId(Long.valueOf(Long.parseLong(t.getTenantId())));
            List<RoleUserRel> userRelList = this.roleService.listRoleUserRel(Long.parseLong(t.getTenantId()), 1L, null);
            if (userRelList != null && userRelList.size() > 0) {
                User user = this.userService.findById(userRelList.get(userRelList.size() - 1).getUserId());
                try {
                    Account account = user.getAccount();
                    if (account != null && account.getCreateTime() != null) {
                        t.setAdmin(account.getEmail());
                        if (StringUtils.isEmpty((CharSequence)t.getAdmin())) {
                            t.setAdmin(account.getTelPhone());
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("notfound account", (Throwable)e);
                    t.setAdmin("");
                }
            }
            return t;
        }).map(t -> {
            if (StringUtils.isEmpty((CharSequence)t.getAdmin())) {
                t.setAdmin("");
            }
            if (t.getCompanyCount() == null) {
                t.setCompanyCount(0L);
            }
            return t;
        }).collect(Collectors.toList());
        return exportVOList;
    }

    public Page<Tenant> page(Specification<Tenant> specification, Pageable pageable) {
        return this.tenantDao.findAll(specification, pageable);
    }

    public List<Tenant> list(TenantModel.Request.Query query, Sort sort) {
        Specification specification = TenantQueryHelper.querySpecification((TenantModel.Request.Query)query);
        List list = this.tenantDao.findAll(specification, sort);
        return list;
    }

    public List<Tenant> list(Specification<Tenant> specification, Sort sort) {
        return this.tenantDao.findAll(specification, sort);
    }

    public Optional<Tenant> findOne(TenantModel.Request.Query query) {
        Specification specification = TenantQueryHelper.queryOneSpecification((TenantModel.Request.Query)query);
        return this.tenantDao.findOne(specification);
    }

    @Transactional(rollbackFor={Exception.class})
    public <T extends TenantDto, O extends OrgDto<O>, C extends CompanyDto<O>, U extends UserDto<O, R, A>, R extends RoleDto, A extends AccountDto> TenantModel.Response.CreateResult<T, O, C, U, R, A> create(TenantModel.Request.Create model) {
        this.checkExtensions(model.getExtensions());
        TenantModel.Response.CreateResult createResult = new TenantModel.Response.CreateResult();
        model.setOverwrite(false);
        this.save(model, createResult);
        if (createResult.getTenant() != null) {
            Set<TenantExtension> extensions = this.tenantExtensionService.batchSave(createResult.getTenant().getTenantId(), model.getExtensions(), model.isOverwrite());
            List<TenantExtensionModel.Response> responses = this.getExtensions(extensions);
            createResult.setExtensions(responses);
        }
        return createResult;
    }

    private void checkExtensions(List<TenantModel.Request.Extension> extensions) {
        if (CollectionUtils.isEmpty(extensions)) {
            return;
        }
        if (extensions.size() > 10) {
            throw new IllegalArgumentException("\u6269\u5c55\u6807\u7b7e\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc7\u301010\u3011");
        }
        boolean checkResult = extensions.stream().anyMatch(p -> StringUtils.isBlank((CharSequence)p.getExtensionKey()) || StringUtils.isBlank((CharSequence)p.getExtensionValue()));
        if (checkResult) {
            throw new IllegalArgumentException("\u6269\u5c55\u6807\u7b7e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        checkResult = extensions.stream().anyMatch(p -> p.getExtensionKey().length() > 64 || p.getExtensionValue().length() > 64);
        if (checkResult) {
            throw new IllegalArgumentException("\u6269\u5c55\u6807\u7b7e\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u301064\u3011");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Tenant update(long tenantId, TenantModel.Request.Save model) {
        this.checkExtensions(model.getExtensions());
        model.setTenantId(Long.valueOf(tenantId));
        Tenant result = this.save(model, null);
        Set<TenantExtension> extensions = this.tenantExtensionService.batchSave(tenantId, model.getExtensions(), true);
        if (!CollectionUtils.isEmpty(extensions)) {
            result.setExtensions(new ArrayList<TenantExtension>(extensions));
        }
        return result;
    }

    private List<TenantExtensionModel.Response> getExtensions(Collection<TenantExtension> extensions) {
        if (CollectionUtils.isEmpty(extensions)) {
            return null;
        }
        List<TenantExtensionModel.Response> responses = extensions.stream().map(p -> {
            TenantExtensionModel.Response response = new TenantExtensionModel.Response();
            response.setExtensionKey(p.getExtensionKey());
            response.setExtensionValue(p.getExtensionValue());
            response.setTenantId(p.getTenantId());
            return response;
        }).collect(Collectors.toList());
        return responses;
    }

    @Transactional(rollbackFor={Exception.class})
    public <S extends TenantModel.Request.Save, T extends TenantDto, O extends OrgDto<O>, C extends CompanyDto<O>, U extends UserDto<O, R, A>, R extends RoleDto, A extends AccountDto> Tenant save(S model, TenantModel.Response.CreateResult<T, O, C, U, R, A> createResult) {
        TenantModel.Request.Create tenantCreate;
        UserModel.Request.Create userSave;
        Tenant tenantEntity;
        boolean isNew = model instanceof TenantModel.Request.Create;
        if (model.getTenantId() != null && model.getTenantId() > 0L) {
            Optional tenantOptional = this.tenantDao.findById((Object)model.getTenantId());
            if (tenantOptional.isPresent()) {
                tenantEntity = (Tenant)tenantOptional.get();
            } else {
                tenantEntity = new Tenant();
                model.setTenantId(null);
            }
        } else {
            tenantEntity = new Tenant();
            model.setTenantId(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getTenantName())) {
            model.setTenantName(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getTenantCode())) {
            model.setTenantCode(null);
        }
        BeanUtils.copyProperties(model, (Object)tenantEntity, (String[])((String[])Stream.of("extensions").toArray(String[]::new)));
        tenantEntity = (Tenant)this.tenantDao.saveAndFlush((Object)tenantEntity);
        if (isNew && (userSave = (tenantCreate = (TenantModel.Request.Create)model).getUser()) != null) {
            Optional saveUserResultOptional;
            OrgStruct orgStruct;
            userSave.setIsOverwrite(Boolean.valueOf(false));
            userSave.setIsMergeAccount(Boolean.valueOf(true));
            userSave.setIsStrict(Boolean.valueOf(false));
            userSave.addRoleId(Long.valueOf(1L));
            OrgModel.Request.Save rootOrgSave = new OrgModel.Request.Save();
            rootOrgSave.setOrgName(tenantEntity.getTenantName());
            rootOrgSave.setOrgCode(tenantEntity.getTenantCode());
            rootOrgSave.setOrgType(OrgType.GROUP);
            rootOrgSave.setStatus(Integer.valueOf(1));
            OrgService.OrgSaveOutput rootOrgSaveOutput = this.orgService.update(tenantEntity.getTenantId(), rootOrgSave, false);
            HashSet<OrgStruct> orgs = new HashSet<OrgStruct>();
            OrgStruct rootOrg = rootOrgSaveOutput.findFirst();
            orgs.add(rootOrg);
            OrgService.OrgSaveOutput orgSaveOutput = null;
            CompanyModel.Request.Save companySave = tenantCreate.getCompany();
            if (companySave != null) {
                companySave.setHostTenantId(tenantEntity.getTenantId());
                OrgModel.Request.Save orgSave = new OrgModel.Request.Save();
                orgSave.setCompany(companySave);
                orgSave.setOrgId(companySave.getOrgId());
                orgSave.setOrgName(companySave.getCompanyName());
                orgSave.setOrgCode(companySave.getCompanyCode());
                orgSave.setOrgType(OrgType.COMPANY);
                orgSave.setParentId(rootOrg.getOrgId());
                orgSave.setStatus(Integer.valueOf(1));
                orgSaveOutput = this.wrapperOrgService.save(tenantEntity.getTenantId(), rootOrg.getOrgId(), rootOrg, orgSave, false);
                orgStruct = orgSaveOutput.findFirst();
            } else {
                orgStruct = rootOrgSaveOutput.findFirst();
            }
            Company company = orgStruct.getCompany();
            if (orgStruct.getCompanyId() != null && orgStruct.getCompanyId() > 0L && (company == null || company.getTaxNum() == null) && (company = (Company)this.companyDao.findById((Object)orgStruct.getCompanyId()).orElse(null)) == null) {
                String message = "\u5b58\u5728\u810f\u6570\u636e, org(" + orgStruct.getOrgId() + "), companyId(" + orgStruct.getCompanyId() + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
            UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save((long)tenantEntity.getTenantId(), orgStruct, userSave, userSave.isRoleOverwrite(), userSave.isOrgOverwrite(), userSave.isTagOverwrite(), userSave.isAppOverwrite(), userSave.isMergeAccount(), userSave.isStrict());
            UserModel.Request.SaveUserContext saveUserContext = null;
            if (!saveUserOutput.getUserResultMap().isEmpty() && (saveUserResultOptional = saveUserOutput.getUserResultMap().values().stream().findFirst()).isPresent()) {
                saveUserContext = (UserModel.Request.SaveUserContext)saveUserResultOptional.get();
                createResult.setUser(saveUserContext.getUser());
                createResult.setAccount(saveUserContext.getAccount());
            }
            if (createResult != null && orgSaveOutput != null) {
                OrgStruct org = orgSaveOutput.findFirst();
                if (org != null) {
                    orgs.add(org);
                    createResult.setOrgs(orgs);
                }
                if (company != null) {
                    createResult.setCompany((CompanyDto)company);
                }
            } else if (createResult != null && orgStruct != null) {
                createResult.setOrgs(Stream.of(orgStruct).collect(Collectors.toSet()));
            }
            if (companySave != null) {
                if (!CollectionUtils.isEmpty((Collection)tenantCreate.getPackageIds())) {
                    logger.info("tenantCreate.packageIds = " + tenantCreate.getPackageIds().stream().map(Object::toString).collect(Collectors.joining(",")));
                    long tenantId = tenantEntity.getTenantId();
                    long companyId = orgSaveOutput.findFirstCompanyId();
                    this.bindServicePackages(tenantId, companyId, tenantCreate.getPackageIds(), tenantCreate.isDefaultRole(), saveUserContext);
                }
                if (saveUserContext != null) {
                    if (!saveUserContext.getRoleIds().isEmpty()) {
                        this.userService.bindRoles(saveUserContext.getUser(), null, saveUserContext.getRoleIds(), null, null, null, userSave.isRoleOverwrite(), userSave.isStrict(), false);
                    }
                    if (rootOrg != null) {
                        saveUserContext.addOrgId(rootOrg.getOrgId().longValue());
                    }
                    if (!saveUserContext.getOrgIds().isEmpty()) {
                        this.userService.bindOrgs(saveUserContext.getUser(), saveUserContext.getOrgIds(), saveUserContext.getUser().getModules(), userSave.isOrgOverwrite(), userSave.isStrict(), false);
                    }
                }
            }
        }
        if (createResult != null) {
            createResult.setTenant((TenantDto)tenantEntity);
        }
        return tenantEntity;
    }

    public Tenant findById(Long tenantId) {
        return (Tenant)this.tenantDao.findById((Object)tenantId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u79df\u6237(id:" + tenantId + ")"));
    }

    @Transactional(rollbackFor={Exception.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> void bindServicePackages(long tenantId, long companyId, Collection<Long> packageIds, boolean isDefaultRole, UserModel.Request.SaveUserContext<U, O, R, A> saveUserContext) {
        List packages;
        logger.info("tenantId = {}, companyId = {}, isDefaultRole = {}", new Object[]{tenantId, companyId, isDefaultRole});
        if (!CollectionUtils.isEmpty(packageIds) && (packages = this.servicePackageDao.findAllById(packageIds)).iterator().hasNext()) {
            logger.info("packages is not empty");
            ArrayList<CompanyServiceRel> companyPackages = new ArrayList<CompanyServiceRel>();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            for (ServicePackage servicePackage : packages) {
                CompanyServiceRel companyServiceRel = new CompanyServiceRel();
                companyServiceRel.setTenantId(Long.valueOf(tenantId));
                companyServiceRel.setCompanyId(Long.valueOf(companyId));
                companyServiceRel.setServicePackageId(servicePackage.getServicePackageId());
                companyServiceRel.setStatus(Integer.valueOf(1));
                companyServiceRel.setOperateReason("\u4e00\u7ad9\u5f0f\u5165\u9a7b");
                companyServiceRel.setRemarks("\u4e00\u7ad9\u5f0f\u5165\u9a7b");
                companyPackages.add(companyServiceRel);
                if (!isDefaultRole) continue;
                Role role = new Role();
                role.setCode(UUID.randomUUID().toString());
                role.setName(servicePackage.getServicePackageName());
                role.setRoleDesc(servicePackage.getServicePackageDesc());
                role.setStatus(Integer.valueOf(1));
                role.setTenantId(Long.valueOf(tenantId));
                role = (Role)this.roleDao.saveAndFlush((Object)role);
                roleIds.add(role.getId());
                List resourcesetIds = this.serviceResourcesetRelDao.findResourcesetIdByServicePackageId(servicePackage.getServicePackageId().longValue());
                RoleModel.Request.BindResourceSets bindResourceSets = new RoleModel.Request.BindResourceSets();
                bindResourceSets.setOverwrite(false);
                bindResourceSets.setResourcesetIds(resourcesetIds);
                this.roleService.bindResourceSets(role, bindResourceSets);
            }
            if (saveUserContext != null && !CollectionUtils.isEmpty(roleIds)) {
                saveUserContext.addRoleIds(roleIds);
            }
            this.companyServiceRelDao.saveAllAndFlush(companyPackages);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean bindCompanies(long tenantId, List<Long> companyIds) {
        logger.info("tenantId = {}, companyIds = {}", (Object)tenantId, companyIds);
        if (CollectionUtils.isEmpty(companyIds)) {
            throw new IllegalArgumentException("\u516c\u53f8id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.tenantDao.existsById((Object)tenantId)) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u79df\u6237id");
        }
        for (Long companyId : companyIds) {
            this.bindCompany(tenantId, companyId);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean bindCompany(long tenantId, long companyId) {
        logger.info("tenantId = {}, companyId = {}", (Object)tenantId, (Object)companyId);
        Optional companyOptional = this.companyDao.findById((Object)companyId);
        if (!companyOptional.isPresent()) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u516c\u53f8, companyId = " + companyId);
        }
        Company company = (Company)companyOptional.get();
        List<OrgStruct> companyOrgs = this.orgService.findByTenantIdAndCompanyId(tenantId, companyId);
        if (companyOrgs.isEmpty()) {
            OrgStruct orgStruct = new OrgStruct();
            orgStruct.setTenantId(Long.valueOf(tenantId));
            orgStruct.setCompanyId(Long.valueOf(companyId));
            orgStruct.setOrgName(company.getCompanyName());
            orgStruct.setOrgDesc(company.getCompanyName());
            orgStruct.setOrgCode(company.getCompanyCode());
            orgStruct.setOrgType(OrgType.COMPANY);
            List<OrgStruct> roots = this.orgService.findAllRoots(tenantId, Sort.unsorted());
            if (roots == null || roots.isEmpty()) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u79df\u6237\u4e0b\u7684\u6839\u7ec4\u7ec7, tenantId = " + tenantId);
            }
            Long parentId = roots.stream().map(OrgStruct::getOrgId).filter(Objects::nonNull).findFirst().get();
            logger.info("\u65b0\u7ed1\u5b9a\u7684\u79df\u6237\u5728parentId:{}\u4e0b", (Object)parentId);
            orgStruct.setParentId((Serializable)parentId);
            orgStruct.setStatus(Integer.valueOf(1));
            this.orgService.saveOrgStructEntity(orgStruct);
        }
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)tenantId).get();
        this.companyService.saveTenantCompany(tenant, company);
        return true;
    }

    @Deprecated
    public void fxCompanies(long tenantId) {
        List companies = this.orgStructDao.findCompaniesByTenantId(tenantId);
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)tenantId).get();
        for (Company company : companies) {
            this.companyService.saveTenantCompany(tenant, company);
        }
    }

    public Long findTenantByCode(String tenantCode) {
        Long tenantId = this.tenantDao.findTenantIdByTenantCode(tenantCode);
        return tenantId;
    }

    public String findSecretByTenantId(long tenantId) {
        return this.tenantSecretDao.findSecretByTenantId(tenantId);
    }

    public Tenant findByCode(String tenantCode) {
        TenantModel.Request.Query query = new TenantModel.Request.Query();
        query.setTenantCode(tenantCode);
        Specification specification = TenantQueryHelper.querySpecification((TenantModel.Request.Query)query);
        Optional optionalTenant = this.tenantDao.findOne(specification);
        return (Tenant)optionalTenant.orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u79df\u6237code"));
    }

    public List<Tenant> currentTenants() {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long accountId = authorizedUser.getAccountId();
        return this.tenantDao.listTenantByAccountId(Long.valueOf(accountId));
    }

    public Tenant currentTenantInfo() {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        ArrayList<Long> tenantIds = new ArrayList<Long>();
        tenantIds.add(authorizedUser.getTenantId());
        List<TenantManagerDto> managerDtos = this.userService.findTenantManager(tenantIds);
        Tenant tenant = new Tenant();
        tenant.setTenantId(authorizedUser.getTenantId());
        tenant.setTenantCode(authorizedUser.getTenantCode());
        tenant.setTenantName(authorizedUser.getTenantName());
        if (!CollectionUtils.isEmpty(managerDtos)) {
            tenant.setTenantManager(managerDtos.get(0));
        }
        return tenant;
    }

    public Tenant findByTenantCodeOrTenantName(String tenantCode, String tenantName) {
        List<Tenant> tenants = this.findAllByTenantCodeOrTenantName(tenantCode, tenantName);
        if (CollectionUtils.isEmpty(tenants)) {
            String message = "\u67e5\u8be2\u79df\u6237(tenantCode:" + tenantCode + ",tenantName:" + tenantName + ")\u4e0d\u5b58\u5728";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (tenants.size() > 1) {
            throw new IllegalArgumentException("\u67e5\u8be2\u5230\u591a\u4e2a\u79df\u6237\uff01");
        }
        return tenants.get(0);
    }

    private List<Tenant> findAllByTenantCodeOrTenantName(String tenantCode, String tenantName) {
        TenantModel.Request.Query query = new TenantModel.Request.Query();
        if (StringUtils.isNotEmpty((CharSequence)tenantCode)) {
            query.setTenantCode(tenantCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)tenantName)) {
            query.setTenantName(tenantName);
        }
        Specification specification = TenantQueryHelper.queryOneSpecification((TenantModel.Request.Query)query);
        List tenants = this.tenantDao.findAll(specification, Sort.unsorted());
        return tenants;
    }

    public List<Tenant> findAllById(List<Long> ids) {
        return this.tenantDao.findAllById(ids);
    }

    public Map<Long, String> allTenantSecrets() {
        List tenantSecrets = this.tenantSecretDao.findAll();
        Map result = tenantSecrets.stream().collect(Collectors.toMap(TenantSecret::getTenantId, TenantSecret::getSecret, (a, b) -> b, () -> new HashMap(tenantSecrets.size())));
        return result;
    }

    public Page<ComparedRevision<Tenant, String>> findTenantHistories(long tenantId, Pageable pageable) {
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSort().and((Sort)RevisionSort.desc()));
        Page page = this.tenantDao.findComparedRevisions((Object)tenantId, pageable);
        return page;
    }
}

