/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.entity.User;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class UserExcelExportServiceImpl
implements ExcelWriteService {
    private static final Logger logger = LoggerFactory.getLogger(UserExcelExportServiceImpl.class);
    private final UserService userService;

    public UserExcelExportServiceImpl(UserService userService) {
        this.userService = userService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.USER_IMPORT;
    }

    @Override
    public void write(Context context) {
        UserModel.Request.Query query = context.getParam("P_QUERY", UserModel.Request.Query.class);
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        logger.info("maxPageSize:{}", (Object)maxPageSize);
        HashSet<Long> filterUserIds = new HashSet<Long>();
        if (query.getUserId() != null && query.getUserId() > 0L) {
            filterUserIds.add(query.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserIds())) {
            Arrays.stream(StringUtils.split((String)query.getUserIds(), (String)",")).forEach(id -> {
                try {
                    Long parseLong = Long.parseLong(id);
                    filterUserIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    String message = e.getMessage() + ", id: " + id;
                    logger.warn(message);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(filterUserIds)) {
            List<User> userList = this.userService.findAllById(filterUserIds);
            this.userService.fillExcel(userList, simpleExcelWriter, query.getSheets());
        } else {
            Page<User> page;
            PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
            do {
                page = this.userService.page(query, (Pageable)pageable);
                this.userService.fillExcel(page.toList(), simpleExcelWriter, query.getSheets());
            } while (page.hasNext() && page.getNumber() < maxPageSize);
            logger.info("user page export, total page:{}", (Object)page.getNumber());
        }
    }
}

