/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.dao.OrgVirtualNodeDao;
import com.xforceplus.dao.OrgVirtualUserRelDao;
import com.xforceplus.entity.OrgVirtualNode;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.utils.OrgVirtualNodeUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class WrapperOrgVirtualNodeUserService {
    private static final Logger logger = LoggerFactory.getLogger(WrapperOrgVirtualNodeUserService.class);
    private final OrgVirtualNodeDao orgVirtualNodeDao;
    private final OrgVirtualUserRelDao orgVirtualUserRelDao;

    public WrapperOrgVirtualNodeUserService(OrgVirtualNodeDao orgVirtualNodeDao, OrgVirtualUserRelDao orgVirtualUserRelDao) {
        this.orgVirtualNodeDao = orgVirtualNodeDao;
        this.orgVirtualUserRelDao = orgVirtualUserRelDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoBindUsers(Long tenantId, Long nodeId) {
        Optional optionalOrgVirtualNode = this.orgVirtualNodeDao.findById((Object)nodeId);
        if (!optionalOrgVirtualNode.isPresent()) {
            logger.warn("\u4f20\u7684nodeId({})\u4e0d\u5b58\u5728", (Object)nodeId);
            return;
        }
        OrgVirtualNode currentNode = (OrgVirtualNode)optionalOrgVirtualNode.get();
        if (StringUtils.isBlank((CharSequence)currentNode.getParentIds())) {
            logger.warn("\u4f20\u7684nodeId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a", (Object)nodeId);
            return;
        }
        String parentIds = currentNode.getParentIds();
        Set<Long> parentnodeIds = OrgVirtualNodeUtils.findNodeIdInParentIds(parentIds);
        if (CollectionUtils.isEmpty(parentnodeIds = parentnodeIds.stream().filter(parentId -> !parentId.equals(nodeId)).collect(Collectors.toSet()))) {
            logger.warn("\u4f20\u7684nodeId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a", (Object)nodeId);
            return;
        }
        Set boundUserOrgVirtualNodeRels = this.orgVirtualUserRelDao.findByOrgVirtualNodeIdIn(parentnodeIds);
        if (CollectionUtils.isEmpty((Collection)boundUserOrgVirtualNodeRels)) {
            logger.warn("\u5728\u7236\u865a\u62df\u865a\u62df\u7ec4\u7ec7\u6811\u4e2d\u6ca1\u6709\u627e\u5230\u5df2\u7ed1\u5b9a\u7684\u7528\u6237");
            return;
        }
        Set shouldBoundUserIds = boundUserOrgVirtualNodeRels.stream().filter(r -> r.getControlFlag() == 1).map(OrgVirtualNodeUserRel::getUserId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(shouldBoundUserIds)) {
            logger.warn("\u5728\u7236\u865a\u62df\u865a\u62df\u7ec4\u7ec7\u6811\u4e2d\u6ca1\u6709\u627e\u5230\u5df2\u7ed1\u5b9a\u7684\u7528\u6237");
            return;
        }
        shouldBoundUserIds.stream().filter(shouldBoundUserId -> boundUserOrgVirtualNodeRels.stream().noneMatch(rel -> rel.getOrgVirtualNodeId().equals(nodeId) && rel.getUserId().equals(shouldBoundUserId))).filter(Objects::nonNull).forEach(shouldBoundUserId -> {
            OrgVirtualNodeUserRel rel = new OrgVirtualNodeUserRel();
            rel.setOrgVirtualNodeId(nodeId);
            rel.setTenantId(tenantId);
            rel.setUserId(shouldBoundUserId);
            rel.setControlFlag(Integer.valueOf(0));
            this.orgVirtualUserRelDao.saveAndFlush((Object)rel);
        });
    }
}

