/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.company.OrgCompanyNumberDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.entity.OrgCompanyRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.web.utils.JsonUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgCompanyNumberImportServiceImpl
implements ExcelReaderService {
    public static final String ACTION_ADD = "\u65b0\u589e";
    public static final String ACTION_DELETE = "\u5220\u9664";
    public static final String SHEET_NAME = "\u516c\u53f8\u7f16\u53f7\u5bfc\u5165";
    public static final HashMap<String, Integer> SHEET_HEADER_NUMBER = new HashMap(1);
    public static final List<String> ACTION_LISTS;
    private static final Logger log;
    @Autowired
    CompanyService companyService;
    @Autowired
    OrgService orgService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_COMPANY_NUM_IMPORT;
    }

    @Override
    public HashMap<String, Integer> getSheetHeaderNumber() {
        return SHEET_HEADER_NUMBER;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            Integer headerNumber = SHEET_HEADER_NUMBER.get(sheet.getSheetName());
            if (headerNumber == null) {
                headerNumber = 1;
            }
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<OrgCompanyNumberDTO>)rows));
            context.getSimpleExcelReader().read(OrgCompanyNumberDTO.class, excelDataListener, headerNumber);
        }
        return context;
    }

    public void saveData(MessageRow messageRow, Context context, List<OrgCompanyNumberDTO> list) {
        if (log.isDebugEnabled()) {
            log.debug("list:{}", (Object)JsonUtils.toJson(list));
        }
        for (OrgCompanyNumberDTO dto : list) {
            try {
                String message;
                OrgStruct orgStruct;
                if (!dto.getValidatedStatus().booleanValue()) {
                    messageRow.fail(dto.getRowIndex(), dto.getValidatedMessage());
                    continue;
                }
                if (!ACTION_LISTS.contains(dto.getAction())) {
                    messageRow.fail(dto.getRowIndex(), "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u64cd\u4f5c\u7c7b\u578b\u5e94\u8be5\u4e3a:{\u65b0\u589e,\u5220\u9664}");
                    continue;
                }
                OrgModel.Request.Query query = new OrgModel.Request.Query();
                query.setOrgCode(dto.getOrgCode());
                query.setTenantId(context.getFileDTO().getTenantId());
                query.setStatus(Integer.valueOf(1));
                List<OrgStruct> orgStructList = this.orgService.list(query, Sort.unsorted());
                if (CollectionUtils.isEmpty(orgStructList)) {
                    String message2 = "\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(" + dto.getOrgCode() + ")";
                    messageRow.fail(dto.getRowIndex(), message2);
                    log.warn(message2);
                    continue;
                }
                if (orgStructList.size() > 1) {
                    log.warn("ORG_CODE_DUPLICATE:{}", (Object)dto.getOrgCode());
                }
                if (!OrgType.COMPANY.equals((Object)(orgStruct = orgStructList.get(0)).getOrgType())) {
                    messageRow.fail(dto.getRowIndex(), "\u8be5\u7ec4\u7ec7\u4e0d\u80fd\u7ed1\u5b9a\u7f16\u53f7");
                    continue;
                }
                OrgCompanyNumberDTO orgCompanyNumberDTO = new OrgCompanyNumberDTO();
                orgCompanyNumberDTO.setOrgId(orgStruct.getOrgId());
                orgCompanyNumberDTO.setCompanyNumber(dto.getCompanyNumber());
                Optional<OrgCompanyRel> orgCompanyRel = this.orgService.findOrgComNum(orgCompanyNumberDTO);
                if (ACTION_ADD.equals(dto.getAction())) {
                    if (orgCompanyRel.isPresent()) {
                        message = "\u7f16\u53f7\u5df2\u5b58\u5728";
                        messageRow.fail(dto.getRowIndex(), message);
                        log.warn(message);
                        continue;
                    }
                    HashSet<String> orgNumSet = new HashSet<String>();
                    orgNumSet.add(dto.getCompanyNumber());
                    this.companyService.saveCompanyNos(orgStruct.getOrgId(), orgNumSet, false);
                } else if (orgCompanyRel.isPresent()) {
                    this.companyService.deleteOrgComRelById(orgCompanyRel.get().getId());
                } else {
                    message = "\u7f16\u53f7\u4e0d\u5b58\u5728";
                    messageRow.fail(dto.getRowIndex(), message);
                    log.warn(message);
                    continue;
                }
                messageRow.success(dto.getRowIndex());
            }
            catch (Exception e) {
                log.warn("\u5bfc\u5165\u516c\u53f8\u7ec4\u7ec7\u7f16\u53f7\u51fa\u9519:{}", (Object)dto, (Object)e);
                messageRow.fail(dto.getRowIndex(), "\u5904\u7406\u51fa\u9519");
            }
        }
        context.messageRow(SHEET_NAME, messageRow);
    }

    static {
        SHEET_HEADER_NUMBER.put(SHEET_NAME, 1);
        ACTION_LISTS = Arrays.asList(ACTION_ADD, ACTION_DELETE);
        log = LoggerFactory.getLogger(OrgCompanyNumberImportServiceImpl.class);
    }
}

