/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.api.model.OrgExtensionModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.org.OrgExtensionImportDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.service.OrgExtensionService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.entity.OrgExtension;
import io.geewit.web.utils.JsonUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgExtensionImportServiceImpl
implements ExcelReaderService {
    public static final String ACTION_ADD = "\u65b0\u5efa";
    public static final String ACTION_UPDATE = "\u4fee\u6539";
    public static final String SHEET_NAME = "\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5";
    public static final List<String> ACTION_LISTS = Arrays.asList("\u65b0\u5efa", "\u4fee\u6539");
    private static final Logger log = LoggerFactory.getLogger(OrgExtensionImportServiceImpl.class);
    @Autowired
    private CompanyService companyService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private OrgStructDao orgStructDao;
    @Autowired
    private OrgExtensionService orgExtensionService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_EXTENSION_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<OrgExtensionImportDTO>)rows));
            context.getSimpleExcelReader().read(OrgExtensionImportDTO.class, excelDataListener);
        }
        return context;
    }

    public void saveData(MessageRow messageRow, Context context, List<OrgExtensionImportDTO> list) {
        log.info("list:{}", (Object)JsonUtils.toJson(list));
        for (OrgExtensionImportDTO dto : list) {
            try {
                String message;
                if (!dto.getValidatedStatus().booleanValue()) {
                    messageRow.fail(dto.getRowIndex(), dto.getValidatedMessage());
                    continue;
                }
                if (!ACTION_LISTS.contains(dto.getAction())) {
                    messageRow.fail(dto.getRowIndex(), "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u64cd\u4f5c\u7c7b\u578b\u5e94\u8be5\u4e3a:{\u65b0\u5efa,\u4fee\u6539}");
                    continue;
                }
                List orgDtoList = this.orgStructDao.getOrgByTenantCodeAndOrgCode(dto.getTenantCode(), dto.getOrgCode());
                if (CollectionUtils.isEmpty((Collection)orgDtoList)) {
                    messageRow.fail(dto.getRowIndex(), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
                    continue;
                }
                OrgDto orgStruct = (OrgDto)orgDtoList.get(0);
                if (orgDtoList.size() > 1) {
                    log.warn("\u627e\u5230\u591a\u4e2a\u7ec4\u7ec7, \u53d6\u7b2c\u4e00\u4e2a, tenant_code:{}, org_code:{}, org_struct_id:{}", new Object[]{dto.getTenantCode(), dto.getOrgCode(), orgStruct.getOrgId()});
                }
                List<OrgExtension> orgExtensionList = this.orgExtensionService.findByOrgIdAndKey(orgStruct.getOrgId(), dto.getKey());
                OrgExtension orgExtension = null;
                if (orgExtensionList != null && orgExtensionList.size() > 0) {
                    orgExtension = orgExtensionList.get(0);
                }
                if (ACTION_ADD.equals(dto.getAction())) {
                    if (orgExtension != null) {
                        message = "key\u5df2\u5b58\u5728";
                        messageRow.fail(dto.getRowIndex(), message);
                        log.warn(message);
                        continue;
                    }
                    OrgExtensionModel.Request.Create orgExtension1 = new OrgExtensionModel.Request.Create();
                    orgExtension1.setOrgId(orgStruct.getOrgId());
                    orgExtension1.setExtensionKey(dto.getKey());
                    orgExtension1.setExtensionValue(dto.getValue());
                    this.orgExtensionService.create(orgExtension1);
                } else if (orgExtension != null) {
                    OrgExtensionModel.Request.Update update = new OrgExtensionModel.Request.Update();
                    update.setExtensionId(orgExtension.getOrgExtensionId().longValue());
                    update.setExtensionValue(dto.getValue());
                    this.orgExtensionService.update(update);
                } else {
                    message = "key\u4e0d\u5b58\u5728";
                    messageRow.fail(dto.getRowIndex(), message);
                    log.warn(message);
                    continue;
                }
                messageRow.success(dto.getRowIndex());
            }
            catch (Exception e) {
                log.warn("\u5bfc\u5165\u516c\u53f8\u6269\u5c55\u4fe1\u606f\u51fa\u9519:{}", (Object)dto, (Object)e);
                messageRow.fail(dto.getRowIndex(), "\u5904\u7406\u51fa\u9519");
            }
        }
        context.messageRow(SHEET_NAME, messageRow);
    }
}

