/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service.impl;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.business.tenant.service.RoleService;
import org.springframework.stereotype.Service;

@Service
public class RoleExcelExportServiceImpl
implements ExcelWriteService {
    private final RoleService roleService;

    public RoleExcelExportServiceImpl(RoleService roleService) {
        this.roleService = roleService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ROLE_EXCEL_FILE;
    }

    @Override
    public void write(Context context) {
        RoleModel.Request.Export query = context.getParam("P_QUERY", RoleModel.Request.Export.class);
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        for (String sheetName : query.getSheets()) {
            if ("\u89d2\u8272\u529f\u80fd\u5bf9\u7167\u8868".equals(sheetName)) {
                simpleExcelWriter.fill(sheetName, this.roleService.findRolesResourcesetRel(tenantId, query));
            }
            if (!"\u89d2\u8272\u6388\u6743\u5217\u8868".equals(sheetName)) continue;
            simpleExcelWriter.fill(sheetName, this.roleService.findRolesRelAccount(tenantId, query));
        }
    }
}

