/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service.impl;

import com.xforceplus.bo.user.TenantUserBo;
import com.xforceplus.business.tenant.service.TenantUserService;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.user.TenantUserExtendDao;
import com.xforceplus.dto.user.TenantAdminUserDTO;
import com.xforceplus.dto.user.TenantUserDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TenantUserServiceImpl
implements TenantUserService {
    public static final Long TENANT_ADMIN_ROLE_ID = 1L;
    private final TenantUserExtendDao tenantUserExtendDao;
    private final TenantDao tenantDao;

    public TenantUserServiceImpl(TenantUserExtendDao tenantUserExtendDao, TenantDao tenantDao) {
        this.tenantUserExtendDao = tenantUserExtendDao;
        this.tenantDao = tenantDao;
    }

    @Override
    public Page<TenantUserDTO> findTenantUsersByCondition(Pageable pageable, TenantUserBo tenantUserBo) {
        if (tenantUserBo.getQueryType().equals(3)) {
            String tenantName = tenantUserBo.getTenantName() + "%";
            Set ids = this.tenantDao.findIdsByTenantName(tenantName);
            Assert.notEmpty((Collection)ids, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u79df\u6237\u4fe1\u606f");
            tenantUserBo.setTenantId(null);
            tenantUserBo.setTenantIds(ids);
        } else if (tenantUserBo.getQueryType().equals(2)) {
            Long tenantId = this.tenantDao.findTenantIdByTenantCode(tenantUserBo.getTenantCode());
            Assert.notNull((Object)tenantId, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u79df\u6237\u4fe1\u606f");
            tenantUserBo.setTenantId(tenantId);
            tenantUserBo.setTenantIds(null);
        }
        Map<Long, TenantAdminUserDTO> adminUserMap = Collections.emptyMap();
        if (null == tenantUserBo.getUserType()) {
            adminUserMap = this.findTenantAdminByTenantIds(tenantUserBo);
        } else {
            tenantUserBo.setAdminRoleId(TENANT_ADMIN_ROLE_ID);
        }
        Page page = this.tenantUserExtendDao.findTenantUsersByCondition(pageable, tenantUserBo);
        return this.pageConvert(tenantUserBo, adminUserMap, (Page<TenantUserDTO>)page);
    }

    private Page<TenantUserDTO> pageConvert(TenantUserBo tenantUserBo, Map<Long, TenantAdminUserDTO> adminUsers, Page<TenantUserDTO> page) {
        return page.map(e -> {
            if (tenantUserBo.getUserType() != null) {
                e.setUserType(tenantUserBo.getUserType());
                return e;
            }
            Integer tenantAdminType = adminUsers.containsKey(e.getUserId()) ? 0 : 1;
            e.setUserType(tenantAdminType);
            return e;
        });
    }

    private Map<Long, TenantAdminUserDTO> findTenantAdminByTenantIds(TenantUserBo tenantUserBo) {
        List<TenantAdminUserDTO> adminUserDTOList = tenantUserBo.getQueryType() != null && 3 == tenantUserBo.getQueryType() ? this.findTenantAdminUserByTenantIds(tenantUserBo.getTenantIds(), TENANT_ADMIN_ROLE_ID) : this.findTenantAdminUserByTenantId(tenantUserBo.getTenantId(), TENANT_ADMIN_ROLE_ID);
        if (CollectionUtils.isEmpty(adminUserDTOList)) {
            return Collections.emptyMap();
        }
        return adminUserDTOList.stream().collect(Collectors.toMap(TenantAdminUserDTO::getUserId, Function.identity(), (id1, id2) -> id2));
    }

    @Override
    public List<TenantAdminUserDTO> findTenantAdminUserByTenantIds(Set<Long> tenantIds, Long roleId) {
        return this.tenantUserExtendDao.findTenantAdminUserByTenantIds(tenantIds, roleId);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public Page<TenantUserDTO> findTenantUsersByTenantId(Pageable pageable, TenantUserBo tenantUserBo) {
        Map<Long, TenantAdminUserDTO> adminUserMap = null;
        if (null == tenantUserBo.getUserType()) {
            adminUserMap = this.findTenantAdminByTenantIds(tenantUserBo);
        } else {
            tenantUserBo.setAdminRoleId(TENANT_ADMIN_ROLE_ID);
        }
        Page page = this.tenantUserExtendDao.findTenantUsersByTenantId(pageable, tenantUserBo);
        return this.pageConvert(tenantUserBo, adminUserMap, (Page<TenantUserDTO>)page);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public List<TenantAdminUserDTO> findTenantAdminUserByTenantId(Long tenantId, Long roleId) {
        return this.tenantUserExtendDao.findTenantAdminUserByTenantId(tenantId, roleId);
    }
}

