/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.validator.impl;

import com.xforceplus.api.model.CompanyApplyModel;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.tenant.excel.ExcelImportData;
import com.xforceplus.business.validator.ValidateCompany;
import com.xforceplus.dao.CompanyApplyDao;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.entity.Company;
import com.xforceplus.query.CompanyApplyQueryHelper;
import com.xforceplus.query.CompanyQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.core.utils.reflection.Reflections;
import io.geewit.web.utils.JsonUtils;
import java.util.List;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyValidator
implements ConstraintValidator<ValidateCompany, ExcelImportData> {
    private static final Logger logger = LoggerFactory.getLogger(CompanyValidator.class);
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyApplyDao companyApplyDao;
    private String[] actions;

    public void initialize(ValidateCompany constraintAnnotation) {
        this.actions = constraintAnnotation.actions();
    }

    public boolean isValid(ExcelImportData company, ConstraintValidatorContext constraintValidatorContext) {
        boolean isNew;
        logger.info("company: {}", (Object)JsonUtils.toJson((Object)company));
        boolean valid = true;
        boolean isHibernateConstraintValidatorContext = constraintValidatorContext instanceof HibernateConstraintValidatorContext;
        if (StringUtils.isBlank((CharSequence)company.getAction())) {
            if (isHibernateConstraintValidatorContext) {
                String message = "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
                ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
            }
            return false;
        }
        switch (company.getAction()) {
            case "\u65b0\u5efa": {
                isNew = true;
                break;
            }
            case "\u4fee\u6539": {
                isNew = false;
                break;
            }
            default: {
                if (isHibernateConstraintValidatorContext) {
                    String message = "\u64cd\u4f5c\u7c7b\u578b\u5e94\u8be5\u4e3a(" + String.join((CharSequence)",", this.actions) + ")";
                    ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                }
                return false;
            }
        }
        try {
            Reflections.setFieldValue((Object)company, (String)"isNew", (Object)isNew);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        CompanyInfo companyInfo = new CompanyInfo();
        BeanUtils.copyProperties((Object)company, (Object)companyInfo);
        if (isNew) {
            String message;
            Optional companyOptional;
            if (StringUtils.isNotBlank((CharSequence)companyInfo.taxNum)) {
                CompanyModel.Request.Query query = new CompanyModel.Request.Query();
                query.setTaxNum(companyInfo.taxNum);
                companyOptional = this.companyDao.findOne(CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)query));
                if (companyOptional.isPresent()) {
                    if (isHibernateConstraintValidatorContext) {
                        message = "\u91cd\u590d\u7684\u516c\u53f8\u7a0e\u53f7(" + companyInfo.taxNum + ")";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    }
                    valid = false;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)companyInfo.companyCode)) {
                CompanyModel.Request.Query query = new CompanyModel.Request.Query();
                query.setCompanyCode(companyInfo.companyCode);
                companyOptional = this.companyDao.findOne(CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)query));
                if (companyOptional.isPresent()) {
                    if (isHibernateConstraintValidatorContext) {
                        message = "\u91cd\u590d\u7684\u516c\u53f8\u4ee3\u7801(" + companyInfo.companyCode + ")";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    }
                    valid = false;
                }
            }
            if (StringUtils.isBlank((CharSequence)companyInfo.companyName)) {
                if (isHibernateConstraintValidatorContext) {
                    String message2 = "\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
                    ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message2);
                }
                valid = false;
            }
        } else {
            CompanyModel.Request.Query companyQuery;
            Company existCompany = null;
            if (StringUtils.isNotBlank((CharSequence)companyInfo.taxNum)) {
                companyQuery = new CompanyModel.Request.Query();
                companyQuery.setTaxNum(companyInfo.taxNum);
                Optional companyOptional = this.companyDao.findOne(CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)companyQuery));
                if (companyOptional.isPresent()) {
                    existCompany = (Company)companyOptional.get();
                    try {
                        Reflections.setFieldValue((Object)company, (String)"company", (Object)existCompany);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                } else {
                    CompanyApplyModel.Request.Query companyApplyQuery = new CompanyApplyModel.Request.Query();
                    companyApplyQuery.setTaxNum(companyInfo.taxNum);
                    List companyApplies = this.companyApplyDao.findAll(CompanyApplyQueryHelper.queryOneSpecification((CompanyApplyModel.Request.Query)companyApplyQuery));
                    if (!companyApplies.isEmpty()) {
                        try {
                            Reflections.setFieldValue((Object)company, (String)"companyApply", companyApplies.get(0));
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        if (isHibernateConstraintValidatorContext) {
                            String message = "\u4e0d\u5b58\u5728\u7684\u516c\u53f8\u7a0e\u53f7(" + companyInfo.taxNum + ")";
                            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                        }
                        return false;
                    }
                }
            }
            if (existCompany != null) {
                if (StringUtils.isNotBlank((CharSequence)companyInfo.companyCode) && !companyInfo.companyCode.equals(existCompany.getCompanyCode())) {
                    companyQuery = new CompanyModel.Request.Query();
                    companyQuery.setCompanyCode(companyInfo.companyCode);
                    long count = this.companyDao.count(CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)companyQuery));
                    if (count > 0L) {
                        if (isHibernateConstraintValidatorContext) {
                            String message = "\u91cd\u590d\u7684\u516c\u53f8\u4ee3\u7801(" + companyInfo.companyCode + ")";
                            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                        }
                        valid = false;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)companyInfo.companyName) && !companyInfo.companyName.equals(existCompany.getCompanyName())) {
                    if (isHibernateConstraintValidatorContext) {
                        String message = "\u5bfc\u5165\u7684\u516c\u53f8\u540d\u79f0\u4e0e\u539f\u516c\u53f8\u540d\u79f0\u4e0d\u4e00\u81f4";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    }
                    valid = false;
                }
            }
        }
        return valid;
    }

    static class CompanyInfo {
        private Long companyId;
        private String companyName;
        private String companyCode;
        private String taxNum;

        CompanyInfo() {
        }

        public void setCompanyId(Long companyId) {
            this.companyId = companyId;
        }

        public void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        public void setCompanyCode(String companyCode) {
            this.companyCode = companyCode;
        }

        public void setTaxNum(String taxNum) {
            this.taxNum = taxNum;
        }

        public Long getCompanyId() {
            return this.companyId;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public String getCompanyCode() {
            return this.companyCode;
        }

        public String getTaxNum() {
            return this.taxNum;
        }
    }
}

