/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.validator.impl;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.tenant.excel.OrgExcelImportData;
import com.xforceplus.business.validator.ValidateOrg;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.core.utils.reflection.Reflections;
import io.geewit.web.utils.JsonUtils;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgValidator
implements ConstraintValidator<ValidateOrg, OrgExcelImportData> {
    private static final Logger logger = LoggerFactory.getLogger(OrgValidator.class);
    @Autowired
    private OrgStructDao orgDao;
    private String[] actions;

    public void initialize(ValidateOrg constraintAnnotation) {
        this.actions = constraintAnnotation.actions();
    }

    public boolean isValid(OrgExcelImportData org, ConstraintValidatorContext constraintValidatorContext) {
        boolean isNew;
        logger.info("org: {}", (Object)JsonUtils.toJson((Object)org));
        boolean valid = true;
        boolean isHibernateConstraintValidatorContext = constraintValidatorContext instanceof HibernateConstraintValidatorContext;
        if (StringUtils.isBlank((CharSequence)org.getAction())) {
            if (isHibernateConstraintValidatorContext) {
                String message = "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
                ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
            }
            return false;
        }
        switch (org.getAction()) {
            case "\u65b0\u5efa": {
                isNew = true;
                break;
            }
            case "\u4fee\u6539": {
                isNew = false;
                break;
            }
            default: {
                if (isHibernateConstraintValidatorContext) {
                    String message = "\u64cd\u4f5c\u7c7b\u578b\u5e94\u8be5\u4e3a(" + String.join((CharSequence)",", this.actions) + ")";
                    ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                }
                return false;
            }
        }
        if (org.getStatus() == null) {
            org.setStatus(1);
        }
        OrgInfo orgInfo = new OrgInfo();
        BeanUtils.copyProperties((Object)org, (Object)orgInfo);
        if (orgInfo.tenantId == null || orgInfo.tenantId <= 0L) {
            if (isHibernateConstraintValidatorContext) {
                String message = "\u975e\u6cd5\u64cd\u4f5c(\u672a\u83b7\u53d6\u7528\u6237\u4e0a\u4e0b\u6587)";
                ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
            }
            return false;
        }
        if (isNew) {
            if (StringUtils.isBlank((CharSequence)orgInfo.orgName) && isHibernateConstraintValidatorContext) {
                String message = "\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
                ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)orgInfo.orgCode)) {
                OrgModel.Request.Query query = new OrgModel.Request.Query();
                query.setTenantId(orgInfo.tenantId);
                query.setOrgCode(orgInfo.orgCode);
                long count = this.orgDao.count(OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)query));
                if (count > 0L) {
                    if (isHibernateConstraintValidatorContext) {
                        String message = "\u91cd\u590d\u7684\u7ec4\u7ec7\u4ee3\u7801(" + orgInfo.orgCode + ")";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    }
                    valid = false;
                }
            }
            if (valid = this.checkParentCodeAndTaxNumber(orgInfo, isNew, isHibernateConstraintValidatorContext, constraintValidatorContext)) {
                org.setParentCode(orgInfo.getParentCode());
            }
        } else {
            OrgModel.Request.Query orgQuery;
            OrgStruct existOrg = null;
            if (StringUtils.isNotBlank((CharSequence)orgInfo.orgCode)) {
                orgQuery = new OrgModel.Request.Query();
                orgQuery.setTenantId(orgInfo.tenantId);
                orgQuery.setOrgCode(orgInfo.orgCode);
                Optional orgOptional = this.orgDao.findOne(OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)orgQuery));
                if (orgOptional.isPresent()) {
                    existOrg = (OrgStruct)orgOptional.get();
                    valid = this.checkParentCodeAndTaxNumber(orgInfo, isNew, isHibernateConstraintValidatorContext, constraintValidatorContext);
                    try {
                        Reflections.setFieldValue((Object)org, (String)"org", (Object)existOrg);
                        if (valid && orgInfo.parentCode != null) {
                            org.setParentCode(orgInfo.getParentCode());
                        }
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                } else {
                    if (isHibernateConstraintValidatorContext) {
                        String message = "\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u7f16\u53f7(" + orgInfo.orgCode + ")";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    }
                    return false;
                }
            }
            if (existOrg != null && StringUtils.isNotBlank((CharSequence)orgInfo.orgCode) && !orgInfo.orgCode.equals(existOrg.getOrgCode())) {
                orgQuery = new OrgModel.Request.Query();
                orgQuery.setTenantId(orgInfo.tenantId);
                orgQuery.setOrgCode(orgInfo.orgCode);
                long count = this.orgDao.count(OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)orgQuery));
                if (count > 0L) {
                    if (isHibernateConstraintValidatorContext) {
                        String message = "\u91cd\u590d\u7684\u7ec4\u7ec7\u7f16\u53f7(" + orgInfo.orgCode + ")";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    }
                    valid = false;
                }
            }
        }
        return valid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkParentCodeAndTaxNumber(OrgInfo orgInfo, Boolean isNew, boolean isHibernateConstraintValidatorContext, ConstraintValidatorContext constraintValidatorContext) {
        Optional orgCodeOptional;
        Long parentId;
        String parentCode = orgInfo.getParentCode();
        String parentTaxNumber = orgInfo.getParentTaxNumber();
        Long tenantId = orgInfo.getTenantId();
        if (isNew.booleanValue() && StringUtils.isBlank((CharSequence)parentCode) && StringUtils.isBlank((CharSequence)parentTaxNumber) && isHibernateConstraintValidatorContext) {
            String message = "\u4e0a\u7ea7\u7ec4\u7ec7code\u548c\u4e0a\u7ea7\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            OrgModel.Request.Query orgQuery = new OrgModel.Request.Query();
            orgQuery.setTenantId(tenantId);
            orgQuery.setOrgCode(parentCode);
            orgQuery.setStatus(Integer.valueOf(1));
            Optional optionalOrgStruct = this.orgDao.findOne(OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)orgQuery));
            if (optionalOrgStruct.isPresent()) {
                if (parentTaxNumber != null) {
                    OrgStruct orgStruct = (OrgStruct)optionalOrgStruct.get();
                    if (OrgType.COMPANY.equals((Object)orgStruct.getOrgType())) {
                        String taxNumer = orgStruct.getTaxNum();
                        if (parentTaxNumber.equalsIgnoreCase(taxNumer) || !isHibernateConstraintValidatorContext) return false;
                        String message = "\u4e0a\u7ea7\u7ec4\u7ec7code\u548c\u4e0a\u7ea7\u516c\u53f8\u7a0e\u53f7\u4e0d\u4e00\u81f4";
                        ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                        return false;
                    }
                    if (!isHibernateConstraintValidatorContext) return false;
                    String message = "\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u662f\u516c\u53f8\uff0c\u975e\u6cd5\u7684\u4e0a\u7ea7\u516c\u53f8\u7a0e\u53f7";
                    ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
                    return false;
                }
                orgInfo.setParentCode(((OrgStruct)optionalOrgStruct.get()).getOrgCode());
                return true;
            }
            if (!isHibernateConstraintValidatorContext) return false;
            String message = "\u4e0a\u7ea7\u7ec4\u7ec7code\u4e0d\u5b58\u5728";
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
            return false;
        }
        if (parentTaxNumber != null) {
            Optional orgStructOptional = this.orgDao.findOrgStructByTaxNumAndTenantId(parentTaxNumber, tenantId);
            if (orgStructOptional.isPresent()) {
                orgInfo.setParentCode(((OrgStruct)orgStructOptional.get()).getOrgCode());
                return true;
            }
            if (!isHibernateConstraintValidatorContext) return false;
            String message = "\u4e0a\u7ea7\u516c\u53f8\u7a0e\u53f7\u4e0d\u5b58\u5728";
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("message", (Object)message);
            return false;
        }
        OrgModel.Request.Query orgQuery = new OrgModel.Request.Query();
        orgQuery.setTenantId(tenantId);
        orgQuery.setOrgCode(orgInfo.getOrgCode());
        orgQuery.setStatus(Integer.valueOf(1));
        Optional optionalOrgStruct = this.orgDao.findOne(OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)orgQuery));
        if (!optionalOrgStruct.isPresent() || (parentId = ((OrgStruct)optionalOrgStruct.get()).getParentId()) == null || !(orgCodeOptional = this.orgDao.findOrgCodeByTenantIdAndOrgId(tenantId.longValue(), parentId.longValue())).isPresent()) return true;
        orgInfo.setParentCode((String)orgCodeOptional.get());
        return true;
    }

    static class OrgInfo {
        private Long orgId;
        private Long tenantId;
        private String orgName;
        private String orgCode;
        private Long parentId;
        private String parentCode;
        private String parentTaxNumber;

        OrgInfo() {
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }

        public void setOrgCode(String orgCode) {
            this.orgCode = orgCode;
        }

        public void setParentId(Long parentId) {
            this.parentId = parentId;
        }

        public void setParentCode(String parentCode) {
            this.parentCode = parentCode;
        }

        public void setParentTaxNumber(String parentTaxNumber) {
            this.parentTaxNumber = parentTaxNumber;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public String getOrgName() {
            return this.orgName;
        }

        public String getOrgCode() {
            return this.orgCode;
        }

        public Long getParentId() {
            return this.parentId;
        }

        public String getParentCode() {
            return this.parentCode;
        }

        public String getParentTaxNumber() {
            return this.parentTaxNumber;
        }
    }
}

