/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.wechat.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.wechat.WechatInfoApi;
import com.xforceplus.business.wechat.dto.WechatInfoAndPlatformResp;
import com.xforceplus.business.wechat.service.WechatInfoService;
import com.xforceplus.business.wechat.service.WechatMpService;
import com.xforceplus.domain.account.CreateQrcodeReq;
import com.xforceplus.domain.account.WechatConfigReq;
import com.xforceplus.domain.account.WechatConfigResp;
import com.xforceplus.domain.account.WechatInfoResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5fae\u4fe1\u4fe1\u606f\u63a5\u53e3", description="\u5fae\u4fe1\u4fe1\u606f\u63a5\u53e3")
@Controller
public class WechatInfoController
implements WechatInfoApi {
    private static final Logger logger = LoggerFactory.getLogger(WechatInfoController.class);
    private final WechatInfoService wechatInfoService;
    private final WechatMpService wechatMpService;

    public WechatInfoController(WechatInfoService wechatInfoService, WechatMpService wechatMpService) {
        this.wechatInfoService = wechatInfoService;
        this.wechatMpService = wechatMpService;
    }

    public ResponseEntity<WechatInfoResp> info() {
        WechatInfoResp wechatInfoResp = this.wechatInfoService.getInfo();
        return ResponseEntity.okWithCode((Object)wechatInfoResp);
    }

    public ResponseEntity<WechatConfigResp> config(WechatConfigReq wechatConfigReq) {
        WechatConfigResp wechatConfigResp = this.wechatInfoService.getConfig(wechatConfigReq.getUrl());
        return ResponseEntity.okWithCode((Object)wechatConfigResp);
    }

    @ApiOperation(value="\u751f\u6210\u5e26\u53c2\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801", notes="\u751f\u6210\u5e26\u53c2\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801")
    public ResponseEntity<String> create(CreateQrcodeReq qrcodeReq) {
        String showUrl = this.wechatMpService.create(qrcodeReq.getAppid(), qrcodeReq.getSecret(), qrcodeReq.getSceneStr());
        return ResponseEntity.ok((Object)showUrl);
    }

    @ApiOperation(value="\u6839\u636euserId\u67e5\u8be2\u914d\u7f6e\u548c\u8d26\u6237\u5173\u8054")
    @ResponseBody
    @RequestMapping(name="\u6839\u636euserId\u67e5\u8be2\u914d\u7f6e\u548c\u8d26\u6237\u5173\u8054", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/wechat/info-platform/users/{userId}"}, method={RequestMethod.GET})
    public ResponseEntity<WechatInfoAndPlatformResp> queryOpenIdAndPlatform(@PathVariable(value="userId") Long userId) {
        logger.error("enter queryOpenIdAndPlatform");
        WechatInfoAndPlatformResp wechatInfoAndPlatformResp = this.wechatInfoService.queryOpenIdAndPlatform(userId);
        return ResponseEntity.ok((Object)wechatInfoAndPlatformResp);
    }
}

