/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.wechat.service;

import com.xforceplus.business.account.service.AccessTokenResp;
import com.xforceplus.business.account.service.AccessTokenService;
import com.xforceplus.business.wechat.service.TicketResp;
import com.xforceplus.business.wechat.service.TicketService;
import com.xforceplus.config.RedisPrefixUtilService;
import com.xforceplus.dao.WechatInfoDao;
import com.xforceplus.entity.WechatInfo;
import io.geewit.web.utils.JsonUtils;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;

public class WechatInfoTask {
    private static final Logger logger = LoggerFactory.getLogger(WechatInfoTask.class);
    private static final int PERIOD = 7200;
    private static final int PRE_REFRESH = 1200;
    private static final String TASK_KEY = "wechat_access_token";
    @Resource
    private WechatInfoDao wechatInfoDao;
    @Resource
    private AccessTokenService accessTokenService;
    @Resource
    private TicketService ticketService;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private RedisPrefixUtilService redisPrefixUtilService;

    @Scheduled(cron="0 0/10 * * * ?")
    public void updateTask() {
        boolean needTicket;
        String key = this.redisPrefixUtilService.processPrefix(TASK_KEY);
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"value", 3L, TimeUnit.MINUTES);
        if (result == null || !result.booleanValue()) {
            logger.info("\u6c92\u6709\u7372\u53d6\u5230\u9396=={}", result == null ? "null" : Boolean.valueOf(false));
            return;
        }
        WechatInfo wechatInfo = this.wechatInfoDao.findFirstByStatusEquals(1);
        boolean needToken = this.isNeedToken(wechatInfo);
        if (needToken) {
            AccessTokenResp accessTokenResp = this.accessTokenService.accessToken();
            if (wechatInfo == null) {
                wechatInfo = new WechatInfo();
            }
            if (accessTokenResp != null && StringUtils.isNotBlank((CharSequence)accessTokenResp.getAccess_token())) {
                wechatInfo.setAccessToken(accessTokenResp.getAccess_token());
                wechatInfo.setTokenPeriod(Integer.valueOf(accessTokenResp.getExpires_in()));
                wechatInfo.setStatus(Integer.valueOf(1));
                wechatInfo.setTokenTime(new Date());
                wechatInfo.setUpdateTime(new Date());
                this.wechatInfoDao.saveAndFlush((Object)wechatInfo);
            }
        }
        if (needTicket = this.isNeedTicket(wechatInfo)) {
            TicketResp ticketResp = this.ticketService.ticket(wechatInfo.getAccessToken());
            if (ticketResp == null || ticketResp.getErrcode() != 0) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)ticketResp.getTicket())) {
                wechatInfo.setJsapiTicket(ticketResp.getTicket());
                wechatInfo.setTicketPeriod(Integer.valueOf(ticketResp.getExpires_in()));
                wechatInfo.setStatus(Integer.valueOf(1));
                wechatInfo.setTicketTime(new Date());
                wechatInfo.setUpdateTime(new Date());
                this.wechatInfoDao.saveAndFlush((Object)wechatInfo);
            }
        }
        logger.debug("wechatInfo==={}", (Object)JsonUtils.toJson((Object)wechatInfo));
    }

    private boolean isNeedTicket(WechatInfo wechatInfo) {
        if (wechatInfo == null || StringUtils.isBlank((CharSequence)wechatInfo.getJsapiTicket())) {
            return true;
        }
        Date startTime = wechatInfo.getTicketTime();
        if (startTime == null) {
            return true;
        }
        Integer interval = wechatInfo.getTicketPeriod();
        if (interval == null || interval <= 0) {
            interval = 7200;
        }
        interval = interval - 1200;
        Date expireTime = DateUtils.addSeconds((Date)startTime, (int)interval);
        return expireTime.before(new Date());
    }

    private boolean isNeedToken(WechatInfo wechatInfo) {
        if (wechatInfo == null || StringUtils.isBlank((CharSequence)wechatInfo.getAccessToken())) {
            return true;
        }
        Date startTime = wechatInfo.getTokenTime();
        if (startTime == null) {
            return true;
        }
        Integer interval = wechatInfo.getTokenPeriod();
        if (interval == null || interval <= 0) {
            interval = 7200;
        }
        interval = interval - 1200;
        Date expireTime = DateUtils.addSeconds((Date)startTime, (int)interval);
        return expireTime.before(new Date());
    }
}

