/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.alibaba.ttl.spi.TtlWrapper;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.xforceplus.config.MdcTaskDecorator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class GlobalThreadPoolConfig
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(GlobalThreadPoolConfig.class);
    private static final Integer CPU_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 8);
    private static final Integer QUEUE_SIZE = 100000;
    private static final String THREAD_NAME = "async-thread-";

    @Bean(value={"threadPoolExecutor"})
    public ThreadPoolExecutor getAsyncThreadPoolExecutor() {
        TtlWrapper ttlWrapper = (TtlWrapper)this.getAsyncExecutor();
        if (ttlWrapper == null) {
            throw new RuntimeException("ttlWrapper is null");
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)ttlWrapper.unwrap();
        return executor;
    }

    public ExecutorService getAsyncExecutor() {
        log.info("global-thread-cpu-size={}", (Object)CPU_SIZE);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(CPU_SIZE.intValue());
        executor.setMaxPoolSize(CPU_SIZE * 2);
        executor.setQueueCapacity(QUEUE_SIZE.intValue());
        executor.setThreadNamePrefix(THREAD_NAME);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return TtlExecutors.getTtlExecutorService((ExecutorService)executor.getThreadPoolExecutor());
    }

    @Bean(name={"threadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(CPU_SIZE.intValue());
        executor.setMaxPoolSize(CPU_SIZE * 2);
        executor.setQueueCapacity(QUEUE_SIZE.intValue());
        executor.setTaskDecorator((TaskDecorator)new MdcTaskDecorator());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Scheduled(fixedRate=30L, timeUnit=TimeUnit.SECONDS)
    public void threadInfo() {
        ThreadPoolExecutor executor = this.getAsyncThreadPoolExecutor();
        log.info("global thread:current active thread size={},max thread size={},current queue size={},task count={},completed task count={}", new Object[]{executor.getActiveCount(), executor.getLargestPoolSize(), executor.getQueue().size(), executor.getTaskCount(), executor.getCompletedTaskCount()});
    }
}

