/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.xforceplus.config.ThreadPoolConfig;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ImportExportThreadPool {
    private static final Logger log = LoggerFactory.getLogger(ImportExportThreadPool.class);
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR;
    public static final Integer CORE_POOL_SIZE;

    private ImportExportThreadPool() {
    }

    public static ThreadPoolExecutor get() {
        return THREAD_POOL_EXECUTOR;
    }

    @Scheduled(fixedRate=30L, timeUnit=TimeUnit.SECONDS)
    private void info() {
        log.info("import-export-thread-info:current active thread={}, max thread count={},current queue size={},task count={},completed task count={}", new Object[]{THREAD_POOL_EXECUTOR.getActiveCount(), THREAD_POOL_EXECUTOR.getLargestPoolSize(), THREAD_POOL_EXECUTOR.getQueue().size(), THREAD_POOL_EXECUTOR.getTaskCount(), THREAD_POOL_EXECUTOR.getCompletedTaskCount()});
    }

    static {
        CORE_POOL_SIZE = 8;
        THREAD_POOL_EXECUTOR = ThreadPoolConfig.config().corePoolSize(CORE_POOL_SIZE).maximumPoolSize(CORE_POOL_SIZE * 2).queueSize(20000).keepAliveTime(60L).timeUnit(TimeUnit.SECONDS).name("i-e-handler").build();
        log.info("import-export thread pool initialized");
    }
}

