/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config.interceptor;

import com.xforceplus.utils.IpUtils;
import io.geewit.utils.uuid.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LogInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception arg3) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView arg3) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceId = request.getHeader("traceId");
        if (StringUtils.isEmpty((CharSequence)traceId)) {
            traceId = UUID.randomUUID().toString();
        }
        MDC.put((String)"traceId", (String)traceId);
        MDC.put((String)"ip", (String)IpUtils.getIp(request));
        MDC.put((String)"url", (String)request.getRequestURL().toString());
        MDC.put((String)"method", (String)request.getMethod());
        MDC.put((String)"path", (String)request.getRequestURI());
        return true;
    }
}

