/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.business.account.service.PasswordHistoryService;
import com.xforceplus.dao.UserDao;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.PasswordHistory;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.security.strategy.model.NewAccountStrategy;
import com.xforceplus.security.strategy.model.PasswordPatternStrategy;
import com.xforceplus.security.strategy.model.PasswordRepetitionStrategy;
import com.xforceplus.security.strategy.service.StrategyService;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AccountSaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(AccountSaveEventListener.class);
    private final UserDao userDao;
    private final StrategyService strategyService;
    private final PasswordHistoryService passwordHistoryService;

    public AccountSaveEventListener(UserDao userDao, StrategyService strategyService, PasswordHistoryService passwordHistoryService) {
        this.userDao = userDao;
        this.strategyService = strategyService;
        this.passwordHistoryService = passwordHistoryService;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.entity.Account)")
    public void accountSaveListener(EntityPreSaveEvent<Account> event) {
        Account account = (Account)event.getSource();
        Set tenantIds = RevisionMetadata.RevisionType.UPDATE.equals((Object)event.getRevisionType()) && account.getTenantId() == null ? this.userDao.findTenantIdsByAccountId(account.getAccountId().longValue()) : Stream.of(account.getTenantId()).collect(Collectors.toSet());
        if (RevisionMetadata.RevisionType.INSERT.equals((Object)event.getRevisionType())) {
            this.setExtendProperties(account, tenantIds);
        }
        if (StringUtils.isBlank((CharSequence)account.getRawPassword())) {
            return;
        }
        this.validPasswordPattern(account, tenantIds);
        if (RevisionMetadata.RevisionType.UPDATE.equals((Object)event.getRevisionType())) {
            this.validPasswordRepetition(account, tenantIds);
        }
    }

    private void setExtendProperties(Account account, Set<Long> tenantIds) {
        Map<Long, NewAccountStrategy> strategyMap = this.strategyService.loadStrategiesMap(tenantIds, NewAccountStrategy.class);
        NewAccountStrategy defaultStrategy = new NewAccountStrategy();
        strategyMap.values().stream().findFirst().ifPresent(strategy -> BeanUtils.copyProperties((Object)strategy, (Object)defaultStrategy));
        if (!defaultStrategy.isEnabled()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)account.getTelPhone()) && StringUtils.isEmpty((CharSequence)account.getEmail())) {
            account.setBindAuthFlag(defaultStrategy.getNeedBindContact());
        }
        account.setChangePasswordFlag(defaultStrategy.getNeedChangePassword());
    }

    private void validPasswordPattern(Account account, Set<Long> tenantIds) {
        Pattern pattern;
        Map<Long, PasswordPatternStrategy> strategyMap = this.strategyService.loadStrategiesMap(tenantIds, PasswordPatternStrategy.class);
        PasswordPatternStrategy defaultStrategy = new PasswordPatternStrategy();
        strategyMap.values().stream().max((o1, o2) -> o1.compareTo(o2)).ifPresent(strategy -> BeanUtils.copyProperties((Object)strategy, (Object)defaultStrategy));
        if (!defaultStrategy.isEnabled()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)defaultStrategy.getPattern()) && !(pattern = PasswordPatternStrategy.findPattern(defaultStrategy.getPattern())).matcher(account.getRawPassword()).matches()) {
            throw new IllegalArgumentException(defaultStrategy.getMessage());
        }
        int passwordLength = defaultStrategy.minLength();
        account.setPasswdLength(Integer.valueOf(passwordLength));
    }

    private void validPasswordRepetition(Account account, Set<Long> tenantIds) {
        boolean exist;
        PasswordRepetitionStrategy strategy = this.loadPasswordRepetitionStrategy(tenantIds);
        if (strategy != null && strategy.isEnabled() && strategy.getRepetition() != null && strategy.getRepetition() > 0 && (exist = this.passwordHistoryService.existPasswordInHistory(account.getAccountId(), account.getPassword(), strategy.getRepetition()))) {
            throw new IllegalArgumentException(strategy.getMessage());
        }
    }

    private PasswordRepetitionStrategy loadPasswordRepetitionStrategy(Set<Long> tenantIds) {
        Map<Long, PasswordRepetitionStrategy> strategyMap = this.strategyService.loadStrategiesMap(tenantIds, PasswordRepetitionStrategy.class);
        PasswordRepetitionStrategy defaultStrategy = new PasswordRepetitionStrategy();
        strategyMap.values().stream().filter(PasswordRepetitionStrategy::isEnabled).max(PasswordRepetitionStrategy::compareTo).ifPresent(strategy -> BeanUtils.copyProperties((Object)strategy, (Object)defaultStrategy));
        return defaultStrategy;
    }

    @Async(value="threadPoolExecutor")
    @EventListener(classes={EntityPostSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.entity.PasswordHistory)")
    public void postSaveListener(EntityPostSaveEvent<PasswordHistory> event) {
        PasswordHistory passwordHistory = (PasswordHistory)event.getSource();
        Set<Long> tenantIds = passwordHistory.getTenantId() == null ? this.userDao.findTenantIdsByAccountId(passwordHistory.getAccountId().longValue()) : Stream.of(passwordHistory.getTenantId()).collect(Collectors.toSet());
        PasswordRepetitionStrategy strategy = this.loadPasswordRepetitionStrategy(tenantIds);
        if (!strategy.isEnabled()) {
            return;
        }
        Integer repetition = strategy.getRepetition();
        if (repetition == null || repetition <= 0) {
            return;
        }
        try {
            this.passwordHistoryService.savePassword(passwordHistory.getAccountId(), passwordHistory.getPassword(), strategy.getRepetition());
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }
}

