/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.google.common.collect.Lists;
import com.xforceplus.client.ActionTrailClient;
import com.xforceplus.client.vo.MetricEvent;
import com.xforceplus.client.vo.Response;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.web.utils.JsonUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.persistence.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ActionTrailEventListener {
    private static final Logger log = LoggerFactory.getLogger(ActionTrailEventListener.class);
    private final ActionTrailClient actionTrailClient;
    @Value(value="${app.isPaas:true}")
    private boolean isPaas;

    public ActionTrailEventListener(ActionTrailClient actionTrailClient) {
        this.actionTrailClient = actionTrailClient;
    }

    @Async(value="threadPoolTaskExecutor")
    @EventListener(classes={EntityPostSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.entity.Company) || event.source instanceof T(com.xforceplus.entity.Tenant) || event.source instanceof T(com.xforceplus.entity.OrgStruct) || event.source instanceof T(com.xforceplus.entity.RoleUserRel)")
    public <T> void actionTrailListener(EntityPostSaveEvent<T> event) {
        if (!this.isPaas) {
            return;
        }
        try {
            Long tenantId = this.getTenant(event.getSource());
            String traceId = MDC.get((String)"traceId");
            String url = MDC.get((String)"url");
            String ip = MDC.get((String)"ip");
            String method = MDC.get((String)"method");
            String path = MDC.get((String)"path");
            IAuthorizedUser iAuthorizedUser = UserInfoHolder.get();
            MetricEvent metricEvent = new MetricEvent.Builder().eventId(traceId).tenantId(tenantId).userInfo(iAuthorizedUser).eventType(event.getRevisionType().name()).build();
            String body = JsonUtils.toJson((Object)event.getSource());
            metricEvent.setRequestBody(body);
            metricEvent.setHost(ip);
            metricEvent.setHttpMethod(method);
            metricEvent.setUri(url);
            metricEvent.setPath(path);
            this.saveAction(metricEvent);
        }
        catch (Exception e) {
            log.error("actionTrailListenerEvent error", (Throwable)e);
        }
    }

    private void saveAction(MetricEvent metricEvent) {
        try {
            log.debug("saveAction request body:{}", (Object)JsonUtils.toJson((Object)metricEvent));
            ArrayList list = Lists.newArrayList((Object[])new MetricEvent[]{metricEvent});
            Response response = this.actionTrailClient.saveAction(list);
            log.debug("saveAction response,traceId:{},body:{}", (Object)metricEvent.getEventId(), (Object)JsonUtils.toJson((Object)response));
        }
        catch (Exception e) {
            log.error("SaveAction error", (Throwable)e);
        }
    }

    private Long getTenant(Object obj) {
        Long tenantId = 0L;
        Class<?> doClass = obj.getClass();
        try {
            for (Method method : doClass.getMethods()) {
                Column column = method.getAnnotation(Column.class);
                if (null == column || !"tenant_id".equals(column.name()) || !method.getName().startsWith("get")) continue;
                method.setAccessible(true);
                tenantId = (Long)method.invoke(obj, new Object[0]);
                break;
            }
        }
        catch (Exception e) {
            log.error("actionTrailListenerEvent error getTenant", (Throwable)e);
        }
        return tenantId;
    }
}

