/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.dao.TenantDao;
import com.xforceplus.event.dto.CompanyNameChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanySaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(CompanySaveEventListener.class);
    private final TenantDao tenantDao;

    public CompanySaveEventListener(TenantDao tenantDao) {
        this.tenantDao = tenantDao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    @EventListener(classes={EntityPostSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.CompanyNameChanged)")
    public void companyNameChangeListener(EntityPostSaveEvent<CompanyNameChanged> event) {
        CompanyNameChanged companyNameChanged = (CompanyNameChanged)event.getSource();
        String preCompanyName = companyNameChanged.getPreCompanyName();
        String postCompanyName = companyNameChanged.getPostCompanyName();
        List tenants = this.tenantDao.findByCompanyId(companyNameChanged.getCompanyId());
        tenants.stream().filter(tenant -> StringUtils.equals((CharSequence)tenant.getTenantName(), (CharSequence)preCompanyName)).forEach(tenant -> {
            tenant.setTenantName(postCompanyName);
            this.tenantDao.saveAndFlush(tenant);
        });
    }
}

