/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.event.dto.OrgCodeChanged;
import com.xforceplus.event.dto.OrgParentIdsBuild;
import com.xforceplus.event.dto.OrgParentIdsRebuild;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.event.model.EntityPreSaveEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrgSaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(OrgSaveEventListener.class);
    private final OrgStructDao orgStructDao;

    public OrgSaveEventListener(OrgStructDao orgStructDao) {
        this.orgStructDao = orgStructDao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=true)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.OrgCodeChanged)")
    public void validListener(EntityPreSaveEvent<OrgCodeChanged> event) {
        OrgCodeChanged orgCodeValidation = (OrgCodeChanged)event.getSource();
        OrgStruct org = orgCodeValidation.getEntity();
        long count = this.orgStructDao.countByTenantIdAndOrgCode(org.getTenantId().longValue(), org.getOrgCode());
        if (count > 0L) {
            throw new IllegalArgumentException("\u79df\u6237(" + org.getTenantId() + ")\u4e0b\u5df2\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7code(" + org.getOrgCode() + ")");
        }
    }

    @Transactional(readOnly=true)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.OrgParentIdsBuild)")
    public void buildParentIdsListener(EntityPreSaveEvent<OrgParentIdsBuild> event) {
        OrgParentIdsBuild orgParentIdsBuild = (OrgParentIdsBuild)event.getSource();
        OrgStruct org = orgParentIdsBuild.getEntity();
        StringBuilder builder = new StringBuilder();
        if (org.getParentId() != null && org.getParentId() > 0L) {
            String parentIds = RevisionMetadata.RevisionType.INSERT.equals((Object)event.getRevisionType()) ? this.orgStructDao.findUcommittedParentIdsByOrgId(org.getParentId().longValue()) : this.orgStructDao.findCommittedParentIdsByOrgId(org.getParentId().longValue());
            if (parentIds != null) {
                builder.append(parentIds);
            } else {
                String message = "\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7parentId(" + org.getParentId() + ")";
                log.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        if (org.getOrgId() != null) {
            builder.append(org.getOrgId());
        }
        if (org.getOrgType() != null) {
            builder.append(org.getOrgType().separator());
        }
        org.setParentIds(builder.toString());
    }

    @Async(value="threadPoolExecutor")
    @EventListener(classes={EntityPostSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.OrgParentIdsRebuild)")
    public void rebuildParentIdsListener(EntityPostSaveEvent<OrgParentIdsRebuild> event) {
        OrgParentIdsRebuild parentIdsRebuild = (OrgParentIdsRebuild)event.getSource();
        String previousParentIds = parentIdsRebuild.getPreviousParentIds();
        String nextParentIds = parentIdsRebuild.getNextParentIds();
        this.orgStructDao.updateParentIds(previousParentIds, nextParentIds);
    }
}

