/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.dao.ResourceDao;
import com.xforceplus.entity.Resource;
import com.xforceplus.event.dto.ResourceCodeChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResourceSaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceSaveEventListener.class);
    private final ResourceDao resourceDao;

    public ResourceSaveEventListener(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.ResourceCodeChanged)")
    public void validCodeListener(EntityPreSaveEvent<ResourceCodeChanged> event) {
        ResourceCodeChanged codeChanged = (ResourceCodeChanged)event.getSource();
        Resource resource = codeChanged.getEntity();
        long count = this.resourceDao.countByAppIdAndResourceCode(resource.getAppId().longValue(), resource.getResourceCode());
        if (count > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8d44\u6e90\u7801(appId:" + resource.getAppId() + ", code:" + resource.getResourceCode() + ")");
        }
    }
}

