/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.dao.RoleDao;
import com.xforceplus.entity.Role;
import com.xforceplus.event.dto.RoleCodeChanged;
import com.xforceplus.event.dto.RoleNameChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RoleSaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(RoleSaveEventListener.class);
    private final RoleDao roleDao;

    public RoleSaveEventListener(RoleDao roleDao) {
        this.roleDao = roleDao;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.RoleCodeChanged)")
    public void validCodeListener(EntityPreSaveEvent<RoleCodeChanged> event) {
        long count;
        RoleCodeChanged roleValidation = (RoleCodeChanged)event.getSource();
        Role role = roleValidation.getEntity();
        Long tenantId = role.getTenantId();
        if (tenantId == null) {
            tenantId = 0L;
        }
        if ((count = this.roleDao.countByTenantIdAndCode(tenantId.longValue(), role.getCode())) > 0L) {
            throw new IllegalArgumentException("\u91cd\u590d\u7684\u89d2\u8272\u4ee3\u7801(" + role.getCode() + ")");
        }
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.RoleNameChanged)")
    public void validNameListener(EntityPreSaveEvent<RoleNameChanged> event) {
        long count;
        RoleNameChanged roleValidation = (RoleNameChanged)event.getSource();
        Role role = roleValidation.getEntity();
        Long tenantId = role.getTenantId();
        if (tenantId == null) {
            tenantId = 0L;
        }
        if ((count = this.roleDao.countByTenantIdAndName(tenantId.longValue(), role.getName())) > 0L) {
            throw new IllegalArgumentException("\u91cd\u590d\u7684\u89d2\u8272\u540d\u79f0(" + role.getCode() + ")");
        }
    }
}

