/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.dao.ServicePackageDao;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.event.dto.ServicePackageCodeChanged;
import com.xforceplus.event.dto.ServicePackageNameChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ServicePackageSaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(ServicePackageSaveEventListener.class);
    private final ServicePackageDao servicePackageDao;

    public ServicePackageSaveEventListener(ServicePackageDao servicePackageDao) {
        this.servicePackageDao = servicePackageDao;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.ServicePackageCodeChanged)")
    public void validCodeListener(EntityPreSaveEvent<ServicePackageCodeChanged> event) {
        ServicePackageCodeChanged codeChanged = (ServicePackageCodeChanged)event.getSource();
        ServicePackage entity = codeChanged.getEntity();
        long count = this.servicePackageDao.countByServicePackageCode(entity.getServicePackageCode());
        if (count > 0L) {
            throw new IllegalArgumentException("\u5df2\u5b58\u5728\u8be5\u670d\u52a1\u5305\u4ee3\u7801(" + entity.getServicePackageCode() + ")");
        }
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.ServicePackageNameChanged)")
    public void validNameListener(EntityPreSaveEvent<ServicePackageNameChanged> event) {
        ServicePackageNameChanged nameChanged = (ServicePackageNameChanged)event.getSource();
        ServicePackage entity = nameChanged.getEntity();
        long count = this.servicePackageDao.countByServicePackageName(entity.getAppId().longValue(), entity.getServicePackageName());
        if (count > 0L) {
            throw new IllegalArgumentException("\u5df2\u5b58\u5728\u8be5\u670d\u52a1\u5305\u540d\u79f0(appId:" + entity.getAppId() + ",\u540d\u79f0:" + entity.getServicePackageName() + ")");
        }
    }
}

