/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.listener;

import com.xforceplus.api.model.TenantModel;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.event.dto.TenantCodeChanged;
import com.xforceplus.event.dto.TenantNameChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.query.TenantQueryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TenantSaveEventListener {
    private static final Logger log = LoggerFactory.getLogger(TenantSaveEventListener.class);
    private final TenantDao tenantDao;
    private final OrgService orgService;

    public TenantSaveEventListener(TenantDao tenantDao, OrgService orgService) {
        this.tenantDao = tenantDao;
        this.orgService = orgService;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.TenantCodeChanged)")
    public void validCodeListener(EntityPreSaveEvent<TenantCodeChanged> event) {
        TenantCodeChanged codeChanged = (TenantCodeChanged)event.getSource();
        Tenant tenant = codeChanged.getEntity();
        TenantModel.Request.Query query = new TenantModel.Request.Query();
        query.setTenantCode(tenant.getTenantCode());
        long count = this.tenantDao.count(TenantQueryHelper.queryOneSpecification((TenantModel.Request.Query)query));
        if (count > 0L) {
            throw new IllegalArgumentException("\u79df\u6237\u7f16\u7801(" + tenant.getTenantCode() + ")\u5df2\u5b58\u5728");
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    @EventListener(classes={EntityPreSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.TenantNameChanged)")
    public void validNameListener(EntityPreSaveEvent<TenantNameChanged> event) {
        TenantNameChanged nameChanged = (TenantNameChanged)event.getSource();
        Tenant tenant = nameChanged.getEntity();
        TenantModel.Request.Query query = new TenantModel.Request.Query();
        query.setTenantName(tenant.getTenantName());
        long count = this.tenantDao.count(TenantQueryHelper.queryOneSpecification((TenantModel.Request.Query)query));
        if (count > 0L) {
            throw new IllegalArgumentException("\u79df\u6237\u540d\u79f0(" + tenant.getTenantName() + ")\u5df2\u5b58\u5728");
        }
    }

    @Async(value="threadPoolExecutor")
    @EventListener(classes={EntityPostSaveEvent.class}, condition="event.source instanceof T(com.xforceplus.event.dto.TenantNameChanged)")
    public void tenantNameChangedListener(EntityPostSaveEvent<TenantNameChanged> event) {
        TenantNameChanged nameChanged = (TenantNameChanged)event.getSource();
        Tenant tenant = nameChanged.getEntity();
        long tenantId = tenant.getTenantId();
        String tenantName = tenant.getTenantName();
        this.orgService.changeRootName(tenantId, tenantName);
    }
}

