/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.event.subscriber;

import com.xforceplus.security.strategy.event.RefreshingStrategyCacheEvent;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Service;

@Service
public class RefreshingStrategyMessageSubscriber
implements ApplicationEventPublisherAware,
MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RefreshingStrategyMessageSubscriber.class);
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void onMessage(Message message, byte[] pattern) {
        String refreshId = new String(message.getBody(), StandardCharsets.UTF_8);
        log.info("onMessage with redis expire: " + refreshId);
        this.publisher.publishEvent((ApplicationEvent)new RefreshingStrategyCacheEvent(refreshId));
        log.info("----------refresh strategy cache done-----------{}", (Object)refreshId);
    }
}

