/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jackson.databind.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.config.GlobalProperties;
import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@JsonComponent
public class ResponseEntitySerializer
extends JsonSerializer<ResponseEntity>
implements ApplicationContextAware {
    private final ObjectMapper mapper;
    private final GlobalProperties globalProperties;

    public ResponseEntitySerializer(ObjectMapper mapper, GlobalProperties globalProperties) {
        this.mapper = mapper;
        this.globalProperties = globalProperties;
    }

    public void serialize(ResponseEntity value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("code");
        generator.writeString(value.getCode());
        generator.writeFieldName("message");
        generator.writeString(value.getMessage());
        if (value.getResult() != null) {
            boolean jsonViewEnabled;
            generator.writeFieldName("result");
            boolean defaultViewInclusionEnabled = this.mapper.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
            boolean bl = jsonViewEnabled = this.globalProperties != null ? this.globalProperties.isJsonViewEnabled() : true;
            if (jsonViewEnabled && defaultViewInclusionEnabled) {
                this.mapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
            }
            String json = this.mapper.writerWithView(provider.getActiveView()).writeValueAsString(value.getResult());
            if (jsonViewEnabled && defaultViewInclusionEnabled) {
                this.mapper.enable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
            }
            generator.writeRawValue(json);
        }
        generator.writeEndObject();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }
}

