/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.login.context;

import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.model.TwoFactorType;
import java.util.Set;
import org.springframework.http.ResponseCookie;

public class LoginContext<T extends LoginRequest> {
    private String loginName;
    private String password;
    private Long currentTenantId;
    private Set<Long> tenantIds;
    private Long accountId;
    private User user;
    private Account account;
    private String token;
    private T loginRequest;
    private LoginTokenResponse response;
    private Captcha captcha;
    private String host;
    private Set<ResponseCookie> cookies;
    private boolean needEncrypt;
    private Boolean success;

    private static <T extends LoginRequest> boolean $default$needEncrypt() {
        return true;
    }

    private static <T extends LoginRequest> Boolean $default$success() {
        return null;
    }

    LoginContext(String loginName, String password, Long currentTenantId, Set<Long> tenantIds, Long accountId, User user, Account account, String token, T loginRequest, LoginTokenResponse response, Captcha captcha, String host, Set<ResponseCookie> cookies, boolean needEncrypt, Boolean success) {
        this.loginName = loginName;
        this.password = password;
        this.currentTenantId = currentTenantId;
        this.tenantIds = tenantIds;
        this.accountId = accountId;
        this.user = user;
        this.account = account;
        this.token = token;
        this.loginRequest = loginRequest;
        this.response = response;
        this.captcha = captcha;
        this.host = host;
        this.cookies = cookies;
        this.needEncrypt = needEncrypt;
        this.success = success;
    }

    public static <T extends LoginRequest> LoginContextBuilder<T> builder() {
        return new LoginContextBuilder();
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCurrentTenantId(Long currentTenantId) {
        this.currentTenantId = currentTenantId;
    }

    public void setTenantIds(Set<Long> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setLoginRequest(T loginRequest) {
        this.loginRequest = loginRequest;
    }

    public void setResponse(LoginTokenResponse response) {
        this.response = response;
    }

    public void setCaptcha(Captcha captcha) {
        this.captcha = captcha;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setCookies(Set<ResponseCookie> cookies) {
        this.cookies = cookies;
    }

    public void setNeedEncrypt(boolean needEncrypt) {
        this.needEncrypt = needEncrypt;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public Long getCurrentTenantId() {
        return this.currentTenantId;
    }

    public Set<Long> getTenantIds() {
        return this.tenantIds;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public User getUser() {
        return this.user;
    }

    public Account getAccount() {
        return this.account;
    }

    public String getToken() {
        return this.token;
    }

    public T getLoginRequest() {
        return this.loginRequest;
    }

    public LoginTokenResponse getResponse() {
        return this.response;
    }

    public Captcha getCaptcha() {
        return this.captcha;
    }

    public String getHost() {
        return this.host;
    }

    public Set<ResponseCookie> getCookies() {
        return this.cookies;
    }

    public boolean isNeedEncrypt() {
        return this.needEncrypt;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public static class LoginContextBuilder<T extends LoginRequest> {
        private String loginName;
        private String password;
        private Long currentTenantId;
        private Set<Long> tenantIds;
        private Long accountId;
        private User user;
        private Account account;
        private String token;
        private T loginRequest;
        private LoginTokenResponse response;
        private Captcha captcha;
        private String host;
        private Set<ResponseCookie> cookies;
        private boolean needEncrypt$set;
        private boolean needEncrypt$value;
        private boolean success$set;
        private Boolean success$value;

        LoginContextBuilder() {
        }

        public LoginContextBuilder<T> loginName(String loginName) {
            this.loginName = loginName;
            return this;
        }

        public LoginContextBuilder<T> password(String password) {
            this.password = password;
            return this;
        }

        public LoginContextBuilder<T> currentTenantId(Long currentTenantId) {
            this.currentTenantId = currentTenantId;
            return this;
        }

        public LoginContextBuilder<T> tenantIds(Set<Long> tenantIds) {
            this.tenantIds = tenantIds;
            return this;
        }

        public LoginContextBuilder<T> accountId(Long accountId) {
            this.accountId = accountId;
            return this;
        }

        public LoginContextBuilder<T> user(User user) {
            this.user = user;
            return this;
        }

        public LoginContextBuilder<T> account(Account account) {
            this.account = account;
            return this;
        }

        public LoginContextBuilder<T> token(String token) {
            this.token = token;
            return this;
        }

        public LoginContextBuilder<T> loginRequest(T loginRequest) {
            this.loginRequest = loginRequest;
            return this;
        }

        public LoginContextBuilder<T> response(LoginTokenResponse response) {
            this.response = response;
            return this;
        }

        public LoginContextBuilder<T> captcha(Captcha captcha) {
            this.captcha = captcha;
            return this;
        }

        public LoginContextBuilder<T> host(String host) {
            this.host = host;
            return this;
        }

        public LoginContextBuilder<T> cookies(Set<ResponseCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public LoginContextBuilder<T> needEncrypt(boolean needEncrypt) {
            this.needEncrypt$value = needEncrypt;
            this.needEncrypt$set = true;
            return this;
        }

        public LoginContextBuilder<T> success(Boolean success) {
            this.success$value = success;
            this.success$set = true;
            return this;
        }

        public LoginContext<T> build() {
            boolean needEncrypt$value = this.needEncrypt$value;
            if (!this.needEncrypt$set) {
                needEncrypt$value = LoginContext.$default$needEncrypt();
            }
            Boolean success$value = this.success$value;
            if (!this.success$set) {
                success$value = LoginContext.$default$success();
            }
            return new LoginContext<T>(this.loginName, this.password, this.currentTenantId, this.tenantIds, this.accountId, this.user, this.account, this.token, this.loginRequest, this.response, this.captcha, this.host, this.cookies, needEncrypt$value, success$value);
        }

        public String toString() {
            return "LoginContext.LoginContextBuilder(loginName=" + this.loginName + ", password=" + this.password + ", currentTenantId=" + this.currentTenantId + ", tenantIds=" + this.tenantIds + ", accountId=" + this.accountId + ", user=" + this.user + ", account=" + this.account + ", token=" + this.token + ", loginRequest=" + this.loginRequest + ", response=" + this.response + ", captcha=" + this.captcha + ", host=" + this.host + ", cookies=" + this.cookies + ", needEncrypt$value=" + this.needEncrypt$value + ", success$value=" + this.success$value + ")";
        }
    }

    public static class TwoFactorResponse {
        private String processId;
        private String username;

        TwoFactorResponse(String processId, String username) {
            this.processId = processId;
            this.username = username;
        }

        public static TwoFactorResponseBuilder builder() {
            return new TwoFactorResponseBuilder();
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getUsername() {
            return this.username;
        }

        public static class TwoFactorResponseBuilder {
            private String processId;
            private String username;

            TwoFactorResponseBuilder() {
            }

            public TwoFactorResponseBuilder processId(String processId) {
                this.processId = processId;
                return this;
            }

            public TwoFactorResponseBuilder username(String username) {
                this.username = username;
                return this;
            }

            public TwoFactorResponse build() {
                return new TwoFactorResponse(this.processId, this.username);
            }

            public String toString() {
                return "LoginContext.TwoFactorResponse.TwoFactorResponseBuilder(processId=" + this.processId + ", username=" + this.username + ")";
            }
        }
    }

    public static class TwoFactor {
        private TwoFactorType type;
        private Long timeout;
        private TwoFactorResponse response;

        TwoFactor(TwoFactorType type, Long timeout, TwoFactorResponse response) {
            this.type = type;
            this.timeout = timeout;
            this.response = response;
        }

        public static TwoFactorBuilder builder() {
            return new TwoFactorBuilder();
        }

        public void setType(TwoFactorType type) {
            this.type = type;
        }

        public void setTimeout(Long timeout) {
            this.timeout = timeout;
        }

        public void setResponse(TwoFactorResponse response) {
            this.response = response;
        }

        public TwoFactorType getType() {
            return this.type;
        }

        public Long getTimeout() {
            return this.timeout;
        }

        public TwoFactorResponse getResponse() {
            return this.response;
        }

        public static class TwoFactorBuilder {
            private TwoFactorType type;
            private Long timeout;
            private TwoFactorResponse response;

            TwoFactorBuilder() {
            }

            public TwoFactorBuilder type(TwoFactorType type) {
                this.type = type;
                return this;
            }

            public TwoFactorBuilder timeout(Long timeout) {
                this.timeout = timeout;
                return this;
            }

            public TwoFactorBuilder response(TwoFactorResponse response) {
                this.response = response;
                return this;
            }

            public TwoFactor build() {
                return new TwoFactor(this.type, this.timeout, this.response);
            }

            public String toString() {
                return "LoginContext.TwoFactor.TwoFactorBuilder(type=" + (Object)((Object)this.type) + ", timeout=" + this.timeout + ", response=" + this.response + ")";
            }
        }
    }

    public static class Captcha {
        private Boolean needCaptcha;
        private String value;
        private Long timeout;

        Captcha(Boolean needCaptcha, String value, Long timeout) {
            this.needCaptcha = needCaptcha;
            this.value = value;
            this.timeout = timeout;
        }

        public static CaptchaBuilder builder() {
            return new CaptchaBuilder();
        }

        public void setNeedCaptcha(Boolean needCaptcha) {
            this.needCaptcha = needCaptcha;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setTimeout(Long timeout) {
            this.timeout = timeout;
        }

        public Boolean getNeedCaptcha() {
            return this.needCaptcha;
        }

        public String getValue() {
            return this.value;
        }

        public Long getTimeout() {
            return this.timeout;
        }

        public static class CaptchaBuilder {
            private Boolean needCaptcha;
            private String value;
            private Long timeout;

            CaptchaBuilder() {
            }

            public CaptchaBuilder needCaptcha(Boolean needCaptcha) {
                this.needCaptcha = needCaptcha;
                return this;
            }

            public CaptchaBuilder value(String value) {
                this.value = value;
                return this;
            }

            public CaptchaBuilder timeout(Long timeout) {
                this.timeout = timeout;
                return this;
            }

            public Captcha build() {
                return new Captcha(this.needCaptcha, this.value, this.timeout);
            }

            public String toString() {
                return "LoginContext.Captcha.CaptchaBuilder(needCaptcha=" + this.needCaptcha + ", value=" + this.value + ", timeout=" + this.timeout + ")";
            }
        }
    }
}

