/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.login.controller;

import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.config.MessageTemplateProperties;
import com.xforceplus.entity.User;
import com.xforceplus.feign.tenant.message.SmsAuthCodeFeignClient;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.PasswordLoginRequest;
import com.xforceplus.security.login.request.SmsLoginRequest;
import com.xforceplus.security.login.request.TwoFactorPasswordLoginRequest;
import com.xforceplus.security.login.request.TwoFactorSmsLoginRequest;
import com.xforceplus.security.login.response.LoginResponse;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.login.service.LoginService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.utils.RegExUtil;
import com.xforececlound.message.model.AuthCodeResp;
import com.xforececlound.message.model.SmsCodeReq;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Validated
@Controller
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private final LoginService loginService;
    private final UserService userService;
    private final SmsAuthCodeFeignClient smsAuthCodeFeignClient;
    private final MessageTemplateProperties messageTemplateProperties;

    public LoginController(LoginService loginService, UserService userService, SmsAuthCodeFeignClient smsAuthCodeFeignClient, MessageTemplateProperties messageTemplateProperties) {
        this.loginService = loginService;
        this.userService = userService;
        this.smsAuthCodeFeignClient = smsAuthCodeFeignClient;
        this.messageTemplateProperties = messageTemplateProperties;
    }

    @ApiOperation(value="\u5bf9\u5e94\u539f\u6765\u7684 'api/normal/login'")
    @AuthorizedDefinition(authentication=false, authorization=false)
    @ResponseBody
    @PostMapping(value={"/api/security/normal/login"})
    public ResponseEntity<LoginResponse<LoginTokenResponse>> login(@RequestBody @Valid PasswordLoginRequest loginRequest, HttpServletRequest request) {
        LoginContext<PasswordLoginRequest> loginContext = this.loginService.login(loginRequest, request);
        return this.buildResponse(loginContext);
    }

    @ApiOperation(value="\u5bf9\u5e94\u539f\u6765\u7684 'api/sms/login/v2'")
    @AuthorizedDefinition(authentication=false, authorization=false)
    @ResponseBody
    @PostMapping(value={"/api/security/sms/login/v2"})
    public ResponseEntity<LoginResponse<LoginTokenResponse>> smsLoginV2(@RequestBody @Valid SmsLoginRequest loginRequest, HttpServletRequest request) {
        LoginContext<SmsLoginRequest> loginContext = this.loginService.login(loginRequest, request);
        return this.buildResponse(loginContext);
    }

    @ApiOperation(value="\u5bf9\u5e94\u539f\u6765\u7684 'api/sms/login'")
    @AuthorizedDefinition(authentication=false, authorization=false)
    @ResponseBody
    @PostMapping(value={"/api/security/sms/login"})
    public ResponseEntity<LoginResponse<LoginTokenResponse>> smsLogin(@RequestBody @Valid SmsLoginRequest loginRequest, HttpServletRequest request) {
        LoginContext<SmsLoginRequest> loginContext = this.loginService.smsLogin(loginRequest, request);
        return this.buildResponse(loginContext);
    }

    @ApiOperation(value="\u5bf9\u5e94\u539f\u6765\u7684 'api/login/double-auth/code'")
    @ResponseBody
    @PostMapping(value={"/api/security/two-factor/sms/login"})
    public ResponseEntity<LoginResponse<LoginTokenResponse>> login(@RequestBody TwoFactorSmsLoginRequest loginRequest, HttpServletRequest request) {
        LoginContext<TwoFactorSmsLoginRequest> loginContext = this.loginService.login(loginRequest, request);
        return this.buildResponse(loginContext);
    }

    @ApiOperation(value="\u5bf9\u5e94\u539f\u6765\u7684 'api/login/double-auth/pwd'")
    @ResponseBody
    @PostMapping(value={"/api/security/two-factor/password/login"})
    public ResponseEntity<LoginResponse<LoginTokenResponse>> login(@RequestBody @Valid TwoFactorPasswordLoginRequest loginRequest, HttpServletRequest request) {
        LoginContext<TwoFactorPasswordLoginRequest> loginContext = this.loginService.login(loginRequest, request);
        return this.buildResponse(loginContext);
    }

    private <T extends LoginRequest> ResponseEntity<LoginResponse<LoginTokenResponse>> buildResponse(LoginContext<T> loginContext) {
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        Set<ResponseCookie> cookies = loginContext.getCookies();
        if (cookies != null && !cookies.isEmpty()) {
            HttpHeaders cookieHeaders = new HttpHeaders();
            cookies.forEach(cookie -> cookieHeaders.add("Set-Cookie", cookie.toString()));
            responseBuilder = (ResponseEntity.BodyBuilder)responseBuilder.headers(cookieHeaders);
        }
        return responseBuilder.body(LoginResponse.builder().data(loginContext.getResponse()).build());
    }

    @AuthorizedDefinition(authentication=false, authorization=false)
    @ApiOperation(value="\u5bf9\u5e94\u539f\u6765\u7684 'api/sms/login/{phone}'")
    @ResponseBody
    @GetMapping(value={"/api/security/sms/login/{phone}"})
    public LoginResponse<String> sendSms(@PathVariable(value="phone") String phone) {
        if (!RegExUtil.checkMobile((String)phone)) {
            throw new AuthenticationException(0, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801\uff01");
        }
        User user = this.userService.findByUsername(phone, 0);
        if (user == null) {
            throw new AuthenticationException(3, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002");
        }
        if (1 != user.getAccount().getStatus()) {
            throw new AuthenticationException(0, "\u8d26\u53f7\u672a\u542f\u7528\uff01");
        }
        SmsCodeReq smsCodeReq = new SmsCodeReq();
        smsCodeReq.setMobile(phone);
        smsCodeReq.setTemplateCode(this.messageTemplateProperties.getSmsCode());
        smsCodeReq.setExpireTime(Integer.valueOf(3));
        smsCodeReq.setTenantId(user.getTenantId());
        AuthCodeResp authCodeResp = this.smsAuthCodeFeignClient.sendAuthCode(String.valueOf(ObjectUtils.defaultIfNull((Object)user.getTenantId(), (Object)0)), smsCodeReq);
        if (authCodeResp == null) {
            throw new AuthenticationException(0, "\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\u3002");
        }
        if (authCodeResp.getCode() != 1) {
            throw new AuthenticationException(0, authCodeResp.getDesc());
        }
        String msgId = authCodeResp.getMsgId();
        if (StringUtils.isBlank((CharSequence)msgId)) {
            throw new AuthenticationException(0, "\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25");
        }
        return LoginResponse.builder().data(msgId).build();
    }
}

