/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.login.service;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.PasswordLoginRequest;
import com.xforceplus.security.login.request.SmsLoginRequest;
import com.xforceplus.security.login.request.TwoFactorPasswordLoginRequest;
import com.xforceplus.security.login.request.TwoFactorSmsLoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.StrategyFilterChain;
import com.xforceplus.security.strategy.filter.impl.FailTimesPredicationStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.GenerateTokenStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.LoadUserByPasswordStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.LoadUserBySmsStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.PasswordExpiredStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.PasswordValidationStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.PostLoadUserStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.ResponseCookieStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.TwoFactorPasswordLoadUserStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.TwoFactorSmsLoadUserStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.TwoFactorValidStrategyFilter;
import com.xforceplus.security.strategy.filter.impl.UpdateLoginTimeStrategyFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class LoginService
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    public static final String TOKEN_COOKIE_HOST = "token-cookie-host";
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public LoginContext<PasswordLoginRequest> login(PasswordLoginRequest loginRequest, HttpServletRequest request) {
        String host = this.parseHost(request);
        LoginContext<PasswordLoginRequest> loginContext = LoginContext.builder().loginRequest(loginRequest).loginName(loginRequest.getUsername()).host(host).build();
        StrategyFilterChain<PasswordLoginRequest> filterChain = StrategyFilterChain.builder().loginContext(loginContext).build();
        return this.doStrategyFilterChain(filterChain);
    }

    public LoginContext<SmsLoginRequest> login(SmsLoginRequest loginRequest, HttpServletRequest request) {
        String host = this.parseHost(request);
        LoginContext<SmsLoginRequest> loginContext = LoginContext.builder().loginRequest(loginRequest).loginName(loginRequest.getPhone()).host(host).build();
        StrategyFilterChain<SmsLoginRequest> filterChain = StrategyFilterChain.builder().loginContext(loginContext).build();
        return this.doStrategyFilterChain(filterChain);
    }

    public LoginContext<SmsLoginRequest> smsLogin(SmsLoginRequest loginRequest, HttpServletRequest request) {
        String host = this.parseHost(request);
        LoginContext<SmsLoginRequest> loginContext = LoginContext.builder().loginRequest(loginRequest).loginName(loginRequest.getPhone()).host(host).build();
        StrategyFilterChain<SmsLoginRequest> filterChain = StrategyFilterChain.builder().loginContext(loginContext).build();
        return this.doSmsStrategyFilterChain(filterChain);
    }

    public LoginContext<TwoFactorPasswordLoginRequest> login(TwoFactorPasswordLoginRequest loginRequest, HttpServletRequest request) {
        String host = this.parseHost(request);
        LoginContext<TwoFactorPasswordLoginRequest> loginContext = LoginContext.builder().loginRequest(loginRequest).host(host).build();
        StrategyFilterChain<TwoFactorPasswordLoginRequest> filterChain = StrategyFilterChain.builder().loginContext(loginContext).build();
        return this.doStrategyFilterChain(filterChain);
    }

    public LoginContext<TwoFactorSmsLoginRequest> login(TwoFactorSmsLoginRequest loginRequest, HttpServletRequest request) {
        String host = this.parseHost(request);
        LoginContext<TwoFactorSmsLoginRequest> loginContext = LoginContext.builder().loginRequest(loginRequest).host(host).build();
        StrategyFilterChain<TwoFactorSmsLoginRequest> filterChain = StrategyFilterChain.builder().loginContext(loginContext).build();
        return this.doStrategyFilterChain(filterChain);
    }

    private String parseHost(HttpServletRequest request) {
        String host = request.getHeader(TOKEN_COOKIE_HOST);
        log.info("{} : {}", (Object)TOKEN_COOKIE_HOST, (Object)host);
        if (host == null) {
            host = request.getHeader("X-Forwarded-Host");
            log.info("{} : {}", (Object)"X-Forwarded-Host", (Object)host);
        }
        if (host == null) {
            String originRequest = request.getHeader("X-Forwarded-For");
            log.info("{} : {}", (Object)"X-Forwarded-For", (Object)originRequest);
            host = originRequest != null ? UriComponentsBuilder.fromHttpUrl((String)originRequest).build().getHost() : StringUtils.defaultString((String)request.getHeader("Host"), (String)request.getServerName());
        }
        return host;
    }

    private <T extends LoginRequest> LoginContext<T> doStrategyFilterChain(StrategyFilterChain<T> filterChain) {
        filterChain.addFilter(((LoadUserByPasswordStrategyFilter.LoadUserByPasswordStrategyFilterBuilder)((LoadUserByPasswordStrategyFilter.LoadUserByPasswordStrategyFilterBuilder)LoadUserByPasswordStrategyFilter.builder().priority(1)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((LoadUserBySmsStrategyFilter.LoadUserBySmsStrategyFilterBuilder)((LoadUserBySmsStrategyFilter.LoadUserBySmsStrategyFilterBuilder)LoadUserBySmsStrategyFilter.builder().priority(2)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((TwoFactorPasswordLoadUserStrategyFilter.TwoFactorPasswordLoadUserStrategyFilterBuilder)((TwoFactorPasswordLoadUserStrategyFilter.TwoFactorPasswordLoadUserStrategyFilterBuilder)TwoFactorPasswordLoadUserStrategyFilter.builder().priority(3)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((TwoFactorSmsLoadUserStrategyFilter.TwoFactorSmsLoadUserStrategyFilterBuilder)((TwoFactorSmsLoadUserStrategyFilter.TwoFactorSmsLoadUserStrategyFilterBuilder)TwoFactorSmsLoadUserStrategyFilter.builder().priority(4)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((FailTimesPredicationStrategyFilter.FailTimesPredicationStrategyFilterBuilder)((FailTimesPredicationStrategyFilter.FailTimesPredicationStrategyFilterBuilder)FailTimesPredicationStrategyFilter.builder().priority(5)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((PasswordValidationStrategyFilter.PasswordValidationStrategyFilterBuilder)((PasswordValidationStrategyFilter.PasswordValidationStrategyFilterBuilder)PasswordValidationStrategyFilter.builder().priority(6)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((PostLoadUserStrategyFilter.PostLoadUserStrategyFilterBuilder)((PostLoadUserStrategyFilter.PostLoadUserStrategyFilterBuilder)PostLoadUserStrategyFilter.builder().priority(7)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((PasswordExpiredStrategyFilter.PasswordExpiredStrategyFilterBuilder)((PasswordExpiredStrategyFilter.PasswordExpiredStrategyFilterBuilder)PasswordExpiredStrategyFilter.builder().priority(8)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((TwoFactorValidStrategyFilter.TwoFactorValidStrategyFilterBuilder)((TwoFactorValidStrategyFilter.TwoFactorValidStrategyFilterBuilder)TwoFactorValidStrategyFilter.builder().priority(9)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((GenerateTokenStrategyFilter.GenerateTokenStrategyFilterBuilder)((GenerateTokenStrategyFilter.GenerateTokenStrategyFilterBuilder)GenerateTokenStrategyFilter.builder().priority(10)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((ResponseCookieStrategyFilter.ResponseCookieStrategyFilterBuilder)((ResponseCookieStrategyFilter.ResponseCookieStrategyFilterBuilder)ResponseCookieStrategyFilter.builder().priority(11)).applicationContext(this.applicationContext)).build());
        AbstractStrategyFilter updateLoginTimeStrategyFilter = ((UpdateLoginTimeStrategyFilter.UpdateLoginTimeStrategyFilterBuilder)((UpdateLoginTimeStrategyFilter.UpdateLoginTimeStrategyFilterBuilder)UpdateLoginTimeStrategyFilter.builder().priority(12)).applicationContext(this.applicationContext)).build();
        ((UpdateLoginTimeStrategyFilter)updateLoginTimeStrategyFilter).init();
        filterChain.addFilter(updateLoginTimeStrategyFilter);
        filterChain.doFilters();
        return filterChain.getLoginContext();
    }

    private <T extends LoginRequest> LoginContext<T> doSmsStrategyFilterChain(StrategyFilterChain<T> filterChain) {
        filterChain.addFilter(((LoadUserByPasswordStrategyFilter.LoadUserByPasswordStrategyFilterBuilder)((LoadUserByPasswordStrategyFilter.LoadUserByPasswordStrategyFilterBuilder)LoadUserByPasswordStrategyFilter.builder().priority(1)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((LoadUserBySmsStrategyFilter.LoadUserBySmsStrategyFilterBuilder)((LoadUserBySmsStrategyFilter.LoadUserBySmsStrategyFilterBuilder)LoadUserBySmsStrategyFilter.builder().priority(2)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((FailTimesPredicationStrategyFilter.FailTimesPredicationStrategyFilterBuilder)((FailTimesPredicationStrategyFilter.FailTimesPredicationStrategyFilterBuilder)FailTimesPredicationStrategyFilter.builder().priority(3)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((PasswordValidationStrategyFilter.PasswordValidationStrategyFilterBuilder)((PasswordValidationStrategyFilter.PasswordValidationStrategyFilterBuilder)PasswordValidationStrategyFilter.builder().priority(4)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((PostLoadUserStrategyFilter.PostLoadUserStrategyFilterBuilder)((PostLoadUserStrategyFilter.PostLoadUserStrategyFilterBuilder)PostLoadUserStrategyFilter.builder().priority(5)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((PasswordExpiredStrategyFilter.PasswordExpiredStrategyFilterBuilder)((PasswordExpiredStrategyFilter.PasswordExpiredStrategyFilterBuilder)PasswordExpiredStrategyFilter.builder().priority(6)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((GenerateTokenStrategyFilter.GenerateTokenStrategyFilterBuilder)((GenerateTokenStrategyFilter.GenerateTokenStrategyFilterBuilder)GenerateTokenStrategyFilter.builder().priority(7)).applicationContext(this.applicationContext)).build());
        filterChain.addFilter(((ResponseCookieStrategyFilter.ResponseCookieStrategyFilterBuilder)((ResponseCookieStrategyFilter.ResponseCookieStrategyFilterBuilder)ResponseCookieStrategyFilter.builder().priority(8)).applicationContext(this.applicationContext)).build());
        AbstractStrategyFilter updateLoginTimeStrategyFilter = ((UpdateLoginTimeStrategyFilter.UpdateLoginTimeStrategyFilterBuilder)((UpdateLoginTimeStrategyFilter.UpdateLoginTimeStrategyFilterBuilder)UpdateLoginTimeStrategyFilter.builder().priority(9)).applicationContext(this.applicationContext)).build();
        ((UpdateLoginTimeStrategyFilter)updateLoginTimeStrategyFilter).init();
        filterChain.addFilter(updateLoginTimeStrategyFilter);
        filterChain.doFilters();
        return filterChain.getLoginContext();
    }
}

