/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.security.strategy.model.PasswordPatternStrategy;
import com.xforceplus.security.strategy.model.Strategy;
import com.xforceplus.security.strategy.service.StrategyService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class StrategyController {
    private final StrategyService strategyService;
    private final AccountService accountService;

    public StrategyController(StrategyService strategyService, AccountService accountService) {
        this.strategyService = strategyService;
        this.accountService = accountService;
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u5237\u65b0\u79df\u6237\u7b56\u7565\u7f13\u5b58", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/strategies/refresh"}, method={RequestMethod.POST})
    public String refresh() {
        return this.strategyService.refresh();
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u9ed8\u8ba4\u79df\u6237\u7b56\u7565\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/strategies"}, method={RequestMethod.GET})
    public ResponseEntity<List<? super Strategy>> strategies() {
        List<? super Strategy> strategies = this.strategyService.allStrategies();
        return ResponseEntity.ok(strategies);
    }

    @AuthorizedDefinition(authentication=false, authorization=false)
    @ResponseBody
    @RequestMapping(name="\u9ed8\u8ba4\u79df\u6237\u5bc6\u7801\u7b56\u7565\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/strategies/password-patterns"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> passwordPatterns() {
        return ResponseEntity.ok(PasswordPatternStrategy.PATTERN_MAP.keySet());
    }

    @AuthorizedDefinition(authentication=false, authorization=false)
    @ResponseBody
    @RequestMapping(name="\u767b\u5f55\u8d26\u53f7\u6700\u4f73\u79df\u6237\u5bc6\u7801\u7b56\u7565\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{loginName}/password-pattern"}, method={RequestMethod.GET})
    public ResponseEntity<String> findPasswordPatternByLoginName(@PathVariable(value="loginName") String loginName) {
        AccountModel.Request.Login login = new AccountModel.Request.Login();
        login.setUsername(loginName);
        List<Long> tenantIds = this.accountService.findTenantIdsByLogin(login);
        Map<Long, PasswordPatternStrategy> strategyMap = this.strategyService.loadStrategiesMap(new HashSet<Long>(tenantIds), PasswordPatternStrategy.class);
        PasswordPatternStrategy defaultStrategy = new PasswordPatternStrategy();
        strategyMap.values().stream().max((o1, o2) -> o1.compareTo(o2)).ifPresent(strategy -> BeanUtils.copyProperties((Object)strategy, (Object)defaultStrategy));
        Pair<Integer, Pattern> pair = PasswordPatternStrategy.PATTERN_MAP.get(defaultStrategy.getPattern());
        if (pair == null) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u53c2\u6570");
        }
        return ResponseEntity.ok((Object)((Pattern)pair.getValue()).pattern());
    }
}

