/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.StrategyFilter;
import com.xforceplus.security.strategy.model.GenerateTokenStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GenerateTokenFilter
extends StrategyFilter<GenerateTokenStrategy> {
    public static final Logger logger = LoggerFactory.getLogger(GenerateTokenFilter.class);

    @Override
    default public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getUser() == null) {
            logger.info("this {}Filter.loginContext.user = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (loginContext.getAccount() == null) {
            logger.info("this {}Filter.loginContext.account = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (loginContext.getResponse() == null) {
            logger.info("this {}Filter.loginContext.response = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    default public void executeGenerateToken(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.executeGenerateToken is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
    }

    default public void generateToken(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.generateToken is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.info("this {}Filter.support = false, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return;
        }
        this.executeGenerateToken(loginContext);
    }
}

