/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.filter.StrategyFilter;
import com.xforceplus.security.strategy.model.Strategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LoadUserFilter<T extends Strategy>
extends StrategyFilter<T> {
    public static final Logger logger = LoggerFactory.getLogger(LoadUserFilter.class);

    @Override
    default public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        if (this.getApplicationContext() == null) {
            logger.debug("this {}Filter.applicationContext == null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        LoginRequest request = loginContext.getLoginRequest();
        if (request == null) {
            logger.info("this {}Filter.loginContext.request = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    default public void executeLoadUser(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.executeLoadUser is not override, do nothing", (Object)this.strategyClass().getSimpleName());
    }

    default public void loadUser(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.loadUser is not override, do nothing", (Object)this.strategyClass().getSimpleName());
        this.executeLoadUser(loginContext);
        this.wrapUser(loginContext);
    }

    default public void wrapUser(LoginContext<? extends LoginRequest> loginContext) {
        LoginTokenResponse response;
        logger.debug("this {}Filter.wrapUser is not override, do default", (Object)this.strategyClass().getSimpleName());
        User user = loginContext.getUser();
        if (user == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u52a0\u8f7d\u7528\u6237\u4fe1\u606f");
        }
        Account account = user.getAccount();
        if (account == null) {
            response = LoginTokenResponse.builder().modifyPasswordTip(false).doubleAuthFlag(false).build();
        } else {
            loginContext.setAccountId(account.getAccountId());
            response = LoginTokenResponse.builder().email(account.getEmail()).telPhone(account.getTelPhone()).build();
            response.setDoubleAuthFlag(account.getDoubleAuthFlag());
            response.setUsername(user.getUsername());
            response.setPasswdLength(account.getPasswdLength());
            response.setModifyPasswordTip(account.getChangePasswordFlag());
        }
        loginContext.setUser(user);
        loginContext.setCurrentTenantId(user.getTenantId());
        loginContext.setResponse(response);
    }
}

