/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.StrategyFilter;
import com.xforceplus.security.strategy.model.Strategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PostGenerateTokenFilter<T extends Strategy>
extends StrategyFilter<T> {
    public static final Logger logger = LoggerFactory.getLogger(PostGenerateTokenFilter.class);

    @Override
    default public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getToken() == null) {
            logger.debug("this {}Filter.loginContext.token = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (this.getApplicationContext() == null) {
            logger.debug("this {}Filter.applicationContext == null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        User user = loginContext.getUser();
        if (user == null) {
            logger.debug("{}Filter.loginContext.user = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        Account account = loginContext.getAccount();
        if (account == null) {
            logger.debug("{}Filter.loginContext.account = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    default public void executePostGenerateToken(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.executePostGenerateToken is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
    }

    default public void postGenerateToken(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.postGenerateToken is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.debug("this {}Filter.support = false, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return;
        }
        this.executePostGenerateToken(loginContext);
    }
}

