/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.google.common.eventbus.AsyncEventBus;
import com.xforceplus.config.ThreadPoolConfig;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.StrategyFilter;
import com.xforceplus.security.strategy.model.Strategy;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PostLoginSuccessFilter<T extends Strategy>
extends StrategyFilter<T> {
    public static final Logger logger = LoggerFactory.getLogger(PostLoginSuccessFilter.class);
    public static final int CPUS = Runtime.getRuntime().availableProcessors();
    public static final AsyncEventBus ASYNC_EVENT_BUS = new AsyncEventBus((Executor)ThreadPoolConfig.config().corePoolSize(CPUS).maximumPoolSize(CPUS * 2).queueSize(20000).keepAliveTime(60L).timeUnit(TimeUnit.SECONDS).name("post-login-filter").build(), (exception, context) -> logger.error(exception.getMessage(), exception));

    @Override
    default public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        User user = loginContext.getUser();
        if (user == null) {
            logger.info("this {}Filter.loginContext.user = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        Account account = loginContext.getAccount();
        if (account == null) {
            logger.info("this {}Filter.loginContext.account = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (this.getApplicationContext() == null) {
            logger.debug("this {}Filter.applicationContext == null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    default public void executePostLoginSuccess(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.executePostLogin is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
    }

    default public void postLogin(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.postLogin is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.info("this {}Filter.support = false, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return;
        }
        this.executePostLoginSuccess(loginContext);
    }
}

