/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.model.Strategy;
import com.xforceplus.security.strategy.service.StrategyService;
import io.geewit.core.utils.reflection.BeanUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public interface StrategyFilter<T extends Strategy> {
    public static final Logger logger = LoggerFactory.getLogger(StrategyFilter.class);

    public ApplicationContext getApplicationContext();

    public int priority();

    default public Class<T> strategyClass() {
        Type[] types = this.getClass().getGenericInterfaces();
        Class clazz = Arrays.stream(types).filter(type -> type instanceof ParameterizedType).filter(type -> StrategyFilter.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())).findFirst().map(type -> (Class)((ParameterizedType)type).getActualTypeArguments()[0]).orElse(null);
        return clazz;
    }

    public Class<T> getStrategyClass();

    public T defaultStrategy();

    default public <S extends Strategy> Map<Long, S> loadStrategyMap(LoginContext<? extends LoginRequest> loginContext, Class<S> strategyClass) {
        StrategyService strategyService = (StrategyService)this.getApplicationContext().getBean(StrategyService.class);
        Map<Long, S> strategiesMap = strategyService.loadStrategiesMap(loginContext, strategyClass);
        return strategiesMap;
    }

    default public T loadCurrentStrategy(LoginContext<? extends LoginRequest> loginContext) {
        T defaultStrategy = this.defaultStrategy();
        logger.debug("defaultStrategy = {}", defaultStrategy);
        T strategy = this.loadCurrentStrategy(loginContext, this.strategyClass());
        if (strategy != null) {
            logger.debug("strategy = {}", strategy);
            BeanUtils.copyProperties(strategy, defaultStrategy);
        }
        return defaultStrategy;
    }

    default public <S extends Strategy> S loadCurrentStrategy(LoginContext<? extends LoginRequest> loginContext, Class<S> strategyClass) {
        Map<Long, S> strategyMap = this.loadStrategyMap(loginContext, strategyClass);
        Strategy strategy = null;
        if (strategyMap != null && !strategyMap.isEmpty()) {
            if (Comparable.class.isAssignableFrom(this.strategyClass())) {
                strategy = strategyMap.values().stream().max((o1, o2) -> ((Comparable)((Object)o1)).compareTo(o2)).orElse(null);
            } else if (loginContext.getCurrentTenantId() != null && loginContext.getCurrentTenantId() > 0L) {
                Strategy currentStrategy = (Strategy)strategyMap.get(loginContext.getCurrentTenantId());
                logger.debug("currentStrategy = {}", (Object)currentStrategy);
                if (currentStrategy != null) {
                    strategy = currentStrategy;
                }
            }
            if (strategy == null) {
                strategy = (Strategy)strategyMap.get(0L);
            }
        }
        return (S)strategy;
    }

    default public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.support is not override, do nothing", (Object)this.strategyClass().getSimpleName());
        if (loginContext == null) {
            logger.info("this {}Filter.loginContext = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }
}

