/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.GenerateTokenFilter;
import com.xforceplus.security.strategy.filter.LoadUserFilter;
import com.xforceplus.security.strategy.filter.PostGenerateTokenFilter;
import com.xforceplus.security.strategy.filter.PostLoadPredicationFilter;
import com.xforceplus.security.strategy.filter.PostLoadValidationFilter;
import com.xforceplus.security.strategy.filter.PostLoginFailFilter;
import com.xforceplus.security.strategy.filter.PostLoginSuccessFilter;
import com.xforceplus.security.strategy.filter.StrategyFilter;
import com.xforceplus.security.strategy.filter.ValidationFilter;
import com.xforceplus.security.strategy.model.Strategy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyFilterChain<T extends LoginRequest> {
    private static final Logger log = LoggerFactory.getLogger(StrategyFilterChain.class);
    private List<StrategyFilter<? extends Strategy>> filters;
    private LoginContext<T> loginContext;

    public StrategyFilterChain<T> addFilter(StrategyFilter<? extends Strategy> filter) {
        if (this.filters == null) {
            this.filters = Stream.of(filter).collect(Collectors.toList());
        } else {
            this.filters.add(filter);
        }
        return this;
    }

    public void doFilters() {
        this.filters.sort(Comparator.comparing(StrategyFilter::priority));
        ArrayList<ValidationFilter> validationFilters = new ArrayList<ValidationFilter>();
        ArrayList<LoadUserFilter> loadUserFilters = new ArrayList<LoadUserFilter>();
        ArrayList<PostLoadPredicationFilter> postLoadPredicationFilters = new ArrayList<PostLoadPredicationFilter>();
        ArrayList<PostLoadValidationFilter> postLoadValidationFilters = new ArrayList<PostLoadValidationFilter>();
        ArrayList<GenerateTokenFilter> generateTokenFilters = new ArrayList<GenerateTokenFilter>();
        ArrayList<PostGenerateTokenFilter> postGenerateTokenFilters = new ArrayList<PostGenerateTokenFilter>();
        ArrayList<PostLoginSuccessFilter> postLoginSuccessFilters = new ArrayList<PostLoginSuccessFilter>();
        ArrayList<PostLoginFailFilter> postLoginFailFilters = new ArrayList<PostLoginFailFilter>();
        if (CollectionUtils.isNotEmpty(this.filters)) {
            for (StrategyFilter<? extends Strategy> strategyFilter : this.filters) {
                if (strategyFilter instanceof ValidationFilter) {
                    validationFilters.add((ValidationFilter)strategyFilter);
                }
                if (strategyFilter instanceof LoadUserFilter) {
                    loadUserFilters.add((LoadUserFilter)strategyFilter);
                }
                if (strategyFilter instanceof PostLoadPredicationFilter) {
                    postLoadPredicationFilters.add((PostLoadPredicationFilter)strategyFilter);
                }
                if (strategyFilter instanceof PostLoadValidationFilter) {
                    postLoadValidationFilters.add((PostLoadValidationFilter)strategyFilter);
                }
                if (strategyFilter instanceof GenerateTokenFilter) {
                    generateTokenFilters.add((GenerateTokenFilter)strategyFilter);
                }
                if (strategyFilter instanceof PostGenerateTokenFilter) {
                    postGenerateTokenFilters.add((PostGenerateTokenFilter)strategyFilter);
                }
                if (strategyFilter instanceof PostLoginSuccessFilter) {
                    postLoginSuccessFilters.add((PostLoginSuccessFilter)strategyFilter);
                }
                if (!(strategyFilter instanceof PostLoginFailFilter)) continue;
                postLoginFailFilters.add((PostLoginFailFilter)strategyFilter);
            }
        }
        try {
            if (CollectionUtils.isNotEmpty(validationFilters)) {
                validationFilters.forEach(filter -> {
                    if (filter.support(this.loginContext)) {
                        filter.valid(this.loginContext);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(loadUserFilters)) {
                loadUserFilters.forEach(filter -> {
                    if (filter.support(this.loginContext)) {
                        filter.loadUser(this.loginContext);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(postLoadPredicationFilters)) {
                postLoadPredicationFilters.forEach(filter -> {
                    if (filter.support(this.loginContext)) {
                        filter.postLoadPredicate(this.loginContext);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(postLoadValidationFilters)) {
                postLoadValidationFilters.forEach(filter -> {
                    if (filter.support(this.loginContext)) {
                        filter.postLoadValid(this.loginContext);
                    }
                });
            }
        }
        catch (IllegalArgumentException e) {
            log.info(e.getMessage());
            if (CollectionUtils.isNotEmpty(postLoginFailFilters)) {
                postLoginFailFilters.forEach(filter -> {
                    if (filter.support(this.loginContext)) {
                        filter.postLoginFail(this.loginContext);
                    }
                });
            }
            throw new AuthenticationException(0, e.getMessage());
        }
        catch (AuthenticationException e) {
            log.info(e.getMessage());
            throw e;
        }
        if (CollectionUtils.isNotEmpty(generateTokenFilters)) {
            generateTokenFilters.forEach(filter -> {
                if (filter.support(this.loginContext)) {
                    filter.generateToken(this.loginContext);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(postGenerateTokenFilters)) {
            postGenerateTokenFilters.forEach(filter -> {
                if (filter.support(this.loginContext)) {
                    filter.postGenerateToken(this.loginContext);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(postLoginSuccessFilters)) {
            postLoginSuccessFilters.forEach(filter -> {
                if (filter.support(this.loginContext)) {
                    filter.postLogin(this.loginContext);
                }
            });
        }
    }

    StrategyFilterChain(List<StrategyFilter<? extends Strategy>> filters, LoginContext<T> loginContext) {
        this.filters = filters;
        this.loginContext = loginContext;
    }

    public static <T extends LoginRequest> StrategyFilterChainBuilder<T> builder() {
        return new StrategyFilterChainBuilder();
    }

    public List<StrategyFilter<? extends Strategy>> getFilters() {
        return this.filters;
    }

    public LoginContext<T> getLoginContext() {
        return this.loginContext;
    }

    public static class StrategyFilterChainBuilder<T extends LoginRequest> {
        private List<StrategyFilter<? extends Strategy>> filters;
        private LoginContext<T> loginContext;

        StrategyFilterChainBuilder() {
        }

        public StrategyFilterChainBuilder<T> filters(List<StrategyFilter<? extends Strategy>> filters) {
            this.filters = filters;
            return this;
        }

        public StrategyFilterChainBuilder<T> loginContext(LoginContext<T> loginContext) {
            this.loginContext = loginContext;
            return this;
        }

        public StrategyFilterChain<T> build() {
            return new StrategyFilterChain<T>(this.filters, this.loginContext);
        }

        public String toString() {
            return "StrategyFilterChain.StrategyFilterChainBuilder(filters=" + this.filters + ", loginContext=" + this.loginContext + ")";
        }
    }
}

