/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.StrategyFilter;
import com.xforceplus.security.strategy.model.Strategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValidationFilter<T extends Strategy>
extends StrategyFilter<T> {
    public static final Logger logger = LoggerFactory.getLogger(ValidationFilter.class);

    @Override
    default public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext == null) {
            logger.info("this {}Filter.loginContext = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (this.getApplicationContext() == null) {
            logger.debug("this {}Filter.applicationContext == null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    default public void executeValid(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.executeValid is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
    }

    default public void valid(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.valid is not override, do nothing", (Object)this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.info("this {}Filter.support = false, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return;
        }
        this.executeValid(loginContext);
    }
}

